/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorUtil;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.model.Attributes;
import oracle.ide.model.ContentSet;
import oracle.ide.model.ContentSetProvider;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.model.Recognizer;
import oracle.ide.model.RecognizerException;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspaces;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.dialogs.MessageDialog;

public class SaveAsCommand
extends Command {
    protected static final int OK_NAME_CHANGED = 0;
    protected static final int OK_NAME_UNCHANGED = 1;
    protected static final int CANCELED = 2;
    protected Context _context;
    protected Class _nodeClass;
    protected Folder _elementOwner;
    protected URL _newURL;
    protected Node _duplicate;
    private URL _tempFileURL;
    protected boolean _noPlaceToAdd;
    protected ContentSet _sourceContentSet;

    public SaveAsCommand() {
        this(12);
    }

    protected SaveAsCommand(int n) {
        super(n, 2);
    }

    public int doit() throws Exception {
        int n = this.doSaveAs(IdeArb.getString(344));
        return n == 0 ? 0 : 1;
    }

    protected Folder getElementOwner(Element element, Context context, boolean bl) {
        TNode tNode;
        TNode[] tNodeArray;
        Folder folder = Workspaces.findOwner(element, context);
        if (folder == null && bl && (tNodeArray = ExplorerContext.getTNodes(context)) != null && tNodeArray.length > 0 && (tNode = (TNode)tNodeArray[0].getParent()) != null) {
            Folder folder2;
            folder = folder2 = (Folder)tNode.getData();
        }
        return folder;
    }

    protected URL validateNewURL(Recognizer recognizer, URL uRL, URL uRL2) {
        try {
            String string = URLFileSystem.getSuffix(uRL2);
            String string2 = URLFileSystem.getSuffix(uRL);
            if (ModelUtil.hasLength((String)string) && !ModelUtil.hasLength((String)string2)) {
                URL uRL3 = recognizer.validate(uRL, uRL2);
                return uRL3;
            }
            recognizer.validate(uRL, uRL2);
            URL uRL4 = uRL;
            return uRL4;
        }
        catch (RecognizerException recognizerException) {
            String string = recognizerException.getLocalizedMessage();
            if (string == null || string.length() == 0) {
                string = IdeArb.format(244, URLFileSystem.getPlatformPathName(uRL));
            }
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
            URL uRL5 = null;
            return uRL5;
        }
    }

    protected boolean saveFileDlgOK(Context context, Node node, String string) {
        SaveURLChooser saveURLChooser = new SaveURLChooser();
        DialogUtil.initURLChooser(saveURLChooser, context);
        Node node2 = context.getNode();
        saveURLChooser.setSelectedURL(node2.getURL());
        this.setDefaultFilter(saveURLChooser, node2.getURL());
        int n = saveURLChooser.showSaveDialog((Component)((Object)Ide.getMainWindow()), string);
        return n == 0;
    }

    private void setDefaultFilter(URLChooser uRLChooser, URL uRL) {
        URLFilter[] uRLFilterArray = uRLChooser.getChooseableURLFilters();
        int n = 0;
        while (n < uRLFilterArray.length) {
            if (uRLFilterArray[n].accept(uRL)) {
                uRLChooser.setURLFilter(uRLFilterArray[n]);
            }
            ++n;
        }
    }

    protected int doSaveAs(String string) {
        int n = 2;
        this._context = this.getContext();
        Node node = this._context.getNode();
        if (node == null) {
            return n;
        }
        this.getOwningContentSet(node);
        if (!this.saveFileDlgOK(this._context, node, string)) {
            return n;
        }
        if (this._newURL == null) {
            return n;
        }
        if (this._nodeClass != node.getData().getClass()) {
            if (this._duplicate == null) {
                n = this.convertToNewNode(node);
            } else if (this._duplicate != node) {
                n = this.convertToDupNode(node);
            }
        } else if (this._duplicate == null) {
            n = this.saveAsNewNode(node);
        } else if (this._duplicate != node) {
            n = this.saveAsDupNode(node);
        } else {
            node.setURL(this._newURL);
            node.markDirty(true);
            try {
                node.save();
            }
            catch (IOException iOException) {
                System.err.println("**** ERROR: IOException trying to save " + node.getURL());
                System.err.println("****        Reason: " + iOException.getLocalizedMessage());
            }
            n = 1;
        }
        if (n == 0 && this._elementOwner != null && this._elementOwner instanceof Dirtyable && (this._elementOwner != this.context.getProject() || !(this._elementOwner instanceof Project))) {
            ((Dirtyable)((Object)this._elementOwner)).markDirty(true);
        }
        this.removeTempFile();
        return n;
    }

    protected int convertToNewNode(Node node) {
        int n = 2;
        URL uRL = node.getURL();
        try {
            if (this._tempFileURL == null && !this.saveTempFile(node, this._newURL)) {
                int n2 = 2;
                return n2;
            }
            if (URLFileSystem.exists(this._newURL) && !URLFileSystem.delete(this._newURL) || !URLFileSystem.renameTo(this._tempFileURL, this._newURL)) {
                String string = IdeArb.format(248, uRL.getPath());
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
                int n3 = 2;
                return n3;
            }
            Node node2 = NodeFactory.findOrCreate(this._nodeClass, this._newURL);
            node2.open();
            n = this.handleNodeOwnership(node, node2, uRL);
            if (this._noPlaceToAdd || this._context.getView() instanceof Editor) {
                this.openEditor(node2);
            }
        }
        catch (Exception exception) {
            String string = IdeArb.format(247, uRL.getPath(), exception.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
        }
        return n;
    }

    protected int handleNodeOwnership(Node node, Node node2, URL uRL) throws Exception {
        Folder folder = null;
        folder = this._elementOwner != null && this._elementOwner.canAdd(node2) ? this._elementOwner : Ide.getActiveProject();
        if (folder == null) {
            this._noPlaceToAdd = true;
        } else {
            boolean bl = folder.add(node2);
            if (bl) {
                if (folder instanceof Subject) {
                    UpdateMessage.fireChildAdded(folder, node2);
                }
            } else {
                this._noPlaceToAdd = true;
            }
        }
        return 0;
    }

    protected int convertToDupNode(Node node) {
        return this.saveAsDupNode(node);
    }

    protected int saveAsNewNode(Node node) {
        URL uRL = node.getURL();
        try {
            boolean bl = node.isDirty();
            if (bl || node.isNew()) {
                if (this._tempFileURL == null && !this.saveTempFile(node, this._newURL)) {
                    int n = 2;
                    return n;
                }
                if (URLFileSystem.exists(this._newURL) && !URLFileSystem.delete(this._newURL) || !URLFileSystem.renameTo(this._tempFileURL, this._newURL)) {
                    String string = IdeArb.format(248, uRL.getPath());
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
                    int n = 2;
                    return n;
                }
            } else {
                if (URLFileSystem.exists(this._newURL) && !URLFileSystem.delete(this._newURL)) {
                    String string = IdeArb.format(248, uRL.getPath());
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
                    int n = 2;
                    return n;
                }
                URLFileSystem.copy(uRL, this._newURL);
            }
            Node node2 = NodeFactory.findOrCreate(this._nodeClass, this._newURL);
            node2.open();
            this.handleNodeOwnership(node, node2, uRL);
            if (this._noPlaceToAdd || this._context.getView() instanceof Editor) {
                this.openEditor(node2);
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            String string = IdeArb.format(247, uRL.getPath(), exception.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
            return 2;
        }
    }

    protected int saveNode(Node node) {
        URL uRL = node.getURL();
        node.setURL(this._newURL);
        if (!URLFileSystem.isReadOnly(this._newURL) || URLFileSystem.setReadOnly(this._newURL, false)) {
            node.markDirty(true);
            node.isReadOnly();
            try {
                node.save();
            }
            catch (IOException iOException) {
                node.setURL(uRL);
                System.err.println("**** ERROR: IOException trying to save " + node.getURL());
                System.err.println("****        Reason: " + iOException.getLocalizedMessage());
                int n = 2;
                return n;
            }
        }
        return 0;
    }

    protected int saveAsDupNode(Node node) {
        int n = this.verifyCloseChildren(node);
        if (n != 0) {
            return n;
        }
        URL uRL = node.getURL();
        try {
            this._duplicate.close();
            if (node.isNew()) {
                node.save();
            }
            URLFileSystem.copy(uRL, this._newURL);
            this._duplicate.open();
            boolean bl = false;
            if (this._elementOwner != null) {
                this._elementOwner.remove(node);
                if (this._elementOwner != this.getElementOwner(this._duplicate, this._context, false) && this._elementOwner.canAdd(this._duplicate)) {
                    this._elementOwner.add(this._duplicate);
                    bl = true;
                }
            }
            RenameMessage.fireObjectRenamed(node, uRL, node, bl ? this._duplicate : null, this._context);
            if (this._elementOwner instanceof Subject) {
                Subject subject = (Subject)((Object)this._elementOwner);
                RenameMessage.fireChildRenamed(subject, uRL, node, bl ? this._duplicate : null, this._context);
            }
            n = 0;
        }
        catch (Exception exception) {
            String string = IdeArb.format(247, uRL.getPath(), exception.toString());
            MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
        }
        return n;
    }

    protected boolean isSameFile(URL uRL, URL uRL2) {
        return URLFileSystem.equals(uRL, uRL2);
    }

    protected boolean approveNewURL(URL uRL) {
        this._newURL = uRL;
        if (uRL != null) {
            if (uRL.getPath().indexOf("*") >= 0) {
                String string = IdeArb.format(244, URLFileSystem.getPlatformPathName(uRL));
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
                return false;
            }
            Node node = this._context.getNode();
            URL uRL2 = node.getURL();
            this._elementOwner = this.getElementOwner(node, this._context, true);
            Recognizer recognizer = Recognizer.findRecognizer(uRL);
            Recognizer recognizer2 = Recognizer.findRecognizer(uRL2);
            if (this.isSuffixEqual(uRL, uRL2)) {
                recognizer = recognizer2;
                this._nodeClass = node.getData().getClass();
            }
            if (recognizer == null) {
                if (recognizer2 != null) {
                    this._newURL = this.validateNewURL(recognizer2, uRL, uRL2);
                    if (this._newURL == null) {
                        return false;
                    }
                    this._nodeClass = recognizer2.recognize(this._newURL);
                } else {
                    this._newURL = uRL;
                    this._nodeClass = Recognizer.recognizeURL(this._newURL);
                }
                if (this._nodeClass == null) {
                    if (this.saveTempFile(node, this._newURL)) {
                        this._nodeClass = Recognizer.recognizeURL(this._tempFileURL);
                        if (this._nodeClass == null) {
                            this._nodeClass = Recognizer.getDefaultNodeType();
                        }
                    } else {
                        this._nodeClass = Recognizer.getDefaultNodeType();
                    }
                }
            } else {
                this._newURL = this.validateNewURL(recognizer, uRL, uRL2);
                if (this._newURL == null) {
                    this.removeTempFile();
                    return false;
                }
                if (this._nodeClass == null) {
                    this._nodeClass = recognizer.recognize(this._newURL);
                }
            }
            boolean bl = this.isSameFile(this._newURL, uRL2);
            if (bl && URLFileSystem.exists(uRL2)) {
                String string = IdeArb.getString(251);
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string, (String)IdeArb.getString(240), null);
                this.removeTempFile();
                return false;
            }
            this._duplicate = NodeFactory.find(this._newURL);
            String string = URLFileSystem.getPlatformPathName(this._newURL);
            if (this._duplicate != null && this._duplicate != node) {
                String string2 = null;
                if (this._elementOwner != null && this._elementOwner.containsChild(this._duplicate)) {
                    string2 = IdeArb.format(250, string);
                } else if (this._duplicate.isOpen()) {
                    string2 = IdeArb.format(249, string);
                }
                if (string2 != null) {
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string2, (String)IdeArb.getString(240), null);
                    this.removeTempFile();
                    return false;
                }
            }
            if (URLFileSystem.exists(this._newURL) && !URLFileSystem.equals(this._newURL, uRL2)) {
                String string3 = IdeArb.format(242, string);
                int n = MessageDialog.confirmOrCancel((Component)((Object)Ide.getMainWindow()), (Object)string3, (String)IdeArb.getString(243));
                if (n != 1) {
                    this.removeTempFile();
                    return false;
                }
                if (URLFileSystem.isReadOnly(this._newURL)) {
                    string3 = IdeArb.format(246, string);
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string3, (String)IdeArb.getString(240), null);
                    this.removeTempFile();
                    return false;
                }
            }
            if (this._nodeClass != node.getData().getClass() && recognizer != null && !recognizer.canConvert(uRL2, this._newURL)) {
                String string4 = IdeArb.format(241, uRL2.getFile(), this._newURL.getFile());
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)string4, (String)IdeArb.getString(240), null);
                this.removeTempFile();
                return false;
            }
            if (this.validateLocation()) {
                return true;
            }
            this.removeTempFile();
            return false;
        }
        this.removeTempFile();
        return false;
    }

    private int verifyCloseChildren(Node node) {
        if (!node.mayHaveChildren()) {
            return 0;
        }
        CloseNodeCommand closeNodeCommand = new CloseNodeCommand();
        closeNodeCommand.setContext(this._context);
        return closeNodeCommand.close(node, false, true);
    }

    private boolean validateLocation() {
        if (this._sourceContentSet == null) {
            return true;
        }
        if (this._sourceContentSet.canHaveMember(this._newURL)) {
            return true;
        }
        int n = this.doesUserWantToSeeFile();
        if (n == 1) {
            return this.selectContentSet();
        }
        return n == 0;
    }

    private int doesUserWantToSeeFile() {
        return MessageDialog.confirmOrCancel((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(450), (String)IdeArb.getString(243));
    }

    private boolean selectContentSet() {
        Context context = new Context(this.getContext().getWorkspace(), this.getContext().getProject());
        int n = 0;
        try {
            Node node = NodeFactory.findOrCreate(this._newURL);
            context.setNode(node);
            AddContentCommand addContentCommand = new AddContentCommand();
            addContentCommand.setContext(context);
            n = addContentCommand.doit();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            throwable.printStackTrace();
        }
        return n != true;
    }

    private void openEditor(Node node) {
        Context context = new Context(this.getContext());
        context.setNode(node);
        Element[] elementArray = new Element[]{node};
        context.setSelection(elementArray);
        EditorUtil.openDefaultEditorInFrame(node, context);
    }

    private void removeTempFile() {
        if (this._tempFileURL != null) {
            URLFileSystem.delete(this._tempFileURL);
            this._tempFileURL = null;
        }
    }

    private boolean saveTempFile(Node node, URL uRL) {
        URL uRL2 = node.getURL();
        boolean bl = node.isDirty();
        String string = URLFileSystem.getSuffix(uRL);
        URL uRL3 = null;
        try {
            if (!URLFileSystem.exists(URLFileSystem.getParent(uRL))) {
                URLFileSystem.mkdirs(URLFileSystem.getParent(uRL));
            }
            if ((uRL3 = URLFileSystem.createTempFile("jdev", string, URLFileSystem.getParent(uRL))) == null) {
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (IOException iOException) {
            boolean bl3 = false;
            return bl3;
        }
        if (!node.isOpen()) {
            try {
                node.open();
            }
            catch (IOException iOException) {
                System.err.println("**** ERROR: Unable to open " + node.getURL());
                System.err.println("****        Reason: " + iOException.getLocalizedMessage());
                URLFileSystem.delete(uRL3);
                boolean bl4 = false;
                return bl4;
            }
        }
        TextBuffer textBuffer = null;
        TextNode textNode = null;
        if (node instanceof TextNode) {
            textNode = (TextNode)node;
            textBuffer = textNode.acquireTextBuffer();
        }
        node.setURL(uRL3);
        node.markDirty(true);
        try {
            node.save();
        }
        catch (Exception exception) {
            this.resetNode(node, uRL2, bl, textNode);
            boolean bl5 = false;
            return bl5;
        }
        this.resetNode(node, uRL2, bl, textNode);
        this._tempFileURL = uRL3;
        textBuffer = null;
        return true;
    }

    private void resetNode(Node node, URL uRL, boolean bl, TextNode textNode) {
        node.setURL(uRL);
        node.markDirty(bl);
        if (textNode != null) {
            textNode.releaseTextBuffer();
        }
        if (!bl) {
            Attributes attributes = node.getAttributes().duplicate();
            UpdateMessage.fireAttributeChanged(node, attributes);
        }
    }

    private boolean isSuffixEqual(URL uRL, URL uRL2) {
        if (uRL == null || uRL2 == null) {
            return false;
        }
        String string = URLFileSystem.getSuffix(uRL);
        String string2 = URLFileSystem.getSuffix(uRL2);
        if (string.length() == 0 && string2.length() == 0) {
            return false;
        }
        return string.equals(string2);
    }

    protected void getOwningContentSet(Node node) {
        ContentSetProvider[] contentSetProviderArray = ProjectContent.getContentSetProviders();
        int n = 0;
        while (n < contentSetProviderArray.length) {
            String string = contentSetProviderArray[n].getKey();
            ContentSet contentSet = ContentSet.getInstance(this.context.getProject(), string);
            if (contentSet.canHaveMember(node.getURL())) {
                this._sourceContentSet = contentSet;
                break;
            }
            ++n;
        }
    }

    private class SaveURLChooser
    extends URLChooser {
        private static final String HELP_TOPIC = "f1_idedsaveasrename_html";

        SaveURLChooser() {
            this.setHelpID(HELP_TOPIC);
        }

        protected URL canonicalizeApprovalURL(URL uRL) {
            if (URLFileSystem.isDirectory(uRL)) {
                return URLFileSystem.canonicalize(uRL);
            }
            String string = URLFileSystem.getFileName(uRL);
            URL uRL2 = URLFileSystem.canonicalize(URLFileSystem.getParent(uRL));
            return URLFactory.newURL(uRL2, string);
        }

        protected URL getApprovalFileListURL() {
            return null;
        }

        protected boolean checkApprovalParentExists(URL uRL) {
            if (SaveAsCommand.this.getId() == 14) {
                return true;
            }
            return super.checkApprovalParentExists(uRL);
        }

        public boolean approveSelection() {
            if (!super.approveSelection()) {
                return false;
            }
            URL uRL = this.getSelectedURL();
            return SaveAsCommand.this.approveNewURL(uRL);
        }
    }
}

