/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd;

import java.io.IOException;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.checkboxlist.CheckBoxListModel;
import oracle.ide.dialogs.SelectFilesPanel;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;

public class SaveCommand
extends Command {
    public SaveCommand() {
        super(11);
    }

    public int doit() {
        int n = 0;
        Context context = this.getContext();
        Element[] elementArray = context.getSelection();
        Node node = null;
        CheckBoxListModel checkBoxListModel = new CheckBoxListModel();
        if (elementArray == null || elementArray.length == 0 || !(elementArray[0] instanceof Node)) {
            node = context.getNode();
            String string = null;
            try {
                if (!this._saveNode(node, true)) {
                    string = URLFileSystem.getPlatformPathName(node.getURL());
                }
            }
            catch (IOException iOException) {
                string = IdeArb.format(302, URLFileSystem.getPlatformPathName(node.getURL()), iOException.getLocalizedMessage());
            }
            if (string != null) {
                checkBoxListModel.addElement(node, node.getIcon(), false, false, string);
            }
        } else {
            int n2 = elementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Element element = elementArray[n3];
                if (element instanceof Node) {
                    node = (Node)element;
                    String string = null;
                    try {
                        if (this._saveNode(node, false)) {
                            ++n;
                        } else {
                            string = URLFileSystem.getPlatformPathName(node.getURL());
                        }
                    }
                    catch (IOException iOException) {
                        string = IdeArb.format(302, URLFileSystem.getPlatformPathName(node.getURL()), iOException.getLocalizedMessage());
                    }
                    if (string != null) {
                        checkBoxListModel.addElement(node, node.getIcon(), false, false, string);
                    }
                }
                ++n3;
            }
            String string = IdeArb.format(298, new Integer(n));
            Ide.getStatusBar().setText(string);
        }
        if (checkBoxListModel.getSize() > 0) {
            SelectFilesPanel.showDialog(IdeArb.getString(286), IdeArb.format(301, checkBoxListModel.findTextForElement(0)), IdeArb.getString(300), checkBoxListModel, false, -1, "f1_idedunabletosavefiles_html");
        }
        return 0;
    }

    private boolean _saveNode(Node node, boolean bl) throws IOException {
        if (node != null) {
            WaitCursor waitCursor = Ide.getWaitCursor();
            waitCursor.show();
            try {
                if (node.isReadOnly()) {
                    URLFileSystem.setReadOnly(node.getURL(), false);
                }
                node.save();
                if (bl) {
                    String string = IdeArb.format(297, URLFileSystem.getPlatformPathName(node.getURL()));
                    Ide.getStatusBar().setText(string);
                }
                boolean bl2 = true;
                waitCursor.hide();
                return bl2;
            }
            catch (Throwable throwable) {
                waitCursor.hide();
                throw throwable;
            }
        }
        return false;
    }
}

