/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd.buffer;

import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.buffer.Edit;
import oracle.ide.controller.Command;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.buffer.TextBuffer;

final class EditCommand
extends Command {
    private static final int EB_COMMAND_ID = Ide.findOrCreateCmdID(EditCommand.class.getName());
    private static final UndoableEdit EDIT_NOT_APPLIED = new CompoundEdit();
    private TextNode textNode;
    private Object origin;
    private Edit edit;
    private UndoableEdit undoableEdit;

    EditCommand(Edit edit, Node node, Object object) {
        super(EB_COMMAND_ID, edit.isUndoable() ? 0 : 2, edit.getUndoName());
        this.edit = edit;
        Context context = Context.newIdeContext(node);
        this.setContext(context);
        this.textNode = (TextNode)node;
        this.origin = object;
        this.undoableEdit = EDIT_NOT_APPLIED;
    }

    private void notifyObservers() {
        Subject subject = this.textNode;
        UpdateMessage updateMessage = new UpdateMessage(UpdateMessage.CONTENT_MODIFIED, this.origin);
        subject.notifyObservers(subject, updateMessage);
    }

    private boolean isReadOnly() {
        return this.textNode.isReadOnly();
    }

    public final int doit() throws Exception {
        int n = 1;
        if (this.isReadOnly()) {
            return n;
        }
        if (this.edit != null) {
            boolean bl = false;
            TextBuffer textBuffer = this.textNode.acquireTextBuffer();
            textBuffer.beginEdit();
            try {
                try {
                    this.edit.applyEdit(textBuffer);
                }
                catch (RuntimeException runtimeException) {
                    bl = true;
                }
            }
            finally {
                this.undoableEdit = textBuffer.endEdit();
                this.edit = null;
                this.textNode.releaseTextBuffer();
            }
            if (this.undoableEdit != null) {
                if (bl) {
                    try {
                        this.undoableEdit.undo();
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                    this.undoableEdit = null;
                } else {
                    n = 0;
                    if (this.getType() != 0) {
                        this.undoableEdit = null;
                    }
                }
            }
        } else if (this.undoableEdit != null) {
            this.undoableEdit.redo();
            n = 0;
        }
        if (n == 0) {
            this.notifyObservers();
        }
        this.origin = null;
        return n;
    }

    public final int undo() throws Exception {
        int n = 1;
        if (this.isReadOnly()) {
            return n;
        }
        if (this.undoableEdit == EDIT_NOT_APPLIED) {
            throw new IllegalStateException("edit not applied yet");
        }
        if (this.undoableEdit == null) {
            throw new IllegalStateException("no edit to undo");
        }
        this.undoableEdit.undo();
        n = 0;
        if (n == 0) {
            this.notifyObservers();
        }
        return n;
    }
}

