/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.cmd.buffer;

import oracle.ide.cmd.buffer.Edit;
import oracle.javatools.buffer.TextBuffer;

final class SimpleEdit
extends Edit {
    static final int INSERT_EDIT = 1;
    static final int REMOVE_EDIT = 2;
    static final int REPLACE_EDIT = 3;
    static final int REPLACEALL_EDIT = 4;
    private int editType;
    private char[] editData;
    private int startOffset;
    private int endOffset;
    private boolean isUndoable;
    private String editName;

    SimpleEdit(int n, char[] cArray, int n2, int n3, boolean bl, String string) {
        this.editType = n;
        this.editData = cArray;
        this.startOffset = n2;
        this.endOffset = n3;
        this.isUndoable = bl;
        this.editName = string == null ? "" : string;
    }

    public void applyEdit(TextBuffer textBuffer) {
        switch (this.editType) {
            case 1: {
                textBuffer.insert(this.startOffset, this.editData);
                break;
            }
            case 2: {
                textBuffer.remove(this.startOffset, this.endOffset - this.startOffset);
                break;
            }
            case 3: {
                textBuffer.remove(this.startOffset, this.endOffset - this.startOffset);
                textBuffer.insert(this.startOffset, this.editData);
                break;
            }
            case 4: {
                textBuffer.removeToEnd(0);
                textBuffer.append(this.editData);
            }
        }
    }

    public boolean isUndoable() {
        return this.isUndoable;
    }

    public String getUndoName() {
        return this.editName;
    }
}

