/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.component;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.component.NewFileValidator;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.StringUtil;

public class NewFilePanel
extends JPanel
implements VetoableChangeListener {
    private URL _url;
    private URL _rootUrl;
    private String _ext;
    private String _type;
    private boolean _canOverwriteOpenNodes;
    private boolean _showExtension;
    private boolean _isInteractive;
    private boolean _supportsAutoFill;
    private boolean _enforceFileExtension;
    private NewFileValidator _validator;
    private JEWTDialog _dlg;
    GridBagLayout gridBagLayout1;
    JLabel lblDirectory;
    URLTextField fldDirectory;
    JButton btnDirBrowse;
    JLabel lblFile;
    JTextField fldFile;

    void $init$() {
        this._ext = "";
        this._type = "file";
        this._canOverwriteOpenNodes = true;
        this._showExtension = true;
        this._isInteractive = true;
        this._supportsAutoFill = true;
        this._enforceFileExtension = true;
        this.gridBagLayout1 = new GridBagLayout();
        this.lblDirectory = new JLabel();
        this.fldDirectory = new DirURLTextField();
        this.btnDirBrowse = new JButton();
        this.lblFile = new JLabel();
        this.fldFile = new JTextField();
    }

    public NewFilePanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fldFile.setName("new-file-panel#file-field");
        this.fldDirectory.setName("new-file-panel#directory-field");
        this.btnDirBrowse.setName("new-file-panel#directory-browse-button");
    }

    public void setSupportsAutoFill(boolean bl) {
        this._supportsAutoFill = bl;
    }

    public boolean isSupportsAutoFill() {
        return this._supportsAutoFill;
    }

    public void setInteractiveMode(boolean bl) {
        this._isInteractive = bl;
    }

    public void setFileExtension(String string) {
        this._ext = string;
    }

    public void setEnforceFileExtension(boolean bl) {
        this._enforceFileExtension = bl;
    }

    public void setFileType(String string) {
        this._type = string;
    }

    public void setNewFileURLValidator(NewFileValidator newFileValidator) {
        this._validator = newFileValidator;
    }

    public NewFileValidator getNewFileURLValidator() {
        return this._validator;
    }

    public void setCanOverwriteOpenNodes(boolean bl) {
        this._canOverwriteOpenNodes = bl;
    }

    public URL runDialog(String string) {
        URL uRL = null;
        if (OnePageWizardDialogFactory.runDialog(this, this.fldFile, string, 7, this)) {
            try {
                uRL = this.getFileURL();
            }
            catch (TraversalException traversalException) {
                traversalException.printStackTrace();
            }
        }
        return uRL;
    }

    public URL runDialog(String string, Runnable runnable) {
        if (runnable == null) {
            return this.runDialog(string);
        }
        URL uRL = null;
        this._dlg = OnePageWizardDialogFactory.createJEWTDialog(this, this.fldFile, string, 7);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)this);
        this._dlg.addVetoableChangeListener((VetoableChangeListener)new 1(this, runnable));
        if (this._dlg.runDialog()) {
            try {
                uRL = this.getFileURL(false);
            }
            catch (TraversalException traversalException) {
                traversalException.printStackTrace();
            }
        }
        this._dlg.dispose();
        this._dlg = null;
        return uRL;
    }

    public void resetURLCache() {
        this._url = null;
    }

    public URL getFileURL() throws TraversalException {
        return this.getFileURL(true);
    }

    public URL getFileURL(boolean bl) throws TraversalException {
        if (this._url == null) {
            URL uRL;
            block13: {
                uRL = null;
                try {
                    uRL = this.getDirectoryURL();
                }
                catch (TraversalException traversalException) {
                    if (!this._isInteractive) break block13;
                    throw traversalException;
                }
            }
            if (uRL != null) {
                String string = this.fldFile.getText().trim();
                int n = string.length();
                if (this._enforceFileExtension && string.endsWith(".")) {
                    string = string.substring(0, n - 1);
                    --n;
                }
                if (!string.endsWith(this._ext) && (0 > string.indexOf(".") || this._enforceFileExtension)) {
                    string = string + this._ext;
                }
                URL uRL2 = URLFactory.newURL(uRL, string);
                if (this._isInteractive) {
                    String string2;
                    int n2 = string.lastIndexOf(46);
                    if (n2 != -1 && (string2 = string.substring(0, n2)).length() == 0) {
                        n = 0;
                    }
                    if (n <= 0) {
                        throw new TraversalException(ComponentArb.getString(33), ComponentArb.getString(24), null);
                    }
                    if (string.indexOf(File.separatorChar) != -1 || string.indexOf(47) != -1) {
                        throw new TraversalException(ComponentArb.getString(34), ComponentArb.getString(24), null);
                    }
                    if (this._validator != null) {
                        uRL2 = this._validator.validateNewFileURL(uRL2);
                    }
                    if (bl) {
                        this._url = NewFilePanel.validateURL(this, uRL2, this._type, this._canOverwriteOpenNodes);
                    }
                } else {
                    this._url = uRL2;
                }
            }
        }
        return this._url;
    }

    public static URL validateURL(Component component, URL uRL, String string, boolean bl) throws TraversalException {
        if (URLFileSystem.canCreate(uRL)) {
            Node node = NodeFactory.find(uRL);
            boolean bl2 = node != null;
            boolean bl3 = URLFileSystem.exists(uRL);
            if (bl3 && !URLFileSystem.canWrite(uRL)) {
                throw new TraversalException(ComponentArb.format(29, string, URLFileSystem.getPlatformPathName(uRL)), ComponentArb.getString(24), null);
            }
            if (bl2 && node.isOpen()) {
                if (bl) {
                    if (NewFilePanel._checkForOverwrite(component, URLFileSystem.getPlatformPathName(uRL), string)) {
                        return uRL;
                    }
                    throw new TraversalException(null);
                }
                throw new TraversalException(ComponentArb.format(31, string, URLFileSystem.getPlatformPathName(uRL)), ComponentArb.getString(24), null);
            }
            if (!bl3 || NewFilePanel._checkForOverwrite(component, URLFileSystem.getPlatformPathName(uRL), string)) {
                return uRL;
            }
            throw new TraversalException(null);
        }
        String string2 = URLFileSystem.getPlatformPathName(uRL);
        if (string2.length() > 80) {
            string2 = StringUtil.truncateFileNameForMessage((String)string2);
        }
        throw new TraversalException(ComponentArb.format(28, string, string2), ComponentArb.getString(24), null);
    }

    public void setDirectoryURL(URL uRL) {
        this.fldDirectory.setURL(uRL);
        this.resetURLCache();
    }

    public void setDefaultDirectoryName(URL uRL) {
        String string = this.getFileNameWithoutExtension();
        this.fldDirectory.setURL(URLFactory.newURL(uRL, string));
    }

    public void setFileName(String string) {
        if (this.isShowExtension()) {
            if (ModelUtil.hasLength((String)this._ext) && ModelUtil.hasLength((String)string) && !string.endsWith(this._ext)) {
                string = string + this._ext;
            }
        } else if (string.endsWith(this._ext)) {
            string = string.substring(0, string.length() - this._ext.length());
        }
        this.fldFile.setText(string);
        this.resetURLCache();
    }

    public void setShowExtension(boolean bl) {
        this._showExtension = bl;
    }

    public void setDirectoryPrompt(String string) {
        ResourceUtils.resLabel(this.lblDirectory, (Component)((Object)this.fldDirectory), string);
    }

    public void setFilePrompt(String string) {
        ResourceUtils.resLabel(this.lblFile, this.fldFile, string);
    }

    public JComponent getDefaultFocusComponent() {
        return this.fldFile;
    }

    public void requestFocus() {
        this.fldFile.requestFocus();
    }

    public JTextField getDirectoryField() {
        return this.fldDirectory;
    }

    public JTextField getFileField() {
        return this.fldFile;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)propertyChangeEvent)) {
            URL uRL = null;
            try {
                uRL = this.getFileURL();
            }
            catch (TraversalException traversalException) {
                throw new PropertyVetoException("no", propertyChangeEvent);
            }
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel(this.lblDirectory, (Component)((Object)this.fldDirectory), ComponentArb.getString(18));
        ResourceUtils.resButton(this.btnDirBrowse, ComponentArb.getString(19));
        this.btnDirBrowse.addActionListener(this.fldDirectory);
        ResourceUtils.resLabel(this.lblFile, this.fldFile, ComponentArb.getString(20));
        FileNameListener fileNameListener = new FileNameListener(null);
        this.fldFile.getDocument().addDocumentListener(fileNameListener);
        this.fldFile.addKeyListener(fileNameListener);
        this.setLayout(this.gridBagLayout1);
        this.add((Component)this.lblFile, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add((Component)this.fldFile, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lblDirectory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.add((Component)((Object)this.fldDirectory), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 10, 0));
        this.add((Component)this.btnDirBrowse, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
    }

    private static boolean _checkForOverwrite(Component component, String string, String string2) {
        return MessageDialog.confirm(component, ComponentArb.format(30, string2, string), ComponentArb.getString(25), null, true);
    }

    private boolean isShowExtension() {
        return this._showExtension;
    }

    private URL getDirectoryURL() throws TraversalException {
        if (!ModelUtil.hasLength((String)this.fldDirectory.getText())) {
            throw new TraversalException(ComponentArb.getString(27), ComponentArb.getString(23), null);
        }
        URL uRL = this.fldDirectory.getURL();
        if (uRL == null) {
            throw new TraversalException(ComponentArb.format(26, this.fldDirectory.getText().trim()), ComponentArb.getString(23), null);
        }
        if (!URLFileSystem.isValid(uRL)) {
            String string = URLFileSystem.getPlatformPathName(uRL);
            if (string.length() > 80) {
                string = StringUtil.truncateFileNameForMessage((String)string);
                throw new TraversalException(ComponentArb.format(28, ComponentArb.getString(37), string), ComponentArb.getString(23), null);
            }
            throw new TraversalException(ComponentArb.format(26, this.fldDirectory.getText().trim()), ComponentArb.getString(23), null);
        }
        return uRL;
    }

    private void setRootURL(URL uRL) {
        if (!uRL.equals(this._rootUrl)) {
            this._rootUrl = uRL;
        }
    }

    private String getFileNameWithoutExtension() {
        String string = this.fldFile.getText();
        string = string.endsWith(this._ext) ? string.substring(0, string.length() - this._ext.length()) : string;
        return string;
    }

    private void enableOK() {
        if (this._dlg != null) {
            this._dlg.setOKButtonEnabled(this.fldFile.getText().trim().length() > 0 && this.fldDirectory.getText().trim().length() > 0);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.lblDirectory.setEnabled(bl);
        this.fldDirectory.setEnabled(bl);
        this.fldDirectory.setEditable(bl);
        this.lblFile.setEnabled(bl);
        this.fldFile.setEnabled(bl);
        this.fldFile.setEditable(bl);
        this.btnDirBrowse.setEnabled(bl);
    }

    static String mav$getFileNameWithoutExtension(NewFilePanel newFilePanel) {
        return newFilePanel.getFileNameWithoutExtension();
    }

    static URL ra$_rootUrl(NewFilePanel newFilePanel) {
        return newFilePanel._rootUrl;
    }

    static void mav$enableOK(NewFilePanel newFilePanel) {
        newFilePanel.enableOK();
    }

    static void wa$_supportsAutoFill(NewFilePanel newFilePanel, boolean bl) {
        newFilePanel._supportsAutoFill = bl;
    }

    static void mav$setRootURL(NewFilePanel newFilePanel, URL uRL) {
        newFilePanel.setRootURL(uRL);
    }

    static void wa$_rootUrl(NewFilePanel newFilePanel, URL uRL) {
        newFilePanel._rootUrl = uRL;
    }

    public final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ Runnable v$runnable;
        final /* synthetic */ NewFilePanel this$0;

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            this.v$runnable.run();
        }

        public 1(NewFilePanel newFilePanel, Runnable runnable) {
            this.v$runnable = runnable;
            this.this$0 = newFilePanel;
        }
    }

    private class FileNameListener
    implements KeyListener,
    DocumentListener {
        private String lastFileName;

        void $init$() {
            this.lastFileName = "";
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateDir();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateDir();
        }

        private void updateDir() {
            if (NewFilePanel.this.isSupportsAutoFill()) {
                String string = NewFilePanel.this.fldFile.getText();
                URL uRL = URLFactory.newDirURL(NewFilePanel.ra$_rootUrl(NewFilePanel.this), string);
                URL uRL2 = URLFactory.newURL(uRL, string);
                if (URLFileSystem.canCreate(uRL2) && this.isAutoFill()) {
                    NewFilePanel.this.fldDirectory.setText(URLFileSystem.getPlatformPathName(uRL));
                }
            }
        }

        private boolean isAutoFill() {
            if (!NewFilePanel.this.isSupportsAutoFill()) {
                return false;
            }
            String string = this.lastFileName;
            String string2 = NewFilePanel.mav$getFileNameWithoutExtension(NewFilePanel.this);
            if (!this.lastFileName.equals(string2)) {
                this.lastFileName = string2;
            }
            return NewFilePanel.this.fldDirectory.getText().endsWith(string);
        }

        public void keyTyped(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (File.separatorChar == c || '*' == c || ':' == c || '|' == c) {
                keyEvent.consume();
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        private FileNameListener() {
            this.$init$();
        }

        FileNameListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DirURLTextField
    extends URLTextField
    implements FocusListener,
    DocumentListener {
        private String dir;

        DirURLTextField() {
            this.addFocusListener(this);
            this.getDocument().addDocumentListener(this);
        }

        public void setURL(URL uRL) {
            super.setURL(uRL);
            if (uRL != null) {
                if (NewFilePanel.this.fldDirectory.getText().endsWith(NewFilePanel.mav$getFileNameWithoutExtension(NewFilePanel.this))) {
                    NewFilePanel.mav$setRootURL(NewFilePanel.this, URLFileSystem.getParent(uRL));
                } else {
                    NewFilePanel.wa$_rootUrl(NewFilePanel.this, uRL);
                }
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            this.dir = this.getText();
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!this.dir.equals(this.getText())) {
                NewFilePanel.wa$_supportsAutoFill(NewFilePanel.this, false);
                URL uRL = this.getURL();
                if (uRL != null) {
                    NewFilePanel.mav$setRootURL(NewFilePanel.this, uRL);
                }
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            NewFilePanel.mav$enableOK(NewFilePanel.this);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            NewFilePanel.mav$enableOK(NewFilePanel.this);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            NewFilePanel.mav$enableOK(NewFilePanel.this);
        }
    }
}

