/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.component.URLPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ComponentArb;
import oracle.ide.util.ResourceUtils;

public class URLPathEditPanel
extends JPanel
implements ActionListener {
    private URL defDir;
    private DefaultListModel pathModel;
    GridBagLayout layMain;
    JScrollPane scrList;
    JPanel pnlOrder;
    GridBagLayout layOrder;
    JButton butUp;
    JButton butDown;
    JButton butAddEntry;
    JButton butAddURL;
    JButton butRemove;
    JPanel pnlButtons;
    GridLayout gridLayout1;
    JLabel listPathsLabel;
    JList listPaths;
    Border bdrList;
    Icon iconUp;
    Icon iconUpDisabled;
    Icon iconDown;
    Icon iconDownDisabled;
    ListCellRenderer urlRenderer;
    private boolean _supportsArbitraryURLs;
    private boolean _allowJars;
    private boolean _pathLocked;
    private JEWTDialog _dlg;

    void $init$() {
        this.defDir = URLFactory.newDirURL(Ide.getWorkDirectory());
        this.pathModel = new DefaultListModel();
        this.layMain = new GridBagLayout();
        this.scrList = new JScrollPane();
        this.pnlOrder = new JPanel();
        this.layOrder = new GridBagLayout();
        this.butUp = new JButton();
        this.butDown = new JButton();
        this.butAddEntry = new JButton();
        this.butAddURL = new JButton();
        this.butRemove = new JButton();
        this.pnlButtons = new JPanel();
        this.gridLayout1 = new GridLayout();
        this.listPathsLabel = new JLabel();
        this.listPaths = new JList();
        this.bdrList = BorderFactory.createEmptyBorder();
        this.iconUp = ComponentArb.getIcon(0);
        this.iconUpDisabled = ComponentArb.getIcon(2);
        this.iconDown = ComponentArb.getIcon(1);
        this.iconDownDisabled = ComponentArb.getIcon(3);
        this.urlRenderer = new URLRenderer(null);
        this._supportsArbitraryURLs = false;
        this._allowJars = true;
    }

    public URLPathEditPanel(URLPath uRLPath) {
        this();
        this.setPath(uRLPath);
    }

    public URLPathEditPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static URLPath editPath(Component component, String string, URLPath uRLPath, boolean bl, boolean bl2, String string2) {
        URLPathEditPanel uRLPathEditPanel = new URLPathEditPanel(uRLPath);
        uRLPathEditPanel.setSupportsArbitraryURLs(bl);
        uRLPathEditPanel.setJarPathsAllowed(bl2);
        if (string2 != null) {
            HelpSystem.getHelpSystem().registerTopic(uRLPathEditPanel, string2);
        }
        return OnePageWizardDialogFactory.runDialog(component, uRLPathEditPanel, uRLPathEditPanel.getInitialFocus(), string, 7, null) ? uRLPathEditPanel.getPath() : null;
    }

    public static void viewPath(Component component, String string, URLPath uRLPath, String string2) {
        URLPathEditPanel uRLPathEditPanel = new URLPathEditPanel(uRLPath);
        uRLPathEditPanel.setPathLocked(true);
        if (string2 != null) {
            HelpSystem.getHelpSystem().registerTopic(uRLPathEditPanel, string2);
        }
        OnePageWizardDialogFactory.runDialog(component, uRLPathEditPanel, uRLPathEditPanel.getInitialFocus(), string, 6, null);
    }

    public void setPath(URLPath uRLPath) {
        this.pathModel.clear();
        URL[] uRLArray = uRLPath.getEntries();
        int n = 0;
        while (n < uRLArray.length) {
            this.pathModel.addElement(uRLArray[n]);
            ++n;
        }
        if (!this.pathModel.isEmpty()) {
            this.listPaths.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    public URLPath getPath() {
        URLPath uRLPath = new URLPath();
        int n = this.pathModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            uRLPath.add((URL)this.pathModel.elementAt(n2));
            ++n2;
        }
        return uRLPath;
    }

    public void setDefaultArchiveDirectory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.defDir = URLFactory.newDirURL(string);
    }

    public String getDefaultArchiveDirectory() {
        return URLFileSystem.getPlatformPathName(this.defDir);
    }

    public void setPathLocked(boolean bl) {
        this._pathLocked = bl;
        this.pnlOrder.setVisible(bl ^ true);
        this.pnlButtons.setVisible(bl ^ true);
    }

    public boolean isPathLocked() {
        return this._pathLocked;
    }

    public void setSupportsArbitraryURLs(boolean bl) {
        if (this._supportsArbitraryURLs != bl) {
            this._supportsArbitraryURLs = bl;
            this.pnlButtons.removeAll();
            if (this._supportsArbitraryURLs) {
                this.pnlButtons.add((Component)this.butAddEntry, null);
                this.pnlButtons.add((Component)this.butAddURL, null);
                this.pnlButtons.add((Component)this.butRemove, null);
            } else {
                this.pnlButtons.add((Component)this.butAddEntry, null);
                this.pnlButtons.add((Component)this.butRemove, null);
            }
        }
    }

    public boolean isSupportsArbitraryURLs() {
        return this._supportsArbitraryURLs;
    }

    public void setJarPathsAllowed(boolean bl) {
        this._allowJars = bl;
    }

    public boolean isJarPathsAllowed() {
        return this._allowJars;
    }

    public Component getInitialFocus() {
        if (this.pathModel.isEmpty()) {
            return this.butAddEntry;
        }
        return this.listPaths;
    }

    public void addNotify() {
        super.addNotify();
        this._dlg = (JEWTDialog)SwingUtilities.getAncestorOfClass(JEWTDialog.class, this);
    }

    public void setPathLabel(String string) {
        if (string != null) {
            ResourceUtils.resLabel(this.listPathsLabel, this.listPaths, string);
            this.listPathsLabel.setVisible(true);
        } else {
            this.listPathsLabel.setVisible(false);
        }
    }

    private void jbInit() {
        this.setLayout(this.layMain);
        this.pnlOrder.setLayout(this.layOrder);
        this.listPaths.setBorder(this.bdrList);
        this.butUp.setIcon(this.iconUp);
        this.butUp.setDisabledIcon(this.iconUpDisabled);
        this.butUp.setMargin(new Insets(2, 2, 2, 2));
        this.butUp.addActionListener(this);
        this.butUp.setToolTipText(ComponentArb.getString(4));
        this.butDown.setIcon(this.iconDown);
        this.butDown.setDisabledIcon(this.iconDownDisabled);
        this.butDown.setMargin(new Insets(2, 2, 2, 2));
        this.butDown.addActionListener(this);
        this.butDown.setToolTipText(ComponentArb.getString(5));
        ResourceUtils.resButton(this.butAddEntry, ComponentArb.getString(12));
        this.butAddEntry.addActionListener(this);
        ResourceUtils.resButton(this.butAddURL, ComponentArb.getString(13));
        this.butAddURL.addActionListener(this);
        ResourceUtils.resButton(this.butRemove, ComponentArb.getString(10));
        this.butRemove.addActionListener(this);
        this.gridLayout1.setColumns(3);
        this.gridLayout1.setHgap(8);
        this.listPaths.setSelectionMode(0);
        this.listPaths.setModel(this.pathModel);
        this.listPaths.setCellRenderer(this.urlRenderer);
        this.listPaths.addListSelectionListener(new 1());
        this.listPathsLabel.setVisible(false);
        this.pnlButtons.setLayout(this.gridLayout1);
        int n = 8;
        this.add((Component)this.listPathsLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.scrList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.scrList.getViewport().add((Component)this.listPaths, null);
        this.pnlOrder.add((Component)this.butUp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.pnlOrder.add((Component)this.butDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlOrder, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 13, 1, new Insets(0, 8, 0, 0), 0, 0));
        this.add((Component)this.pnlButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.pnlButtons.add((Component)this.butAddEntry, null);
        this.pnlButtons.add((Component)this.butRemove, null);
    }

    private void updateButtons() {
        int n = this.listPaths.getSelectedIndex();
        this.butUp.setEnabled(n > 0);
        this.butDown.setEnabled(n != -1 && n != this.pathModel.size() - 1);
        this.butRemove.setEnabled(n != -1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.butAddEntry) {
            this._browseEntry();
        } else if (object == this.butAddURL) {
            URL uRL = new URLPanel().promptForURL(this);
            if (uRL != null) {
                this.pathModel.addElement(uRL);
                this.listPaths.setSelectedIndex(this.pathModel.getSize() - 1);
            }
        } else if (object == this.butRemove) {
            this._removeEntry();
        } else if (object == this.butUp) {
            this._moveUp();
        } else if (object == this.butDown) {
            this._moveDown();
        }
    }

    private void _browseEntry() {
        URLChooser uRLChooser = DialogUtil.newURLChooser(this.defDir);
        uRLChooser.setSelectionMode(2);
        uRLChooser.setSelectionScope(1);
        uRLChooser.setShowJarsAsDirs(this._allowJars);
        int n = uRLChooser.showOpenDialog(this, ComponentArb.getString(17));
        if (n == 0) {
            URL[] uRLArray = uRLChooser.getSelectedURLs();
            URL uRL = null;
            int n2 = uRLArray.length;
            int n3 = 0;
            while (n3 < n2) {
                uRL = uRLArray[n3];
                this.pathModel.addElement(uRL);
                ++n3;
            }
            this.defDir = uRL;
            int n4 = this.pathModel.getSize() - 1;
            this.listPaths.setSelectedIndex(n4);
            this.listPaths.ensureIndexIsVisible(n4);
        }
    }

    private void _removeEntry() {
        int n = this.listPaths.getSelectedIndex();
        if (n != -1) {
            this.pathModel.removeElementAt(n);
            int n2 = this.pathModel.getSize();
            int n3 = n < n2 ? n : n2 - 1;
            this.listPaths.setSelectedIndex(n3);
            if (n3 == -1) {
                this.butRemove.setEnabled(false);
            } else {
                this.listPaths.ensureIndexIsVisible(n3);
            }
        }
    }

    void _moveUp() {
        int n = this.listPaths.getSelectedIndex();
        if (n > 0) {
            this._moveElement(n, n - 1);
        }
    }

    void _moveDown() {
        int n = this.listPaths.getSelectedIndex();
        if (n >= 0 && n < this.pathModel.size() - 1) {
            this._moveElement(n, n + 1);
        }
    }

    private void _moveElement(int n, int n2) {
        Object e = this.pathModel.elementAt(n);
        this.pathModel.removeElementAt(n);
        this.pathModel.insertElementAt(e, n2);
        this.listPaths.setSelectedIndex(n2);
        this.listPaths.ensureIndexIsVisible(n2);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.min(dimension.width, 500), Math.min(dimension.height, 300));
    }

    static void mav$updateButtons(URLPathEditPanel uRLPathEditPanel) {
        uRLPathEditPanel.updateButtons();
    }

    public final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            URLPathEditPanel.mav$updateButtons(URLPathEditPanel.this);
        }
    }

    private static class URLRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof URL) {
                URL uRL = (URL)object;
                object = URLFileSystem.getPlatformPathName(uRL);
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }

        private URLRenderer() {
        }

        URLRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

