/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.composite.AbstractCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementEvent;
import oracle.ide.composite.CompositeFileElementListener;
import oracle.ide.composite.CompositeFileElementProxy;
import oracle.ide.model.Element;
import oracle.javatools.util.CopyOnWriteList;

public class CompositeFileElementRegistry {
    static final String APPLICATION_NAVIGATOR_WINDOW_ID = "ApplicationNavigatorWindow";
    private static final Collection _compositeListeners = Collections.synchronizedList(new ArrayList());
    private static final CopyOnWriteList _compositeProxies = new CopyOnWriteList();
    private static final Map _compositeStateCache = Collections.synchronizedMap(new WeakHashMap());

    private CompositeFileElementRegistry() {
    }

    public static final void registerCompositeProxy(CompositeFileElementProxy compositeFileElementProxy) {
        _compositeProxies.addIfAbsent((Object)compositeFileElementProxy);
        CompositeFileElementRegistry.fireCompositeStateChanged(compositeFileElementProxy.getCompositeElementClass());
    }

    public static final void deregisterCompositeProxy(CompositeFileElementProxy compositeFileElementProxy) {
        _compositeProxies.remove((Object)compositeFileElementProxy);
        CompositeFileElementRegistry.fireCompositeStateChanged(compositeFileElementProxy.getCompositeElementClass());
    }

    public static final void fireCompositeStateChanged(Element element) {
        CompositeFileElementRegistry.fireCompositeStateChanged(new Element[]{element});
    }

    public static final void fireCompositeStateChanged(Class clazz) {
        if (!Element.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException();
        }
        Element[] elementArray = CompositeFileElementRegistry.getCachedCompositeElements(clazz);
        if (elementArray.length > 0) {
            CompositeFileElementRegistry.fireCompositeStateChanged(elementArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void fireCompositeStateChanged(Element[] elementArray) {
        CompositeFileElementListener[] compositeFileElementListenerArray;
        int n = 0;
        while (n < elementArray.length) {
            _compositeStateCache.remove(elementArray[n]);
            ++n;
        }
        if (_compositeListeners.isEmpty()) {
            return;
        }
        Collection collection = _compositeListeners;
        synchronized (collection) {
            compositeFileElementListenerArray = _compositeListeners.toArray(new CompositeFileElementListener[0]);
        }
        CompositeFileElementEvent compositeFileElementEvent = new CompositeFileElementEvent(elementArray, 1);
        int n2 = compositeFileElementListenerArray.length - 1;
        while (n2 >= 0) {
            compositeFileElementListenerArray[n2].compositeStateChanged(compositeFileElementEvent);
            --n2;
        }
    }

    public static final void addCompositeListener(CompositeFileElementListener compositeFileElementListener) {
        _compositeListeners.add(compositeFileElementListener);
    }

    public static final void removeCompositeListener(CompositeFileElementListener compositeFileElementListener) {
        _compositeListeners.remove(compositeFileElementListener);
    }

    public static final boolean isCompositeElement(Element element) {
        return CompositeFileElementRegistry.isCompositeElement(element, APPLICATION_NAVIGATOR_WINDOW_ID);
    }

    public static final boolean isCompositeElement(Element element, String string) {
        Object[] objectArray = _compositeProxies.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeFileElementProxy compositeFileElementProxy = (CompositeFileElementProxy)objectArray[n2];
            if (CompositeFileElementRegistry.isCompositeProxyForView(compositeFileElementProxy, string) && compositeFileElementProxy.getCompositeElementClass().isInstance(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static final URL[] getCompositeFileURLs(Element element) {
        return CompositeFileElementRegistry.getCompositeFileURLs(element, APPLICATION_NAVIGATOR_WINDOW_ID);
    }

    public static final URL[] getCompositeFileURLs(Element element, String string) {
        if (_compositeStateCache.containsKey(element)) {
            return ((Collection)_compositeStateCache.get(element)).toArray(new URL[0]);
        }
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>();
        Object[] objectArray = _compositeProxies.getItems();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL[] uRLArray;
            CompositeFileElementProxy compositeFileElementProxy = (CompositeFileElementProxy)objectArray[n2];
            if (CompositeFileElementRegistry.isCompositeProxyForView(compositeFileElementProxy, string) && compositeFileElementProxy.getCompositeElementClass().isInstance(element) && (uRLArray = compositeFileElementProxy.getCompositeFileURLs(element)) != null) {
                linkedHashSet.addAll(Arrays.asList(uRLArray));
            }
            ++n2;
        }
        linkedHashSet.remove(null);
        _compositeStateCache.put(element, linkedHashSet);
        return linkedHashSet.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Element[] getCachedCompositeElements(URL[] uRLArray) {
        LinkedHashSet<Element> linkedHashSet = new LinkedHashSet<Element>();
        Map map = _compositeStateCache;
        synchronized (map) {
            for (Element element : _compositeStateCache.keySet()) {
                if (!CompositeFileElementRegistry.isCompositeElementOwner(element, uRLArray)) continue;
                linkedHashSet.add(element);
            }
        }
        return linkedHashSet.toArray(new Element[0]);
    }

    static final boolean isRegisteredCompositeProxy(CompositeFileElementProxy compositeFileElementProxy) {
        return Arrays.asList(_compositeProxies.getItems()).contains(compositeFileElementProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element[] getCachedCompositeElements(Class clazz) {
        ArrayList arrayList = new ArrayList();
        Map map = _compositeStateCache;
        synchronized (map) {
            for (Object k : _compositeStateCache.keySet()) {
                if (!clazz.isInstance(k)) continue;
                arrayList.add(k);
            }
        }
        return arrayList.toArray(new Element[0]);
    }

    private static final boolean isCompositeProxyForView(CompositeFileElementProxy compositeFileElementProxy, String string) {
        if (string == null) {
            return true;
        }
        String string2 = APPLICATION_NAVIGATOR_WINDOW_ID;
        if (compositeFileElementProxy instanceof AbstractCompositeFileElementProxy) {
            AbstractCompositeFileElementProxy abstractCompositeFileElementProxy = (AbstractCompositeFileElementProxy)compositeFileElementProxy;
            string2 = abstractCompositeFileElementProxy.getViewType();
        }
        return string2 == null || string.equals(string2);
    }

    private static final boolean isCompositeElementOwner(Element element, URL[] uRLArray) {
        Collection collection = (Collection)_compositeStateCache.get(element);
        int n = 0;
        while (n < uRLArray.length) {
            if (collection.contains(uRLArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

