/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.composite;

import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import oracle.ide.composite.AbstractCompositeFileElementProxy;
import oracle.ide.composite.CompositeFileElementRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.LazyLoadable;
import oracle.ide.model.Locatable;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class DefaultCompositeFileElementProxy
extends AbstractCompositeFileElementProxy {
    private final Observer _compositeContainerObserver;
    private final Observer _compositeOpenObserver;
    private final Class _compositeElementClass;

    void $init$() {
        this._compositeContainerObserver = new 2();
        this._compositeOpenObserver = new 1();
    }

    public DefaultCompositeFileElementProxy(Class clazz) {
        this.$init$();
        this._compositeElementClass = clazz;
    }

    public DefaultCompositeFileElementProxy(String string, Class clazz) {
        super(string);
        this.$init$();
        this._compositeElementClass = clazz;
    }

    public Class getCompositeElementClass() {
        return this._compositeElementClass;
    }

    public URL[] getCompositeFileURLs(Element element) {
        this.attachContainerStateObserver(element);
        Collection collection = this.getContainerFileURLs(element);
        return collection.toArray(new URL[0]);
    }

    protected void attachContainerStateObserver(Element element) {
        if (element instanceof Subject) {
            Subject subject = (Subject)((Object)element);
            subject.detach(this._compositeContainerObserver);
            subject.attach(this._compositeContainerObserver);
        }
        if (!this.isContainerStyleRecursive()) {
            return;
        }
        if (!element.mayHaveChildren()) {
            return;
        }
        if (element instanceof Subject && element instanceof LazyLoadable && !((LazyLoadable)((Object)element)).isOpen()) {
            Subject subject = (Subject)((Object)element);
            subject.detach(this._compositeOpenObserver);
            subject.attach(this._compositeOpenObserver);
            return;
        }
        Iterator iterator = element.getChildren();
        while (iterator != null && iterator.hasNext()) {
            this.attachContainerStateObserver((Element)iterator.next());
        }
    }

    protected Collection getContainerFileURLs(Element element) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addParentURL(linkedHashSet, element);
        this.addChildURLs(linkedHashSet, element);
        return linkedHashSet;
    }

    protected boolean isContainerStyleRecursive() {
        return true;
    }

    protected void addParentURL(Collection collection, Element element) {
        this.addLocatableURL(collection, element);
    }

    protected void addChildURLs(Collection collection, Element element) {
        if (!element.mayHaveChildren()) {
            return;
        }
        Iterator iterator = element.getChildren();
        while (iterator != null && iterator.hasNext()) {
            this.addLocatableURL(collection, iterator.next());
        }
        if (!this.isContainerStyleRecursive()) {
            return;
        }
        Iterator iterator2 = element.getChildren();
        while (iterator2 != null && iterator2.hasNext()) {
            this.addChildURLs(collection, (Element)iterator2.next());
        }
    }

    protected void addLocatableURL(Collection collection, Object object) {
        if (!(object instanceof Locatable)) {
            return;
        }
        URL uRL = ((Locatable)object).getURL();
        if (uRL != null) {
            collection.add(uRL);
        }
    }

    public final class 2
    implements Observer {
        public final void update(Object object, UpdateMessage updateMessage) {
            if (!CompositeFileElementRegistry.isRegisteredCompositeProxy(DefaultCompositeFileElementProxy.this)) {
                ((Subject)object).detach(this);
                return;
            }
            int n = updateMessage.getMessageID();
            if (n != UpdateMessage.CHILD_ADDED && n != UpdateMessage.CHILD_REMOVED) {
                return;
            }
            CompositeFileElementRegistry.fireCompositeStateChanged(DefaultCompositeFileElementProxy.this.getCompositeElementClass());
        }
    }

    public final class 1
    implements Observer {
        public final void update(Object object, UpdateMessage updateMessage) {
            if (!CompositeFileElementRegistry.isRegisteredCompositeProxy(DefaultCompositeFileElementProxy.this)) {
                ((Subject)object).detach(this);
                return;
            }
            if (updateMessage.getMessageID() != UpdateMessage.OBJECT_OPENED) {
                return;
            }
            CompositeFileElementRegistry.fireCompositeStateChanged(DefaultCompositeFileElementProxy.this.getCompositeElementClass());
            ((Subject)object).detach(this);
        }
    }
}

