/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.Navigable;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.ObjectStore;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public final class ClientSetting
implements Copyable {
    public static final String ROOT_TAG = "client-settings";
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI("client-preferences");
    public static final String FILENAME = "preferences.xml";
    private HashMap _clientData;
    private URL _url;
    private String _extensionID;
    private transient Object2Dom _objectStore;
    private transient boolean _isOpen;

    void $init$() {
        this._clientData = new HashMap();
        this._isOpen = false;
    }

    ClientSetting() {
        this.$init$();
    }

    public boolean hasData(String string) {
        if (this.isOpen()) {
            return this._clientData.containsKey(string);
        }
        return URLFileSystem.exists(this.getURL());
    }

    public Copyable getData(String string) throws TransientMarker {
        try {
            this.ensureOpen();
            Copyable copyable = (Copyable)this._clientData.get(string);
            return copyable;
        }
        catch (Exception exception) {
            Copyable copyable = null;
            return copyable;
        }
    }

    public void putData(String string, Copyable copyable) {
        try {
            this.ensureOpen();
            this._clientData.put(string, copyable);
            Ide.getSettings().setData(string, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void save() throws IOException {
        if (this.isOpen()) {
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(NAMESPACE_URI);
            object2Dom.toDocument((Object)this._clientData, ROOT_TAG, this.getURL());
        }
    }

    public void open() throws IOException {
        if (!this.isOpen()) {
            if (!this.isNew()) {
                Object2Dom object2Dom = Object2Dom.newInstance();
                this._clientData = (HashMap)object2Dom.toObject(this.getURL());
                Ide.getSettings().addClientSetting(this);
            }
            this._isOpen = true;
        }
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL uRL) {
        this._url = uRL;
    }

    public boolean isNew() {
        return URLFileSystem.exists(this.getURL()) ^ true;
    }

    public boolean isOpen() {
        return this._isOpen;
    }

    public String getExtensionID() {
        return this._extensionID;
    }

    public void putExtensionID(String string) {
        this._extensionID = string;
    }

    public Object copyTo(Object object) {
        ClientSetting clientSetting = object != null ? (ClientSetting)object : new ClientSetting();
        this.copyToImpl(clientSetting);
        return clientSetting;
    }

    protected final void copyToImpl(ClientSetting clientSetting) {
        ModelUtil.deepCopy((Map)this._clientData, (Map)clientSetting._clientData);
        clientSetting._url = this._url;
        clientSetting._isOpen = this._isOpen;
        clientSetting._extensionID = this._extensionID;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ClientSetting)object);
    }

    public int hashCode() {
        return this._url.hashCode();
    }

    public static void registerUI(Navigable navigable) {
        IdeSettings.registerUI(navigable);
    }

    public static void deregisterUI(Navigable navigable) {
        IdeSettings.deregisterUI(navigable);
    }

    public static ClientSetting findOrCreate(String string) {
        return ClientSetting.findOrCreate(string, FILENAME);
    }

    public static ClientSetting findOrCreate(String string, String string2) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = URLFactory.newURL(extensionRegistry.getSystemDirectory(string), string2);
        ClientSetting clientSetting = Ide.getSettings().findClientSetting(uRL);
        if (clientSetting == null) {
            clientSetting = new ClientSetting(uRL);
            clientSetting.putExtensionID(string);
        }
        return clientSetting;
    }

    protected final boolean equalsImpl(ClientSetting clientSetting) {
        return this._url.equals(clientSetting._url);
    }

    protected ObjectStore getObjectStore() {
        if (this._objectStore == null) {
            this._objectStore = Object2Dom.newInstance();
            this._objectStore.setNamespaceURI(NAMESPACE_URI);
        }
        return this._objectStore;
    }

    protected void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            this.open();
        }
    }

    protected Map getClientData() {
        try {
            this.ensureOpen();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._clientData;
    }

    protected ClientSetting(URL uRL) {
        this.$init$();
        this._url = uRL;
    }
}

