/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.ModelUtil;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.util.Copyable;

public final class DTCache
implements Copyable {
    static final String FILENAME = "dtcache.xml";
    static final String NAMESPACE_URI = XMLUtil.toNamespaceURI("dt-cache");
    static final String ROOT_TAG = "dt-cache";
    private HashMap cacheMap = new HashMap();

    public Object getData(String string) {
        return this.cacheMap.get(string);
    }

    public String getString(String string) {
        return (String)this.getData(string);
    }

    public int getInteger(String string, int n) {
        Object object = this.getData(string);
        return object instanceof Integer ? (Integer)object : n;
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object = this.getData(string);
        return object instanceof Boolean ? (Boolean)object : bl;
    }

    public URL getURL(String string) {
        return (URL)this.getData(string);
    }

    public void putData(String string, Copyable copyable) {
        if (copyable == null) {
            throw new IllegalArgumentException();
        }
        this.cacheMap.put(string, copyable);
    }

    public void putData(String string, List list) {
        if (list == null) {
            throw new IllegalArgumentException();
        }
        this.cacheMap.put(string, list);
    }

    public void putString(String string, String string2) {
        this.cacheMap.put(string, string2);
    }

    public void putBoolean(String string, boolean bl) {
        this.putBoolean(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void putBoolean(String string, Boolean bl) {
        this.cacheMap.put(string, bl);
    }

    public void putURL(String string, URL uRL) {
        this.cacheMap.put(string, uRL);
    }

    public void putInteger(String string, int n) {
        this.putInteger(string, new Integer(n));
    }

    public void putInteger(String string, Integer n) {
        this.cacheMap.put(string, n);
    }

    public boolean save() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".save");
        boolean bl = false;
        try {
            URL uRL = DTCache.getConfigURL();
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(NAMESPACE_URI);
            object2Dom.toDocument((Object)this.cacheMap, ROOT_TAG, uRL);
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".save", "DTCache.save()");
        return bl;
    }

    public boolean load() {
        PerformanceLogger.get().startTiming(this.getClass().getName() + ".load");
        boolean bl = false;
        try {
            URL uRL = DTCache.getConfigURL();
            Object2Dom object2Dom = Object2Dom.newInstance();
            HashMap hashMap = (HashMap)object2Dom.toObject(uRL);
            this.cacheMap.clear();
            this.cacheMap.putAll(hashMap);
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PerformanceLogger.get().stopTiming(this.getClass().getName() + ".load", "DTCache.load()");
        return bl;
    }

    public Object copyTo(Object object) {
        DTCache dTCache = object != null ? (DTCache)object : new DTCache();
        ModelUtil.deepCopy((Map)this.cacheMap, (Map)dTCache.cacheMap);
        return dTCache;
    }

    public String toString() {
        return URLFileSystem.getPlatformPathName(DTCache.getConfigURL());
    }

    private static URL getConfigURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        return URLFactory.newURL(extensionRegistry.getSystemDirectory("oracle.ide"), FILENAME);
    }
}

