/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.config.RegisteredDynamicNode;
import oracle.ide.dialogs.filter.ExcludeFilterSettings;
import oracle.ide.model.ContentType;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public class DocumentExtensions
implements Copyable {
    public static final String KEY_SETTINGS = "document-extensions-options";
    private Map _documentMap;
    private ExcludeFilterSettings _excludeFilterSettings;
    private Map _defaultEditorMap;
    private Map _associationMap;
    private Map _hiddenMap;
    private final HashMap m_KeyToWeakNodeExtensionSetMap;

    static {
        Recognizer.registerDocumentInfo(RegisteredDynamicNode.class, new DocumentInfo(IdeArb.getString(465)));
    }

    void $init$() {
        this._hiddenMap = new HashMap();
        this.m_KeyToWeakNodeExtensionSetMap = new HashMap();
    }

    public DocumentExtensions() {
        this.$init$();
    }

    public DocRecord[] getUserExtensionList() {
        return this.getDocuments().toArray(new DocRecord[0]);
    }

    public void setUserExtensionList(DocRecord[] docRecordArray) {
        if (docRecordArray == null) {
            return;
        }
        this._setUserExtensionList0(docRecordArray);
    }

    private void _setUserExtensionList0(DocRecord[] docRecordArray) {
        if (Ide.isStarting()) {
            Ide.addIdeListener(new 2(this, docRecordArray));
            return;
        }
        this._setUserExtensionList1(docRecordArray);
    }

    private void _setUserExtensionList1(DocRecord[] docRecordArray) {
        this.initDocumentMap();
        int n = 0;
        while (n < docRecordArray.length) {
            DocRecord docRecord = (DocRecord)this._documentMap.get(docRecordArray[n].getDocClass());
            if (docRecord == null) {
                this._documentMap.put(docRecordArray[n].getDocClass(), docRecordArray[n]);
            } else {
                for (ExtInfo extInfo : docRecordArray[n].getUserExtensions()) {
                    ExtInfo extInfo2 = docRecord.addUserExtension(extInfo.getExtension());
                    extInfo2.setLocked(extInfo.isLocked());
                }
            }
            ++n;
        }
        this.mapExtensionsToClasses(docRecordArray);
    }

    void mapExtensionsToClasses(DocRecord[] docRecordArray) {
        int n = 0;
        while (n < docRecordArray.length) {
            DocRecord docRecord = docRecordArray[n];
            List list = docRecord.getUserExtensions();
            int n2 = 0;
            while (n2 < list.size()) {
                ExtInfo extInfo = (ExtInfo)list.get(n2);
                Class clazz = docRecord.getDocClass();
                if (clazz != null && clazz != RegisteredDynamicNode.class) {
                    Recognizer.mapExtensionToClass(extInfo.getExtension(), clazz);
                }
                ++n2;
            }
            ++n;
        }
    }

    public ExcludeFilterSettings getExcludeFilterSettings() {
        return this._excludeFilterSettings;
    }

    public void setExcludeFilterSettings(ExcludeFilterSettings excludeFilterSettings) {
        this._excludeFilterSettings = excludeFilterSettings;
    }

    public Map getExtensionToContentTypeMap() {
        HashMap hashMap = new HashMap();
        this.getExtensionToContentTypeMapImpl(hashMap);
        return hashMap;
    }

    public void setExtensionToContentTypeMap(Map map) {
        if (!Ide.isStarting()) {
            this.setExtensionToContentTypeMapImpl(map);
        } else {
            Ide.addIdeListener(new 1(this, map));
        }
    }

    public Map getDefaultEditorMap() {
        return this._defaultEditorMap;
    }

    public void setDefaultEditorMap(Map map) {
        this._defaultEditorMap = map;
    }

    public Map getAssociationMap() throws TransientMarker {
        return this._associationMap;
    }

    public void setAssociationMap(Map map) {
        this._associationMap = map;
    }

    public void _setDocumentMap(Map map) {
        this._documentMap = map;
    }

    public Map _getDocumentMap() {
        this.initDocumentMap();
        return this._documentMap;
    }

    public Collection getDocuments() {
        if (Ide.isStarting()) {
            HashMap hashMap = new HashMap();
            this.addRecognizerDocuments(hashMap);
            return hashMap.values();
        }
        this.initDocumentMap();
        return this._documentMap.values();
    }

    public Object copyTo(Object object) {
        DocumentExtensions documentExtensions = object != null ? (DocumentExtensions)object : new DocumentExtensions();
        this.copyToImpl(documentExtensions);
        return documentExtensions;
    }

    protected final void copyToImpl(DocumentExtensions documentExtensions) {
        this.initDocumentMap();
        if (documentExtensions._documentMap == null) {
            documentExtensions._documentMap = new HashMap();
        }
        ModelUtil.deepCopy((Map)this._documentMap, (Map)documentExtensions._documentMap);
        documentExtensions._hiddenMap = this._hiddenMap;
        documentExtensions._defaultEditorMap = this._defaultEditorMap;
        documentExtensions._associationMap = this._associationMap;
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((DocumentExtensions)object);
    }

    protected final boolean equalsImpl(DocumentExtensions documentExtensions) {
        return ModelUtil.areEqual((Object)documentExtensions.getDocuments(), (Object)this.getDocuments()) && ModelUtil.areEqual((Object)documentExtensions._defaultEditorMap, (Object)this._defaultEditorMap) && ModelUtil.areEqual((Object)documentExtensions._associationMap, (Object)this._associationMap);
    }

    public Set getNodeExtensions(Class clazz, boolean bl) {
        HashSet hashSet;
        NodeExtensionKey nodeExtensionKey;
        block4: {
            Set set;
            nodeExtensionKey = new NodeExtensionKey(clazz, bl);
            WeakReference weakReference = (WeakReference)this.m_KeyToWeakNodeExtensionSetMap.get(nodeExtensionKey);
            if (weakReference != null && (set = (Set)weakReference.get()) != null) {
                return set;
            }
            hashSet = null;
            for (DocRecord docRecord : this.getDocuments()) {
                boolean bl2;
                Class clazz2 = docRecord.getDocClass();
                boolean bl3 = bl2 = bl ? clazz.equals(clazz2) : clazz.isAssignableFrom(clazz2);
                if (!bl2 || (hashSet = this.getNodeExtensions(docRecord, hashSet)) == null || !bl) {
                    continue;
                }
                break block4;
            }
            for (DocRecord docRecord : this._hiddenMap.values()) {
                boolean bl4;
                Class clazz3 = docRecord.getDocClass();
                boolean bl5 = bl4 = bl ? clazz.equals(clazz3) : clazz.isAssignableFrom(clazz3);
                if (bl4 && (hashSet = this.getNodeExtensions(docRecord, hashSet)) != null && bl) break;
            }
        }
        Set set = hashSet != null ? Collections.unmodifiableSet(hashSet) : Collections.EMPTY_SET;
        this.m_KeyToWeakNodeExtensionSetMap.put(nodeExtensionKey, new WeakReference(set));
        return set;
    }

    public Set getNodeExtensions(Class[] classArray, boolean bl) {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < classArray.length) {
            hashSet.addAll(this.getNodeExtensions(classArray[n], bl));
            ++n;
        }
        return Collections.unmodifiableSet(hashSet);
    }

    private HashSet getNodeExtensions(DocRecord docRecord, HashSet hashSet) {
        List list = docRecord.getExtensions();
        if (!list.isEmpty()) {
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            for (ExtInfo extInfo : list) {
                hashSet.add(URLFileSystem.isLocalFileSystemCaseSensitive() ? extInfo.getExtension() : extInfo.getExtension().toLowerCase());
            }
        }
        return hashSet;
    }

    public DocRecord findDocumentFromExtension(String string) {
        for (DocRecord docRecord : this.getDocuments()) {
            if (!docRecord.isExtensionInUse(string)) continue;
            return docRecord;
        }
        for (DocRecord docRecord : this._hiddenMap.values()) {
            if (!docRecord.isExtensionInUse(string)) continue;
            return docRecord;
        }
        return null;
    }

    private void initDocumentMap() {
        if (this._documentMap == null) {
            this._documentMap = new HashMap();
            this.addRecognizerDocuments(this._documentMap);
        }
    }

    private void addRecognizerDocuments(Map map) {
        Map map2 = Recognizer.getExtensionToClassMap();
        if (map2 == null) {
            return;
        }
        Set set = map2.entrySet();
        for (Map.Entry entry : set) {
            File file = (File)entry.getKey();
            Class clazz = (Class)entry.getValue();
            DocRecord docRecord = (DocRecord)map.get(clazz);
            if (docRecord == null) {
                DocumentInfo documentInfo = Recognizer.getDocumentInfo(clazz);
                if (documentInfo == null) {
                    documentInfo = this.defaultInfo(clazz);
                } else if (!documentInfo.isIconSpecified()) {
                    documentInfo.setIcon(clazz);
                }
                docRecord = new DocRecord(clazz, documentInfo);
                if (!documentInfo.isHidden()) {
                    map.put(clazz, docRecord);
                } else if (this._hiddenMap != null) {
                    DocRecord docRecord2 = (DocRecord)this._hiddenMap.get(clazz);
                    if (docRecord2 != null) {
                        docRecord = docRecord2;
                    } else {
                        this._hiddenMap.put(clazz, docRecord);
                    }
                }
            }
            docRecord.addIdeExtension(file.getName());
        }
    }

    private DocumentInfo defaultInfo(Class clazz) {
        String string = this.shortLabel(clazz.getName());
        DocumentInfo documentInfo = new DocumentInfo(string);
        documentInfo.setIcon(clazz);
        return documentInfo;
    }

    private String shortLabel(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExtensionToContentTypeMapImpl(Map map) {
        Map map2;
        Map map3 = map2 = Recognizer.getExtensionToContentTypeMap();
        synchronized (map3) {
            for (Map.Entry entry : map2.entrySet()) {
                File file = (File)entry.getKey();
                ContentType contentType = (ContentType)entry.getValue();
                if (file == null || contentType == null || map.containsKey(file.getPath())) continue;
                map.put(file.getPath(), contentType.name());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExtensionToContentTypeMapImpl(Map map) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Map map2;
            File file = Recognizer.sanitizeExtension((String)entry.getKey());
            String string = (String)entry.getValue();
            if (file == null || string == null) continue;
            Map map3 = map2 = Recognizer.getExtensionToContentTypeMap();
            synchronized (map3) {
                map2.put(file, ContentType.valueOf(string));
            }
        }
    }

    public static final DocumentInfo findRecognizerDocumentInfo(Class clazz) {
        return Recognizer.getDocumentInfo(clazz);
    }

    public static final ContentType findContentTypeFromExtension(String string) {
        ContentType contentType = DocumentExtensions.findRecognizerContentType(string);
        return contentType != null ? contentType : ContentType.TEXT;
    }

    public static final ContentType findRecognizerContentType(String string) {
        if (string != null && string.length() > 0) {
            return Recognizer.getContentTypeForExtension(string);
        }
        return null;
    }

    static void mav$_setUserExtensionList1(DocumentExtensions documentExtensions, DocRecord[] docRecordArray) {
        documentExtensions._setUserExtensionList1(docRecordArray);
    }

    static void mav$setExtensionToContentTypeMapImpl(DocumentExtensions documentExtensions, Map map) {
        documentExtensions.setExtensionToContentTypeMapImpl(map);
    }

    public final class 2
    extends IdeAdapter {
        private final /* synthetic */ DocRecord[] v$records;
        final /* synthetic */ DocumentExtensions this$0;

        public void addinsLoaded(IdeEvent ideEvent) {
            DocumentExtensions.mav$_setUserExtensionList1(this.this$0, this.v$records);
            Ide.removeIdeListener(this);
        }

        public 2(DocumentExtensions documentExtensions, DocRecord[] docRecordArray) {
            this.v$records = docRecordArray;
            this.this$0 = documentExtensions;
        }
    }

    public final class 1
    extends IdeAdapter {
        private final /* synthetic */ Map v$contentTypeMap;
        final /* synthetic */ DocumentExtensions this$0;

        public void addinsLoaded(IdeEvent ideEvent) {
            DocumentExtensions.mav$setExtensionToContentTypeMapImpl(this.this$0, this.v$contentTypeMap);
            Ide.removeIdeListener(this);
        }

        public 1(DocumentExtensions documentExtensions, Map map) {
            this.v$contentTypeMap = map;
            this.this$0 = documentExtensions;
        }
    }

    private static final class NodeExtensionKey {
        private final Class m_NodeClass;
        private final boolean m_MatchIfEqual;

        public NodeExtensionKey(Class clazz, boolean bl) {
            this.m_NodeClass = clazz;
            this.m_MatchIfEqual = bl;
        }

        public int hashCode() {
            return this.m_NodeClass.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof NodeExtensionKey) {
                NodeExtensionKey nodeExtensionKey = (NodeExtensionKey)object;
                if (this.m_NodeClass.equals(nodeExtensionKey.m_NodeClass) && this.m_MatchIfEqual == nodeExtensionKey.m_MatchIfEqual) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class DocRecord
    implements Copyable {
        private Class _docClass;
        private String _docClassName;
        private Icon _icon;
        private DocumentInfo _info;
        private String _label;
        private List _ideExtensions;
        private List _userExtensions;
        private boolean _isDocClassInitialized;

        void $init$() {
            this._ideExtensions = new ArrayList();
            this._userExtensions = new ArrayList();
        }

        public DocRecord() {
            this.$init$();
        }

        public DocRecord(Class clazz, DocumentInfo documentInfo) {
            this.$init$();
            this._docClass = clazz;
            this._docClassName = clazz.getName();
            this._info = documentInfo;
            if (documentInfo != null) {
                this._label = documentInfo.getLabel();
            }
            if (this._label == null) {
                this._label = clazz.getName();
            }
        }

        public static String sanitizeExtensionAsString(String string) {
            return Recognizer.sanitizeExtension(string).getPath();
        }

        public ExtInfo addIdeExtension(String string) {
            ExtInfo extInfo = new ExtInfo(string, true);
            int n = this._ideExtensions.indexOf(extInfo);
            if (n < 0) {
                this._ideExtensions.add(extInfo);
                return extInfo;
            }
            return (ExtInfo)this._ideExtensions.get(n);
        }

        public ExtInfo addUserExtension(String string) {
            ExtInfo extInfo = new ExtInfo(string, false);
            int n = this._userExtensions.indexOf(extInfo);
            if (n < 0) {
                this._userExtensions.add(extInfo);
                return extInfo;
            }
            return (ExtInfo)this._userExtensions.get(n);
        }

        public ExtInfo removeUserExtension(String string) {
            ExtInfo extInfo = new ExtInfo(string);
            int n = this._userExtensions.indexOf(extInfo);
            if (n < 0) {
                return null;
            }
            extInfo = (ExtInfo)this._userExtensions.get(n);
            this._userExtensions.remove(n);
            return extInfo;
        }

        public Icon getIcon() {
            if (this._info != null) {
                this._icon = this._info.getIcon();
                this._info = null;
            }
            return this._icon;
        }

        public String getLabel() {
            return this._label;
        }

        public Class getDocClass() {
            if (!this._isDocClassInitialized) {
                this._isDocClassInitialized = true;
                try {
                    this._docClass = Class.forName(this._docClassName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this._docClass;
        }

        public List getExtensions() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this._userExtensions);
            arrayList.addAll(this._ideExtensions);
            return arrayList;
        }

        public boolean isExtensionInUse(String string) {
            return this.getExtensions().contains(new ExtInfo(string));
        }

        public List getUserExtensions() {
            return new ArrayList(this._userExtensions);
        }

        public void setUserExtensions(List list) {
            this._userExtensions = list;
        }

        public String getDocClassName() {
            return this._docClassName;
        }

        public void setDocClassName(String string) {
            this._docClassName = string;
        }

        public Object copyTo(Object object) {
            DocRecord docRecord = object != null ? (DocRecord)object : new DocRecord();
            this.copyToImpl(docRecord);
            return docRecord;
        }

        protected final void copyToImpl(DocRecord docRecord) {
            docRecord._docClass = this._docClass;
            docRecord._docClassName = this._docClassName;
            docRecord._icon = this._icon;
            docRecord._label = this._label;
            docRecord._info = this._info;
            docRecord._ideExtensions.clear();
            ModelUtil.deepCopy((List)this._ideExtensions, (List)docRecord._ideExtensions);
            docRecord._userExtensions.clear();
            ModelUtil.deepCopy((List)this._userExtensions, (List)docRecord._userExtensions);
        }

        public String toString() {
            return this._label;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((DocRecord)object);
        }

        protected final boolean equalsImpl(DocRecord docRecord) {
            return docRecord._docClass == this._docClass && ModelUtil.areEqual((Object)docRecord._userExtensions, (Object)this._userExtensions);
        }
    }

    public static class ExtInfo
    implements Copyable {
        private boolean _locked;
        private String _extension;
        private boolean _associated;

        public ExtInfo() {
        }

        public ExtInfo(String string) {
            this(string, false);
        }

        public ExtInfo(String string, boolean bl) {
            this._extension = DocRecord.sanitizeExtensionAsString(string);
            this._locked = bl;
            this._associated = false;
        }

        public void setLocked(boolean bl) {
            this._locked = bl;
        }

        public boolean isLocked() {
            return this._locked;
        }

        public boolean isAssociated() {
            return this._associated;
        }

        public String getExtension() {
            return this._extension;
        }

        public void setExtension(String string) {
            this._extension = string;
        }

        protected void setAssociated(boolean bl) {
            this._associated = bl;
        }

        public Object copyTo(Object object) {
            ExtInfo extInfo = object != null ? (ExtInfo)object : new ExtInfo();
            this.copyToImpl(extInfo);
            return extInfo;
        }

        protected final void copyToImpl(ExtInfo extInfo) {
            extInfo._extension = this._extension;
            extInfo._locked = this._locked;
            extInfo._associated = this._associated;
        }

        public String toString() {
            return this._extension;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            return this.equalsImpl((ExtInfo)object);
        }

        protected final boolean equalsImpl(ExtInfo extInfo) {
            return extInfo._extension.equals(this._extension);
        }
    }
}

