/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.config.FileAssociations;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.icons.IdeIcons;
import oracle.ide.model.ContentType;
import oracle.ide.model.DeployableTextNode;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.DocExtArb;
import oracle.ide.util.MenuSpec;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.columnlayout.LayoutBuilder;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.controls.nicetable.NiceTableModel;
import oracle.javatools.dialogs.MessageDialog;

public class DocumentExtensionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private Map _docRecordCache;
    private Map _extInfoCache;
    private Map _editorAddinCache;
    private Map _extensionToContentTypeMap;
    private Map _defaultEditorMap;
    private Map _associationMap;
    private static final boolean IS_WINDOWS = File.separatorChar == '\\';
    private final JTabbedPane _tabbedPane;
    private final JPanel _fileTypesPanel;
    private final FileTypesTable _fileTypesTable;
    private final JPanel _fileTypesDetailPanel;
    private final JButton _addButton;
    private final JButton _removeButton;
    private final JLabel _fileTypeLabel;
    private final JComboBox _fileTypeCombo;
    private final JLabel _contentLabel;
    private final JRadioButton _contentTextRadioButton;
    private final JRadioButton _contentBinaryRadioButton;
    private JCheckBox _openWithCheckBox;
    private ImageIcon _openWithIcon;
    private TitledBorder _fileTypesDetailBorder;
    private final JPanel _defaultEditorsPanel;
    private final DefaultEditorsTable _defaultEditorsTable;
    private final JPanel _defaultEditorsDetailPanel;
    private final JLabel _defaultEditorLabel;
    private final JComboBox _defaultEditorCombo;
    private final JLabel _defaultEditorCustomizedLabel;
    private final JPanel _spacerPanel;
    private TitledBorder _defaultEditorsDetailBorder;

    void $init$() {
        this._tabbedPane = new JTabbedPane();
        this._fileTypesPanel = new JPanel();
        this._fileTypesTable = new FileTypesTable(null);
        this._fileTypesDetailPanel = new JPanel();
        this._addButton = new JButton();
        this._removeButton = new JButton();
        this._fileTypeLabel = new JLabel();
        this._fileTypeCombo = new JComboBox();
        this._contentLabel = new JLabel();
        this._contentTextRadioButton = new JRadioButton();
        this._contentBinaryRadioButton = new JRadioButton();
        this._defaultEditorsPanel = new JPanel();
        this._defaultEditorsTable = new DefaultEditorsTable(null);
        this._defaultEditorsDetailPanel = new JPanel();
        this._defaultEditorLabel = new JLabel();
        this._defaultEditorCombo = new JComboBox();
        this._defaultEditorCustomizedLabel = new JLabel();
        this._spacerPanel = new JPanel();
    }

    public DocumentExtensionsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setHelpID("f1_idedidesetfiletypes_html");
    }

    public void onEntry(TraversableContext traversableContext) {
        DocumentExtensions documentExtensions = (DocumentExtensions)traversableContext.find("document-extensions-options");
        this.loadFrom(documentExtensions);
    }

    public void onExit(TraversableContext traversableContext) {
        DocumentExtensions documentExtensions = (DocumentExtensions)traversableContext.find("document-extensions-options");
        this.commitTo(documentExtensions);
    }

    public void apply(ApplyEvent applyEvent) {
        TraversableContext traversableContext = (TraversableContext)applyEvent.getSource();
        DocumentExtensions documentExtensions = (DocumentExtensions)traversableContext.find("document-extensions-options");
        Collection collection = documentExtensions.getDocuments();
        DocumentExtensions.DocRecord[] docRecordArray = new DocumentExtensions.DocRecord[collection.size()];
        docRecordArray = collection.toArray(docRecordArray);
        documentExtensions.setUserExtensionList(docRecordArray);
        documentExtensions.setExtensionToContentTypeMap(this._extensionToContentTypeMap);
        documentExtensions.setDefaultEditorMap(this._defaultEditorMap);
        if (IS_WINDOWS) {
            this.applyAssociations(documentExtensions);
        }
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private void jbInit() throws Exception {
        this.buildLayouts();
        this.initializeFromResources();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._contentTextRadioButton);
        buttonGroup.add(this._contentBinaryRadioButton);
        buttonGroup = null;
        this._fileTypesDetailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this._fileTypesDetailPanel.setBorder(this._fileTypesDetailBorder);
        CustomComboBoxRenderer customComboBoxRenderer = new FileTypeComboBoxRenderer(this._fileTypeCombo);
        this._fileTypeCombo.setRenderer(customComboBoxRenderer);
        this._defaultEditorsDetailBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder());
        this._defaultEditorsDetailPanel.setBorder(this._defaultEditorsDetailBorder);
        customComboBoxRenderer = new DefaultEditorComboBoxRenderer(this._defaultEditorCombo);
        customComboBoxRenderer.setRendererFlags(1);
        this._defaultEditorCombo.setRenderer(customComboBoxRenderer);
        this.attachListeners();
    }

    private void buildLayouts() {
        Insets insets = new Insets(2, 2, 2, 2);
        LayoutBuilder layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)new JScrollPane((Component)((Object)this._fileTypesTable)), insets, 3, true, true);
        layoutBuilder.nl();
        layoutBuilder.addHFiller();
        layoutBuilder.add((Component)this._addButton, insets, 1, false, false);
        layoutBuilder.add((Component)this._removeButton, insets, 1, false, false);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._fileTypesDetailPanel, insets, 3, false, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)this._fileTypesPanel);
        layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)this._fileTypeLabel, insets, 2, false, false);
        layoutBuilder.add((Component)this._fileTypeCombo, insets, 2, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._contentLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._contentTextRadioButton, insets, 1, false, false);
        layoutBuilder.add((Component)this._contentBinaryRadioButton, insets, 1, false, true);
        layoutBuilder.nl();
        if (IS_WINDOWS) {
            this._openWithCheckBox = new JCheckBox();
            layoutBuilder.add((Component)this._openWithCheckBox, insets, 4, false, true);
            layoutBuilder.nl();
        }
        layoutBuilder.addToPanel((Container)this._fileTypesDetailPanel);
        layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)new JScrollPane((Component)((Object)this._defaultEditorsTable)), insets, 1, true, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._spacerPanel, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.add((Component)this._defaultEditorsDetailPanel, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)this._defaultEditorsPanel);
        layoutBuilder = new LayoutBuilder();
        layoutBuilder.add((Component)this._defaultEditorLabel, insets, 1, false, false);
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._defaultEditorCombo, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addHGap();
        layoutBuilder.addHGap();
        layoutBuilder.add((Component)this._defaultEditorCustomizedLabel, insets, 1, false, true);
        layoutBuilder.nl();
        layoutBuilder.addToPanel((Container)this._defaultEditorsDetailPanel);
        this.setLayout(new BorderLayout());
        this._tabbedPane.add(this._fileTypesPanel);
        this._tabbedPane.add(this._defaultEditorsPanel);
        this.add((Component)this._tabbedPane, "Center");
    }

    private void initializeFromResources() {
        this._tabbedPane.setTitleAt(0, DocExtArb.getString(2));
        this._tabbedPane.setTitleAt(1, DocExtArb.getString(3));
        ResourceUtils.resButton(this._addButton, DocExtArb.getString(0));
        ResourceUtils.resButton(this._removeButton, DocExtArb.getString(1));
        ResourceUtils.resLabel(this._fileTypeLabel, this._fileTypeCombo, DocExtArb.getString(4));
        ResourceUtils.resLabel(this._contentLabel, this._contentTextRadioButton, DocExtArb.getString(5));
        ResourceUtils.resButton(this._contentTextRadioButton, DocExtArb.getString(8));
        ResourceUtils.resButton(this._contentBinaryRadioButton, DocExtArb.getString(9));
        if (IS_WINDOWS) {
            ResourceUtils.resButton(this._openWithCheckBox, DocExtArb.format(6, Ide.getProgramShortName()));
            this._openWithIcon = new ImageIcon(IdeIcons.getImage(0));
        }
        ResourceUtils.resLabel(this._defaultEditorLabel, this._defaultEditorCombo, DocExtArb.getString(7));
    }

    private void attachListeners() {
        this._fileTypesTable.getSelectionModel().addListSelectionListener(new 9());
        this._addButton.addActionListener(new 8());
        this._removeButton.addActionListener(new 7());
        this._fileTypeCombo.addItemListener(new 6());
        this._contentTextRadioButton.addActionListener(new 5());
        this._contentBinaryRadioButton.addActionListener(new 4());
        if (IS_WINDOWS) {
            this._openWithCheckBox.addActionListener(new 3());
        }
        this._defaultEditorsTable.getSelectionModel().addListSelectionListener(new 2());
        this._defaultEditorCombo.addItemListener(new 1());
    }

    private void loadFrom(DocumentExtensions documentExtensions) {
        this._docRecordCache = this.createDocRecordCache(documentExtensions);
        this._extInfoCache = this.createExtInfoCache(documentExtensions);
        this._editorAddinCache = this.createEditorAddinCache(documentExtensions);
        this._extensionToContentTypeMap = documentExtensions.getExtensionToContentTypeMap();
        this._extensionToContentTypeMap = this.copyMap(this._extensionToContentTypeMap);
        this._defaultEditorMap = documentExtensions.getDefaultEditorMap();
        this._defaultEditorMap = this.copyMap(this._defaultEditorMap);
        if (IS_WINDOWS) {
            this._associationMap = documentExtensions.getAssociationMap();
            this._associationMap = this.copyMap(this._associationMap);
        }
        if (this._fileTypesTable.getBaseModel() instanceof FileTypesTableModel) {
            return;
        }
        this._fileTypesTable.installModel(this.createFileTypesTableModel());
        this._defaultEditorsTable.installModel(this.createDefaultEditorsTableModel());
        this._fileTypeCombo.setModel(this.createFileTypeComboModel());
        this._fileTypesTable_valueChanged(null);
        this._defaultEditorsTable_valueChanged(null);
        Dimension dimension = new Dimension(Math.max(this._fileTypesDetailPanel.getPreferredSize().width, this._defaultEditorsDetailPanel.getPreferredSize().width), Math.max(this._fileTypesDetailPanel.getPreferredSize().height, this._defaultEditorsDetailPanel.getPreferredSize().height));
        this._fileTypesDetailPanel.setPreferredSize(dimension);
        this._defaultEditorsDetailPanel.setPreferredSize(dimension);
        this._spacerPanel.setPreferredSize(this._addButton.getPreferredSize());
    }

    private void commitTo(DocumentExtensions documentExtensions) {
        if (IS_WINDOWS) {
            documentExtensions.setAssociationMap(this._associationMap);
        }
    }

    private Map copyMap(Map map) {
        return map != null ? new HashMap(map) : new HashMap();
    }

    private Map createDocRecordCache(DocumentExtensions documentExtensions) {
        HashMap<Class, DocumentExtensions.DocRecord> hashMap = new HashMap<Class, DocumentExtensions.DocRecord>();
        for (DocumentExtensions.DocRecord docRecord : documentExtensions.getDocuments()) {
            hashMap.put(docRecord.getDocClass(), docRecord);
        }
        return hashMap;
    }

    private Map createExtInfoCache(DocumentExtensions documentExtensions) {
        HashMap<String, DocumentExtensions.ExtInfo> hashMap = new HashMap<String, DocumentExtensions.ExtInfo>();
        for (DocumentExtensions.DocRecord docRecord : documentExtensions.getDocuments()) {
            for (DocumentExtensions.ExtInfo extInfo : docRecord.getExtensions()) {
                hashMap.put(extInfo.getExtension(), extInfo);
            }
        }
        return hashMap;
    }

    private Map createEditorAddinCache(DocumentExtensions documentExtensions) {
        HashMap<Class, EditorAddin[]> hashMap = new HashMap<Class, EditorAddin[]>();
        Class[] classArray = EditorManager.getEditorManager().getStaticElementTypes();
        int n = 0;
        while (n < classArray.length) {
            EditorAddin[] editorAddinArray;
            if (classArray[n] != null && (editorAddinArray = EditorManager.getEditorManager().getStaticAddins(classArray[n])) != null && editorAddinArray.length > 0 && (Recognizer.getDocumentInfo(classArray[n]) != null || editorAddinArray.length >= 2)) {
                hashMap.put(classArray[n], editorAddinArray);
            }
            ++n;
        }
        return hashMap;
    }

    private TableModel createFileTypesTableModel() {
        FileTypesTableModel fileTypesTableModel = new FileTypesTableModel(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        fileTypesTableModel.addColumn(DocExtArb.getString(10));
        fileTypesTableModel.addColumn(DocExtArb.getString(11));
        if (IS_WINDOWS) {
            fileTypesTableModel.addColumn(DocExtArb.format(12, Ide.getProgramShortName()));
        }
        for (DocumentExtensions.DocRecord docRecord : this._docRecordCache.values()) {
            for (DocumentExtensions.ExtInfo extInfo : docRecord.getExtensions()) {
                boolean bl = arrayList.contains(extInfo.getExtension());
                if (!bl) {
                    arrayList.add(extInfo.getExtension());
                }
                if (IS_WINDOWS) {
                    extInfo.setAssociated(FileAssociations.isAssociated(extInfo.getExtension()));
                    if (bl) continue;
                    fileTypesTableModel.addRow(new Object[]{extInfo.getExtension(), docRecord.getDocClass(), extInfo.isAssociated() ? this._openWithIcon : null});
                    continue;
                }
                if (bl) continue;
                fileTypesTableModel.addRow(new Object[]{extInfo.getExtension(), docRecord.getDocClass()});
            }
        }
        return fileTypesTableModel;
    }

    private TableModel createDefaultEditorsTableModel() {
        DefaultEditorsTableModel defaultEditorsTableModel = new DefaultEditorsTableModel(null);
        defaultEditorsTableModel.addColumn(DocExtArb.getString(11));
        defaultEditorsTableModel.addColumn(DocExtArb.getString(13));
        for (Map.Entry entry : this._editorAddinCache.entrySet()) {
            Class clazz = (Class)entry.getKey();
            EditorAddin[] editorAddinArray = (EditorAddin[])entry.getValue();
            EditorAddin editorAddin = null;
            if (this._defaultEditorMap.containsKey(clazz.getName())) {
                String string = (String)this._defaultEditorMap.get(clazz.getName());
                int n = 0;
                while (n < editorAddinArray.length) {
                    if (editorAddinArray[n].getClass().getName().equals(string)) {
                        editorAddin = editorAddinArray[n];
                        break;
                    }
                    ++n;
                }
                if (editorAddin == null) {
                    this._defaultEditorMap.remove(clazz.getName());
                }
            }
            if (editorAddin == null && editorAddinArray.length > 0) {
                editorAddin = editorAddinArray[0];
            }
            if (editorAddin == null) continue;
            defaultEditorsTableModel.addRow(new Object[]{clazz, editorAddin});
        }
        return defaultEditorsTableModel;
    }

    private ComboBoxModel createFileTypeComboModel() {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        sortedComboBoxModel.setComparator(new FileTypeComparator(null));
        Iterator iterator = this._docRecordCache.keySet().iterator();
        while (iterator.hasNext()) {
            sortedComboBoxModel.addElement(iterator.next());
        }
        return sortedComboBoxModel;
    }

    private ComboBoxModel createDefaultEditorComboModel(Class clazz) {
        SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel();
        sortedComboBoxModel.setComparator(new DefaultEditorComparator(null));
        if (clazz == null) {
            return sortedComboBoxModel;
        }
        EditorAddin[] editorAddinArray = (EditorAddin[])this._editorAddinCache.get(clazz);
        int n = 0;
        while (editorAddinArray != null && n < editorAddinArray.length) {
            sortedComboBoxModel.addElement(editorAddinArray[n]);
            ++n;
        }
        return sortedComboBoxModel;
    }

    private void setFileTypesDetailEnabled(boolean bl) {
        this._removeButton.setEnabled(bl);
        this._fileTypeLabel.setEnabled(bl);
        this._fileTypeCombo.setEnabled(bl);
    }

    private void setFileTypesDetailContentEnabled(boolean bl) {
        this._contentLabel.setEnabled(bl);
        this._contentTextRadioButton.setEnabled(bl);
        this._contentBinaryRadioButton.setEnabled(bl);
    }

    private void setDefaultEditorsDetailEnabled(boolean bl) {
        this._defaultEditorLabel.setEnabled(bl);
        this._defaultEditorCombo.setEnabled(bl);
        this._defaultEditorCustomizedLabel.setEnabled(bl);
    }

    private void repaintFileTypesDetailPanel() {
        this.repaintPanel(this._fileTypesDetailPanel);
    }

    private void repaintDefaultEditorsDetailPanel() {
        this.repaintPanel(this._defaultEditorsDetailPanel);
    }

    private void repaintPanel(JPanel jPanel) {
        jPanel.invalidate();
        jPanel.validate();
        jPanel.repaint();
    }

    private ContentType findContentTypeFromExtension(String string) {
        ContentType contentType = null;
        if (contentType == null) {
            String string2 = (String)this._extensionToContentTypeMap.get(string);
            ContentType contentType2 = contentType = string2 != null ? ContentType.valueOf(string2) : null;
        }
        if (contentType == null) {
            contentType = DocumentExtensions.findContentTypeFromExtension(string);
        }
        return contentType;
    }

    private void changeSelectionContentType(ContentType contentType) {
        this._extensionToContentTypeMap.put(this._fileTypesTable.getSelectedExtension(), contentType.name());
    }

    private void setFileTypesContentTypeDefault(Class clazz) {
        String string = this.findFirstRecognizerExtension(clazz);
        if (string != null) {
            this.changeSelectionContentType(DocumentExtensions.findContentTypeFromExtension(string));
            this._fileTypesTable_valueChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFirstRecognizerExtension(Class clazz) {
        Map map;
        Map map2 = map = Recognizer.getExtensionToClassMap();
        synchronized (map2) {
            for (Map.Entry entry : map.entrySet()) {
                if (!clazz.equals(entry.getValue())) continue;
                File file = (File)entry.getKey();
                String string = file.getPath();
                return string;
            }
        }
        return null;
    }

    private void changeDefaultEditor(Class clazz, EditorAddin editorAddin) {
        if (clazz == null || editorAddin == null) {
            return;
        }
        EditorAddin editorAddin2 = ((EditorAddin[])this._editorAddinCache.get(clazz))[0];
        if (editorAddin != editorAddin2) {
            this._defaultEditorMap.put(clazz.getName(), editorAddin.getClass().getName());
        } else {
            this._defaultEditorMap.remove(clazz.getName());
        }
    }

    private void updateDefaultEditorCustomizedLabel(Class clazz, EditorAddin editorAddin) {
        if (clazz == null || editorAddin == null) {
            this._defaultEditorCustomizedLabel.setText(" ");
            return;
        }
        EditorAddin editorAddin2 = ((EditorAddin[])this._editorAddinCache.get(clazz))[0];
        if (editorAddin != editorAddin2) {
            String string = editorAddin2.getMenuSpecification().label;
            this._defaultEditorCustomizedLabel.setText(DocExtArb.format(20, string));
        } else {
            this._defaultEditorCustomizedLabel.setText(DocExtArb.getString(21));
        }
    }

    private void _fileTypesTable_valueChanged(ListSelectionEvent listSelectionEvent) {
        ContentType contentType;
        String string = this._fileTypesTable.getSelectedExtension();
        Class clazz = this._fileTypesTable.getSelectedDocClass();
        DocumentExtensions.ExtInfo extInfo = string != null ? (DocumentExtensions.ExtInfo)this._extInfoCache.get(string) : null;
        this.setFileTypesDetailEnabled(extInfo != null && !extInfo.isLocked());
        this.setFileTypesDetailContentEnabled(extInfo != null);
        this._fileTypesDetailBorder.setTitle(DocExtArb.format(14, extInfo != null ? extInfo.toString() : ""));
        if (string == null) {
            this.repaintFileTypesDetailPanel();
            return;
        }
        if (clazz != null) {
            this._fileTypeCombo.setSelectedItem(clazz);
        }
        this._contentTextRadioButton.setSelected((contentType = this.findContentTypeFromExtension(string)) == ContentType.TEXT);
        this._contentBinaryRadioButton.setSelected(contentType == ContentType.BINARY);
        if (IS_WINDOWS) {
            this._openWithCheckBox.setSelected(extInfo != null && extInfo.isAssociated());
        }
        this.repaintFileTypesDetailPanel();
    }

    private void _addButton_actionPerformed(ActionEvent actionEvent) {
        String string;
        AddExtensionDialog addExtensionDialog = new AddExtensionDialog(this);
        String string2 = DocExtArb.getString(16);
        if (!addExtensionDialog.show(string2, string = DocExtArb.getString(17), "f1_idedaddextension_html")) {
            return;
        }
        String string3 = DocumentExtensions.DocRecord.sanitizeExtensionAsString(addExtensionDialog.getInputValue());
        if (IS_WINDOWS) {
            ((FileTypesTableModel)this._fileTypesTable.getBaseModel()).addRow(new Object[]{string3, DeployableTextNode.class, this._openWithIcon});
        } else {
            ((FileTypesTableModel)this._fileTypesTable.getBaseModel()).addRow(new Object[]{string3, DeployableTextNode.class});
        }
        this._fileTypesTable.reSort();
        DocumentExtensions.ExtInfo extInfo = ((DocumentExtensions.DocRecord)this._docRecordCache.get(DeployableTextNode.class)).addUserExtension(string3);
        if (IS_WINDOWS) {
            this._associationMap.put(string3, new Boolean(true));
            extInfo.setAssociated(true);
        }
        this._extInfoCache.put(string3, extInfo);
        this._fileTypesTable.setSelectedExtension(string3);
        this._fileTypesTable_valueChanged(null);
    }

    private void _removeButton_actionPerformed(ActionEvent actionEvent) {
        int n = this._fileTypesTable.getSelectedRow();
        String string = this._fileTypesTable.getSelectedExtension();
        Class clazz = this._fileTypesTable.getSelectedDocClass();
        if (!MessageDialog.optionalConfirm((String)"Ide.FileTypes.RemoveConfirm", null, (String)DocExtArb.format(22, string), (String)DocExtArb.getString(23), null)) {
            return;
        }
        this._extInfoCache.remove(string);
        if (IS_WINDOWS) {
            this._associationMap.put(string, new Boolean(false));
        }
        this._extensionToContentTypeMap.remove(string);
        FileTypesTableModel fileTypesTableModel = (FileTypesTableModel)this._fileTypesTable.getBaseModel();
        fileTypesTableModel.removeRow(this._fileTypesTable.rowIndexOfExtension(string, fileTypesTableModel));
        this._fileTypesTable.reSort();
        ((DocumentExtensions.DocRecord)this._docRecordCache.get(clazz)).removeUserExtension(string);
        if (this._fileTypesTable.getRowCount() <= 0) {
            return;
        }
        this._fileTypesTable.setSelectedRow(Math.min(n, this._fileTypesTable.getRowCount() - 1));
        this._fileTypesTable_valueChanged(null);
    }

    private void _fileTypeCombo_itemStateChanged(ItemEvent itemEvent) {
        Class clazz;
        String string = this._fileTypesTable.getSelectedExtension();
        Class clazz2 = this._fileTypesTable.getSelectedDocClass();
        if (clazz2.equals(clazz = (Class)this._fileTypeCombo.getSelectedItem())) {
            return;
        }
        ((DocumentExtensions.DocRecord)this._docRecordCache.get(clazz2)).removeUserExtension(string);
        DocumentExtensions.ExtInfo extInfo = ((DocumentExtensions.DocRecord)this._docRecordCache.get(clazz)).addUserExtension(string);
        this._extInfoCache.put(string, extInfo);
        FileTypesTableModel fileTypesTableModel = (FileTypesTableModel)this._fileTypesTable.getBaseModel();
        int n = this._fileTypesTable.rowIndexOfExtension(string, fileTypesTableModel);
        this._fileTypesTable.setBaseModelDocClassValue(clazz, n);
        this.setFileTypesContentTypeDefault(clazz);
    }

    private void _contentTextRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.changeSelectionContentType(ContentType.TEXT);
    }

    private void _contentBinaryRadioButton_actionPerformed(ActionEvent actionEvent) {
        this.changeSelectionContentType(ContentType.BINARY);
    }

    private void _openWithCheckBox_actionPerformed(ActionEvent actionEvent) {
        DocumentExtensions.ExtInfo extInfo;
        String string = this._fileTypesTable.getSelectedExtension();
        boolean bl = this._openWithCheckBox.isSelected();
        DocumentExtensions.ExtInfo extInfo2 = extInfo = string != null ? (DocumentExtensions.ExtInfo)this._extInfoCache.get(string) : null;
        if (extInfo == null) {
            return;
        }
        this._associationMap.put(string, new Boolean(bl));
        extInfo.setAssociated(bl);
        this._extInfoCache.put(string, extInfo);
        FileTypesTableModel fileTypesTableModel = (FileTypesTableModel)this._fileTypesTable.getBaseModel();
        int n = this._fileTypesTable.rowIndexOfExtension(string, fileTypesTableModel);
        this._fileTypesTable.setBaseModelOpenWithValue(this._openWithCheckBox.isSelected() ? this._openWithIcon : null, n);
        this._fileTypesTable_valueChanged(null);
    }

    private void _defaultEditorsTable_valueChanged(ListSelectionEvent listSelectionEvent) {
        DocumentExtensions.DocRecord docRecord;
        Class clazz = this._defaultEditorsTable.getSelectedDocClass();
        EditorAddin editorAddin = this._defaultEditorsTable.getSelectedEditorAddin();
        DocumentExtensions.DocRecord docRecord2 = docRecord = clazz != null ? (DocumentExtensions.DocRecord)this._docRecordCache.get(clazz) : null;
        if (clazz != null) {
            this._defaultEditorCombo.setModel(this.createDefaultEditorComboModel(clazz));
        }
        this.setDefaultEditorsDetailEnabled(clazz != null);
        this._defaultEditorsDetailBorder.setTitle(DocExtArb.format(15, clazz != null ? RendererUtil.getDocumentLabel(clazz) : ""));
        if (clazz == null) {
            this.repaintDefaultEditorsDetailPanel();
            return;
        }
        if (editorAddin != null) {
            this._defaultEditorCombo.setSelectedItem(editorAddin);
        }
        this.updateDefaultEditorCustomizedLabel(clazz, editorAddin);
        this.repaintDefaultEditorsDetailPanel();
    }

    private void _defaultEditorCombo_itemStateChanged(ItemEvent itemEvent) {
        EditorAddin editorAddin;
        Class clazz = this._defaultEditorsTable.getSelectedDocClass();
        EditorAddin editorAddin2 = this._defaultEditorsTable.getSelectedEditorAddin();
        if (editorAddin2.equals(editorAddin = (EditorAddin)this._defaultEditorCombo.getSelectedItem())) {
            return;
        }
        DefaultEditorsTableModel defaultEditorsTableModel = (DefaultEditorsTableModel)this._defaultEditorsTable.getBaseModel();
        int n = this._defaultEditorsTable.rowIndexOfDocClass(clazz, defaultEditorsTableModel);
        this._defaultEditorsTable.setBaseModelEditorAddinValue(editorAddin, n);
        this.changeDefaultEditor(clazz, editorAddin);
        this.updateDefaultEditorCustomizedLabel(clazz, editorAddin);
    }

    private void applyAssociations(DocumentExtensions documentExtensions) {
        for (Map.Entry entry : this._associationMap.entrySet()) {
            String string = (String)entry.getKey();
            Boolean bl = (Boolean)entry.getValue();
            FileAssociations.setAssociated(string, bl);
        }
        this._associationMap.clear();
        documentExtensions.setAssociationMap(this._associationMap);
    }

    static void mav$_fileTypesTable_valueChanged(DocumentExtensionsPanel documentExtensionsPanel, ListSelectionEvent listSelectionEvent) {
        documentExtensionsPanel._fileTypesTable_valueChanged(listSelectionEvent);
    }

    static void mav$_addButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._addButton_actionPerformed(actionEvent);
    }

    static void mav$_removeButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._removeButton_actionPerformed(actionEvent);
    }

    static void mav$_fileTypeCombo_itemStateChanged(DocumentExtensionsPanel documentExtensionsPanel, ItemEvent itemEvent) {
        documentExtensionsPanel._fileTypeCombo_itemStateChanged(itemEvent);
    }

    static void mav$_contentTextRadioButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._contentTextRadioButton_actionPerformed(actionEvent);
    }

    static void mav$_contentBinaryRadioButton_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._contentBinaryRadioButton_actionPerformed(actionEvent);
    }

    static void mav$_openWithCheckBox_actionPerformed(DocumentExtensionsPanel documentExtensionsPanel, ActionEvent actionEvent) {
        documentExtensionsPanel._openWithCheckBox_actionPerformed(actionEvent);
    }

    static void mav$_defaultEditorsTable_valueChanged(DocumentExtensionsPanel documentExtensionsPanel, ListSelectionEvent listSelectionEvent) {
        documentExtensionsPanel._defaultEditorsTable_valueChanged(listSelectionEvent);
    }

    static void mav$_defaultEditorCombo_itemStateChanged(DocumentExtensionsPanel documentExtensionsPanel, ItemEvent itemEvent) {
        documentExtensionsPanel._defaultEditorCombo_itemStateChanged(itemEvent);
    }

    static boolean ra$IS_WINDOWS() {
        return IS_WINDOWS;
    }

    static ImageIcon ra$_openWithIcon(DocumentExtensionsPanel documentExtensionsPanel) {
        return documentExtensionsPanel._openWithIcon;
    }

    static Map ra$_extInfoCache(DocumentExtensionsPanel documentExtensionsPanel) {
        return documentExtensionsPanel._extInfoCache;
    }

    public final class 9
    implements ListSelectionListener {
        public final void valueChanged(ListSelectionEvent listSelectionEvent) {
            DocumentExtensionsPanel.mav$_fileTypesTable_valueChanged(DocumentExtensionsPanel.this, listSelectionEvent);
        }
    }

    public final class 8
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            DocumentExtensionsPanel.mav$_addButton_actionPerformed(DocumentExtensionsPanel.this, actionEvent);
        }
    }

    public final class 7
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            DocumentExtensionsPanel.mav$_removeButton_actionPerformed(DocumentExtensionsPanel.this, actionEvent);
        }
    }

    public final class 6
    implements ItemListener {
        public final void itemStateChanged(ItemEvent itemEvent) {
            DocumentExtensionsPanel.mav$_fileTypeCombo_itemStateChanged(DocumentExtensionsPanel.this, itemEvent);
        }
    }

    public final class 5
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            DocumentExtensionsPanel.mav$_contentTextRadioButton_actionPerformed(DocumentExtensionsPanel.this, actionEvent);
        }
    }

    public final class 4
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            DocumentExtensionsPanel.mav$_contentBinaryRadioButton_actionPerformed(DocumentExtensionsPanel.this, actionEvent);
        }
    }

    public final class 3
    implements ActionListener {
        public final void actionPerformed(ActionEvent actionEvent) {
            DocumentExtensionsPanel.mav$_openWithCheckBox_actionPerformed(DocumentExtensionsPanel.this, actionEvent);
        }
    }

    public final class 2
    implements ListSelectionListener {
        public final void valueChanged(ListSelectionEvent listSelectionEvent) {
            DocumentExtensionsPanel.mav$_defaultEditorsTable_valueChanged(DocumentExtensionsPanel.this, listSelectionEvent);
        }
    }

    public final class 1
    implements ItemListener {
        public final void itemStateChanged(ItemEvent itemEvent) {
            DocumentExtensionsPanel.mav$_defaultEditorCombo_itemStateChanged(DocumentExtensionsPanel.this, itemEvent);
        }
    }

    private abstract class MasterTable
    extends NiceTable {
        void $init$() {
            this.setSelectionMode(0);
            this.setUseTransferHandler(false);
        }

        public void installModel(TableModel tableModel) {
            this.setModel(tableModel);
            this.setSorted(true);
            this.getTableHeader().setReorderingAllowed(false);
            this.initializeCellRenderers();
            int n = 0;
            while (n < this.getColumnCount()) {
                this.getColumnModel().getColumn(n).setHeaderRenderer(this.getTableHeader().getDefaultRenderer());
                ++n;
            }
            this.setAutoResizeMode(0);
            this.autoSizeColumnsToFit();
            ((DefaultTableModel)this.getBaseModel()).fireTableDataChanged();
            this.setSortColumn(0, true);
            if (tableModel.getRowCount() > 0) {
                this.setSelectedRow(0);
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void reSort() {
            this.setSortColumn(this.getSortColumn(), this.isSortAscending());
        }

        public void setSortColumn(int n, boolean bl) {
            int n2 = this.getSelectedRow();
            Object object = n2 >= 0 ? this.getModel().getValueAt(n2, 0) : null;
            super.setSortColumn(n, bl);
            this.selectRowFromKeyValue(object);
        }

        public void setSelectedRow(int n) {
            if (n < 0 && n >= this.getRowCount()) {
                return;
            }
            this.setRowSelectionInterval(n, n);
            this.scrollToSelection();
        }

        public void setBaseModelCellValue(Object object, int n, int n2) {
            Object object2 = this.getBaseModel().getValueAt(n, 0);
            int n3 = this.getSelectedRow();
            boolean bl = n3 >= 0 ? this.getModel().getValueAt(n3, 0).equals(object2) : false;
            this.getBaseModel().setValueAt(object, n, n2);
            ((AbstractTableModel)this.getBaseModel()).fireTableCellUpdated(n, n2);
            super.setSortColumn(this.getSortColumn(), this.isSortAscending());
            if (bl) {
                this.selectRowFromKeyValue(object2);
            }
        }

        public int rowIndexOfValue(Object object, int n) {
            return this.rowIndexOfValue(object, n, this.getModel());
        }

        public int rowIndexOfValue(Object object, int n, TableModel tableModel) {
            int n2 = 0;
            while (n2 < tableModel.getRowCount()) {
                if (tableModel.getValueAt(n2, n).equals(object)) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }

        protected abstract void initializeCellRenderers();

        private void selectRowFromKeyValue(Object object) {
            int n = this.getSelectedRow();
            int n2 = -1;
            if (object != null) {
                n2 = this.rowIndexOfValue(object, 0);
            }
            if (n < 0 || n2 < 0 || n == n2) {
                return;
            }
            this.setSelectedRow(n2);
        }

        private MasterTable() {
            this.$init$();
        }

        MasterTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypesTable
    extends MasterTable {
        public void setSelectedExtension(String string) {
            this.setSelectedRow(this.rowIndexOfExtension(string));
        }

        public String getSelectedExtension() {
            int n = this.getSelectedRow();
            return n >= 0 ? (String)this.getModel().getValueAt(n, 0) : null;
        }

        public Class getSelectedDocClass() {
            int n = this.getSelectedRow();
            return n >= 0 ? (Class)this.getModel().getValueAt(n, 1) : null;
        }

        public int rowIndexOfExtension(String string) {
            return this.rowIndexOfValue(string, 0);
        }

        public int rowIndexOfExtension(String string, TableModel tableModel) {
            return this.rowIndexOfValue(string, 0, tableModel);
        }

        public void setBaseModelDocClassValue(Class clazz, int n) {
            this.setBaseModelCellValue(clazz, n, 1);
        }

        public void setBaseModelOpenWithValue(Object object, int n) {
            this.setBaseModelCellValue(object, n, 2);
        }

        protected void initializeCellRenderers() {
            this.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new FileTypeTableCellRenderer(null)));
            if (DocumentExtensionsPanel.ra$IS_WINDOWS()) {
                this.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new FileTypeTableOpenWithRenderer(null)));
            }
        }

        private FileTypesTable() {
            super(null);
        }

        FileTypesTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorsTable
    extends MasterTable {
        public void setSelectedDocClass(Class clazz) {
            this.setSelectedRow(this.rowIndexOfDocClass(clazz));
        }

        public Class getSelectedDocClass() {
            int n = this.getSelectedRow();
            return n >= 0 ? (Class)this.getModel().getValueAt(n, 0) : null;
        }

        public EditorAddin getSelectedEditorAddin() {
            int n = this.getSelectedRow();
            return n >= 0 ? (EditorAddin)this.getModel().getValueAt(n, 1) : null;
        }

        public int rowIndexOfDocClass(Class clazz) {
            return this.rowIndexOfValue(clazz, 0);
        }

        public int rowIndexOfDocClass(Class clazz, TableModel tableModel) {
            return this.rowIndexOfValue(clazz, 0, tableModel);
        }

        public void setBaseModelEditorAddinValue(EditorAddin editorAddin, int n) {
            this.setBaseModelCellValue(editorAddin, n, 1);
        }

        protected void initializeCellRenderers() {
            this.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new FileTypeTableCellRenderer(null)));
            DefaultEditorTableCellRenderer defaultEditorTableCellRenderer = new DefaultEditorTableCellRenderer(null);
            defaultEditorTableCellRenderer.setRendererFlags(1);
            this.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)defaultEditorTableCellRenderer));
        }

        private DefaultEditorsTable() {
            super(null);
        }

        DefaultEditorsTable(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypesTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int n) {
            return 2;
        }

        public Comparator getColumnSortComparator(int n) {
            if (n == 0) {
                return new CustomStringComparator(null);
            }
            if (n == 1) {
                return new FileTypeComparator(null);
            }
            return null;
        }

        private FileTypesTableModel() {
        }

        FileTypesTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorsTableModel
    extends DefaultTableModel
    implements NiceTableModel {
        public int getColumnAlignment(int n) {
            return 2;
        }

        public Comparator getColumnSortComparator(int n) {
            if (n == 0) {
                return new FileTypeComparator(null);
            }
            if (n == 1) {
                return new DefaultEditorComparator(null);
            }
            return null;
        }

        private DefaultEditorsTableModel() {
        }

        DefaultEditorsTableModel(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class CustomStringComparator
    implements Comparator {
        private final Collator _stringCollator;

        void $init$() {
            this._stringCollator = (Collator)Collator.getInstance().clone();
            this._stringCollator.setStrength(0);
        }

        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null && object2 != null) {
                return 1;
            }
            if (object != null && object2 == null) {
                return -1;
            }
            return this.compareImpl(object, object2);
        }

        protected int compareImpl(Object object, Object object2) {
            return this.getStringCollator().compare(object.toString(), object2.toString());
        }

        protected Collator getStringCollator() {
            return this._stringCollator;
        }

        private CustomStringComparator() {
            this.$init$();
        }

        CustomStringComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypeComparator
    extends CustomStringComparator {
        protected int compareImpl(Object object, Object object2) {
            String string = RendererUtil.getDocumentLabel((Class)object);
            String string2 = RendererUtil.getDocumentLabel((Class)object2);
            return this.getStringCollator().compare(string, string2);
        }

        private FileTypeComparator() {
            super(null);
        }

        FileTypeComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorComparator
    extends CustomStringComparator {
        protected int compareImpl(Object object, Object object2) {
            MenuSpec menuSpec = ((EditorAddin)object).getMenuSpecification();
            MenuSpec menuSpec2 = ((EditorAddin)object2).getMenuSpecification();
            String string = menuSpec != null ? menuSpec.label : object.toString();
            String string2 = menuSpec2 != null ? menuSpec2.label : object2.toString();
            return this.getStringCollator().compare(string, string2);
        }

        private DefaultEditorComparator() {
            super(null);
        }

        DefaultEditorComparator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static interface RendererFlags {
        public static final int HIDE_ICONS = 1;
    }

    private static class RendererUtil {
        public static final Icon createDisabledIcon(Icon icon) {
            if (!(icon instanceof ImageIcon)) {
                return icon;
            }
            return new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage()));
        }

        public static final String getDocumentLabel(Class clazz) {
            String string;
            DocumentInfo documentInfo = Recognizer.getDocumentInfo(clazz);
            String string2 = string = documentInfo != null ? documentInfo.getLabel() : null;
            if (string != null) {
                return string;
            }
            string = clazz.getName();
            int n = string.lastIndexOf(46);
            if (n < 0 || n >= string.length() - 1) {
                return string;
            }
            string = string.substring(n + 1);
            return string;
        }

        public static final Icon getDocumentIcon(Class clazz) {
            DocumentInfo documentInfo = Recognizer.getDocumentInfo(clazz);
            return documentInfo != null ? documentInfo.getIcon() : null;
        }

        private RendererUtil() {
        }
    }

    private class EmptyIcon
    implements Icon {
        private final int _iconWidth;
        private final int _iconHeight;

        EmptyIcon(int n, int n2) {
            this._iconWidth = n;
            this._iconHeight = n2;
        }

        public int getIconWidth() {
            return this._iconWidth;
        }

        public int getIconHeight() {
            return this._iconHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }
    }

    private abstract class CustomComboBoxRenderer
    extends DefaultListCellRenderer {
        private final JComboBox _comboBox;
        private int _rendererFlags;

        CustomComboBoxRenderer(JComboBox jComboBox) {
            this._comboBox = jComboBox;
        }

        public JComboBox getComboBox() {
            return this._comboBox;
        }

        public void setRendererFlags(int n) {
            this._rendererFlags = n;
        }

        public int getRendererFlags() {
            return this._rendererFlags;
        }
    }

    private class FileTypeComboBoxRenderer
    extends CustomComboBoxRenderer {
        FileTypeComboBoxRenderer(JComboBox jComboBox) {
            super(jComboBox);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setIcon(null);
            this.setText("");
            if (object == null) {
                return this;
            }
            this.setText(RendererUtil.getDocumentLabel((Class)object));
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = RendererUtil.getDocumentIcon((Class)object);
            }
            if (icon != null && !this.getComboBox().isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }
    }

    private class DefaultEditorComboBoxRenderer
    extends CustomComboBoxRenderer {
        DefaultEditorComboBoxRenderer(JComboBox jComboBox) {
            super(jComboBox);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setEnabled(jList.isEnabled());
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setIcon(null);
            this.setText("");
            if (object == null) {
                return this;
            }
            MenuSpec menuSpec = ((EditorAddin)object).getMenuSpecification();
            if (menuSpec == null || menuSpec.label == null) {
                this.setText(object.getClass().getName());
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = menuSpec.getIcon()) == null) {
                icon = new EmptyIcon(16, 16);
            }
            if (icon != null && !this.getComboBox().isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            this.setText(menuSpec.label);
            return this;
        }
    }

    private abstract class CustomTableCellRenderer
    extends NiceTableCellRenderer {
        private int _rendererFlags;

        public void setRendererFlags(int n) {
            this._rendererFlags = n;
        }

        public int getRendererFlags() {
            return this._rendererFlags;
        }

        private CustomTableCellRenderer() {
        }

        CustomTableCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypeTableCellRenderer
    extends CustomTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable.isEnabled());
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (object == null) {
                return this;
            }
            this.setText(RendererUtil.getDocumentLabel((Class)object));
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = RendererUtil.getDocumentIcon((Class)object)) == null) {
                icon = new EmptyIcon(16, 16);
            }
            if (icon != null && !jTable.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }

        private FileTypeTableCellRenderer() {
            super(null);
        }

        FileTypeTableCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class FileTypeTableOpenWithRenderer
    extends CustomTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable.isEnabled());
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (object == null) {
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0) {
                icon = DocumentExtensionsPanel.ra$_openWithIcon(DocumentExtensionsPanel.this);
            }
            if (icon != null && !jTable.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            return this;
        }

        private FileTypeTableOpenWithRenderer() {
            super(null);
        }

        FileTypeTableOpenWithRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DefaultEditorTableCellRenderer
    extends CustomTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable.isEnabled());
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setToolTipText(null);
            this.setIcon(null);
            this.setText("");
            if (object == null) {
                return this;
            }
            MenuSpec menuSpec = ((EditorAddin)object).getMenuSpecification();
            if (menuSpec == null || menuSpec.label == null) {
                this.setText(object.getClass().getName());
                return this;
            }
            Icon icon = null;
            if ((this.getRendererFlags() & 1) <= 0 && (icon = menuSpec.getIcon()) == null) {
                icon = new EmptyIcon(16, 16);
            }
            if (icon != null && !jTable.isEnabled()) {
                icon = RendererUtil.createDisabledIcon(icon);
            }
            this.setIcon(icon);
            this.setText(menuSpec.label);
            return this;
        }

        private DefaultEditorTableCellRenderer() {
            super(null);
        }

        DefaultEditorTableCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class AddExtensionDialog
    extends SimpleInputDialog {
        AddExtensionDialog(Component component) {
            super(component);
        }

        public boolean validate(String string) {
            int n = string.lastIndexOf(".");
            if (n > 0) {
                String string2 = DocExtArb.format(18, string);
                JOptionPane.showMessageDialog((Component)this.getDialog(), string2, DocExtArb.getString(16), 0);
                return false;
            }
            string = DocumentExtensions.DocRecord.sanitizeExtensionAsString(string);
            if (DocumentExtensionsPanel.ra$_extInfoCache(DocumentExtensionsPanel.this).containsKey(string)) {
                String string3 = DocExtArb.format(19, string);
                JOptionPane.showMessageDialog((Component)this.getDialog(), string3, DocExtArb.getString(16), 0);
                return false;
            }
            return true;
        }
    }
}

