/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.controls.SortedComboBoxModel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.util.Encodings;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class EnvironOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static boolean _lafChanged;
    private static IdeUIManager.ThemeInfo _selectedTheme;
    private JCheckBox _jcbShowSplash;
    private JCheckBox _jcbAutoReloadExtMod;
    private JCheckBox _jcbSilentReload;
    private JCheckBox _jcbVerifyVFSData;
    private JCheckBox _jcbSaveBeforeCompile;
    private JCheckBox _jcbClearLogBeforeCompile;
    private JCheckBox _jcbSaveOnDeactivation;
    private JCheckBox _jcbShowCompileProgress;
    private JLabel _lblLaf;
    private JComboBox _cmbLaf;
    private JLabel _lblLafTheme;
    private JComboBox _cmbLafTheme;
    private JTextField _jtfUndoLevel;
    private JTextField _jtfNavigationLevel;
    private JLabel _lblEncoding;
    private JComboBox _cmbEncoding;
    private JComboBox _jcbLineTerminator;
    private JButton _resetSkippedMessages;
    private UIManager.LookAndFeelInfo[] _lafInfo;
    private boolean _askExit;

    void $init$() {
        this._lafInfo = UIManager.getInstalledLookAndFeels();
    }

    public EnvironOptionsPanel() {
        this.$init$();
        this.setHelpID("f1_idedidesetenvironment_html");
        this.initComponents();
    }

    public void onEntry(TraversableContext traversableContext) {
        EnvironOptions environOptions = (EnvironOptions)traversableContext.find("environment-options");
        this.load(environOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        EnvironOptions environOptions = (EnvironOptions)traversableContext.find("environment-options");
        this.commit(environOptions);
        if (this._askExit) {
            IdeSettings ideSettings = (IdeSettings)traversableContext.find("ide-options");
            ideSettings.setAskExit(this._askExit);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._jcbAutoReloadExtMod) {
            this.actionPerformed_AutoReloadExtMod();
        } else if (object == this._cmbLaf) {
            this.actionPerformed_LookAndFeelChanged();
        } else if (object == this._cmbLafTheme) {
            this.actionPerformed_ThemeChanged();
        } else if (object == this._resetSkippedMessages) {
            MessageDialog.resetSkippedMessages();
        }
    }

    private void initComponents() {
        IdeUIManager ideUIManager = IdeUIManager.getUIManager();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        this._jcbShowSplash = new JCheckBox();
        this._jcbAutoReloadExtMod = new JCheckBox();
        this._jcbSilentReload = new JCheckBox();
        this._jcbVerifyVFSData = new JCheckBox();
        this._jcbSaveBeforeCompile = new JCheckBox();
        this._jcbClearLogBeforeCompile = new JCheckBox();
        this._jcbSaveOnDeactivation = new JCheckBox();
        this._jcbShowCompileProgress = new JCheckBox();
        this._jtfUndoLevel = new WholeNumberField(0, 6);
        this._jtfNavigationLevel = new WholeNumberField(0, 6);
        if (ideUIManager != null) {
            this._lblLaf = new JLabel();
            this._cmbLaf = new JComboBox(new SortedComboBoxModel());
            this._lblLafTheme = new JLabel();
            this._cmbLafTheme = new JComboBox(new SortedComboBoxModel());
        }
        this._lblEncoding = new JLabel();
        this._cmbEncoding = new JComboBox();
        this._resetSkippedMessages = new JButton();
        this._resetSkippedMessages.addActionListener(this);
        ResourceUtils.resButton(this._jcbShowSplash, EnvironOptions.getLabelShowSplashScreen());
        ResourceUtils.resButton(this._jcbAutoReloadExtMod, EnvironOptions.getLabelAutoReloadExtMod());
        ResourceUtils.resButton(this._jcbSilentReload, EnvironOptions.getLabelSilentReload());
        ResourceUtils.resButton(this._jcbVerifyVFSData, EnvironOptionsArb.getString(36));
        ResourceUtils.resButton(this._jcbSaveBeforeCompile, EnvironOptions.getLabelSaveBeforeCompile());
        ResourceUtils.resButton(this._jcbClearLogBeforeCompile, EnvironOptions.getLabelClearCompilerLogBeforeCompile());
        ResourceUtils.resButton(this._jcbSaveOnDeactivation, EnvironOptions.getLabelSaveOnDeactivation());
        ResourceUtils.resButton(this._jcbShowCompileProgress, EnvironOptions.getLabelShowCompileProgress());
        ResourceUtils.resLabel(jLabel, this._jtfUndoLevel, EnvironOptions.getLabelUndoLevel());
        ResourceUtils.resLabel(jLabel2, this._jtfNavigationLevel, EnvironOptions.getLabelNavigationLevel());
        if (ideUIManager != null) {
            ResourceUtils.resLabel(this._lblLaf, this._cmbLaf, EnvironOptions.getLabelLookAndFeel());
            ResourceUtils.resLabel(this._lblLafTheme, this._cmbLafTheme, EnvironOptions.getLabelTheme());
        }
        ResourceUtils.resLabel(this._lblEncoding, this._cmbEncoding, EnvironOptions.getLabelEncoding());
        ResourceUtils.resButton(this._resetSkippedMessages, EnvironOptions.getLabelResetSkippedMessages());
        if (ideUIManager != null) {
            this._initLafCombo();
            this._initThemeCombo();
            this._cmbLaf.addActionListener(this);
            this._cmbLafTheme.addActionListener(this);
        }
        this._jcbAutoReloadExtMod.addActionListener(this);
        this.actionPerformed_AutoReloadExtMod();
        Object[] objectArray = new Object[]{EnvironOptionsArb.getString(24), EnvironOptionsArb.getString(25), EnvironOptionsArb.getString(26), EnvironOptionsArb.getString(27)};
        NonNullableComboBoxModel nonNullableComboBoxModel = new NonNullableComboBoxModel(objectArray);
        this._jcbLineTerminator = new JComboBox(nonNullableComboBoxModel);
        this._jcbLineTerminator.setSelectedItem(objectArray[0]);
        JLabel jLabel3 = new JLabel();
        String string = EnvironOptionsArb.getString(22);
        ResourceUtils.resLabel(jLabel3, this._jcbLineTerminator, string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._jcbShowSplash, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._jcbSaveOnDeactivation, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._jcbSaveBeforeCompile, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._jcbClearLogBeforeCompile, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._jcbShowCompileProgress, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this._jcbAutoReloadExtMod, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left += 24;
        this.add((Component)this._jcbSilentReload, gridBagConstraints);
        gridBagConstraints.insets.left -= 24;
        ++gridBagConstraints.gridy;
        this.add((Component)this._jcbVerifyVFSData, gridBagConstraints);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 12;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top += 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this._jtfUndoLevel, gridBagConstraints);
        gridBagConstraints.insets.top -= 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this._jtfNavigationLevel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        if (IdeUIManager.getUIManager() != null) {
            String string2 = EnvironOptionsArb.getString(9);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            this.add((Component)this._lblLaf, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)this._cmbLaf, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(string2), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            ++gridBagConstraints.gridy;
            gridBagConstraints.insets.left += 24;
            this.add((Component)this._lblLafTheme, gridBagConstraints);
            gridBagConstraints.insets.left -= 24;
            ++gridBagConstraints.gridx;
            this.add((Component)this._cmbLafTheme, gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.add((Component)new JLabel(string2), gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this._jcbLineTerminator, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel(EnvironOptionsArb.getString(23)), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this._lblEncoding, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this._cmbEncoding, gridBagConstraints);
        gridBagConstraints.insets.top += 5;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.add((Component)this._resetSkippedMessages, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets.top -= 5;
    }

    private void actionPerformed_AutoReloadExtMod() {
        this._jcbSilentReload.setEnabled(this._jcbAutoReloadExtMod.isSelected());
    }

    private void load(EnvironOptions environOptions) {
        this._jcbShowSplash.setSelected(environOptions.getShowSplashScreen());
        this._jcbAutoReloadExtMod.setSelected(environOptions.getAutoReloadExtMod());
        this._jcbSilentReload.setSelected(environOptions.getSilentReload());
        this._jcbVerifyVFSData.setSelected(environOptions.getVerifyVFSData());
        this._jcbSaveBeforeCompile.setSelected(environOptions.getSaveBeforeCompile());
        this._jcbClearLogBeforeCompile.setSelected(environOptions.getClearCompilerLogBeforeCompile());
        this._jcbSaveOnDeactivation.setSelected(environOptions.getSaveOnDeactivation());
        this._jcbShowCompileProgress.setSelected(environOptions.getShowCompileProgress());
        this.actionPerformed_AutoReloadExtMod();
        this._jtfUndoLevel.setText(Integer.toString(environOptions.getUndoLevel()));
        this._jtfNavigationLevel.setText(Integer.toString(environOptions.getNavigationLevel()));
        if (IdeUIManager.getUIManager() != null) {
            String string = _lafChanged ? environOptions.getLafClass() : UIManager.getLookAndFeel().getClass().getName();
            String string2 = this._getLafName(string);
            this._cmbLaf.setSelectedItem(string2);
            IdeUIManager.ThemeInfo themeInfo = this._getThemeInfo(string, environOptions.getLafThemeClass());
            this._cmbLafTheme.setSelectedItem(themeInfo);
        }
        this._jcbLineTerminator.setSelectedIndex(environOptions.getLineTerminator());
        Encodings.initComboBox(this._cmbEncoding, false, environOptions.getInternalEncoding());
    }

    private void commit(EnvironOptions environOptions) {
        environOptions.setShowSplashScreen(this._jcbShowSplash.isSelected());
        environOptions.setAutoReloadExtMod(this._jcbAutoReloadExtMod.isSelected());
        this.showOrHideReloadMenu(this._jcbAutoReloadExtMod.isSelected());
        environOptions.setSilentReload(this._jcbSilentReload.isSelected());
        environOptions.setVerifyVFSData(this._jcbVerifyVFSData.isSelected());
        environOptions.setSaveBeforeCompile(this._jcbSaveBeforeCompile.isSelected());
        environOptions.setClearCompilerLogBeforeCompile(this._jcbClearLogBeforeCompile.isSelected());
        environOptions.setSaveOnDeactivation(this._jcbSaveOnDeactivation.isSelected());
        environOptions.setShowCompileProgress(this._jcbShowCompileProgress.isSelected());
        environOptions.setLineTerminator(this._jcbLineTerminator.getSelectedIndex());
        try {
            int n = Integer.parseInt(this._jtfUndoLevel.getText());
            environOptions.setUndoLevel(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            int n = Integer.parseInt(this._jtfNavigationLevel.getText());
            environOptions.setNavigationLevel(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (IdeUIManager.getUIManager() != null) {
            String string;
            IdeUIManager.ThemeInfo themeInfo;
            String string2 = UIManager.getLookAndFeel().getClass().getName();
            String string3 = environOptions.getLafClass();
            String string4 = this._getSelectedLafClass();
            if (_lafChanged || ModelUtil.areDifferent((Object)string4, (Object)string2)) {
                _lafChanged = true;
                environOptions.setLafClass(string4);
                if (ModelUtil.areDifferent((Object)string4, (Object)string3)) {
                    this._askExit = true;
                }
            }
            String string5 = (themeInfo = IdeUIManager.getUIManager().getCurrentTheme(string2)) != null ? themeInfo.getClassName() : "";
            String string6 = environOptions.getLafThemeClass();
            String string7 = string = _selectedTheme != null ? _selectedTheme.getClassName() : "";
            if (ModelUtil.areDifferent((Object)string, (Object)string6)) {
                boolean bl = ModelUtil.areDifferent((Object)string, (Object)string5);
                if (ModelUtil.hasLength((String)string6) || bl) {
                    environOptions.setLafThemeClass(string);
                    if (bl && this._isThemeAvailable(_selectedTheme)) {
                        this._askExit = true;
                    }
                }
            }
        }
        if (Boolean.TRUE.equals(this._cmbEncoding.getClientProperty("encodings-loaded"))) {
            String string = (String)this._cmbEncoding.getSelectedItem();
            if ("Default".equals(string)) {
                string = Encodings.getDefaultEncoding();
            }
            environOptions.setInternalEncoding(string);
        }
    }

    private void showOrHideReloadMenu(boolean bl) {
        JMenu jMenu = MenuManager.getJMenu("File");
        Menubar menubar = Ide.getMenubar();
        Component component = menubar.getChildById(jMenu, 72);
        if (component instanceof JMenuItem) {
            ((JMenuItem)component).setVisible(bl ^ true);
        }
    }

    private void _initLafCombo() {
        this._cmbLaf.removeAllItems();
        int n = this._lafInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String string = this._lafInfo[n2].getClassName();
            try {
                LookAndFeel lookAndFeel = (LookAndFeel)Class.forName(string).newInstance();
                if (lookAndFeel.isSupportedLookAndFeel()) {
                    this._cmbLaf.addItem(this._lafInfo[n2].getName());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private String _getSelectedLafClass() {
        String string = this._cmbLaf.getSelectedItem().toString();
        int n = this._lafInfo.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._lafInfo[n2].getName().equals(string)) {
                return this._lafInfo[n2].getClassName();
            }
            ++n2;
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    private String _getLafName(String string) {
        int n = this._lafInfo.length;
        int n2 = 0;
        while (n2 < n) {
            if (this._lafInfo[n2].getClassName().equals(string)) {
                return this._lafInfo[n2].getName();
            }
            ++n2;
        }
        String string2 = UIManager.getLookAndFeel().getName();
        String string3 = "Mac OS X";
        return string2.startsWith("Mac OS X") ? "Mac OS X" : string2;
    }

    private void actionPerformed_LookAndFeelChanged() {
        this._cmbLafTheme.removeActionListener(this);
        this._initThemeCombo();
        if (this._cmbLafTheme.isEnabled() && !this._isThemeAvailable(_selectedTheme)) {
            String string = this._getSelectedLafClass();
            _selectedTheme = IdeUIManager.getUIManager().getDefaultTheme(string);
            this._cmbLafTheme.setSelectedItem(_selectedTheme);
        }
        this._cmbLafTheme.addActionListener(this);
    }

    private boolean _isThemeAvailable(IdeUIManager.ThemeInfo themeInfo) {
        SortedComboBoxModel sortedComboBoxModel = (SortedComboBoxModel)this._cmbLafTheme.getModel();
        return sortedComboBoxModel.getIndexOf(themeInfo) > 0;
    }

    private void actionPerformed_ThemeChanged() {
        IdeUIManager.ThemeInfo themeInfo = (IdeUIManager.ThemeInfo)this._cmbLafTheme.getSelectedItem();
        if (themeInfo != null) {
            _selectedTheme = themeInfo;
        }
    }

    private void _initThemeCombo() {
        this._cmbLafTheme.removeAllItems();
        String string = this._getSelectedLafClass();
        IdeUIManager.ThemeInfo[] themeInfoArray = IdeUIManager.getUIManager().getInstalledThemes(string);
        if (themeInfoArray != null && themeInfoArray.length > 0) {
            int n = 0;
            while (n < themeInfoArray.length) {
                this._cmbLafTheme.addItem(themeInfoArray[n]);
                ++n;
            }
            this._cmbLafTheme.setEnabled(true);
            this._lblLafTheme.setEnabled(true);
            if (_selectedTheme == null) {
                _selectedTheme = IdeUIManager.getUIManager().getDefaultTheme(string);
            }
            this._cmbLafTheme.setSelectedItem(_selectedTheme);
        } else {
            this._cmbLafTheme.setEnabled(false);
            this._lblLafTheme.setEnabled(false);
        }
    }

    private IdeUIManager.ThemeInfo _getThemeInfo(String string, String string2) {
        int n = this._cmbLafTheme.getItemCount();
        while (n-- > 0) {
            IdeUIManager.ThemeInfo themeInfo = (IdeUIManager.ThemeInfo)this._cmbLafTheme.getItemAt(n);
            if (!ModelUtil.areEqual((Object)string2, (Object)themeInfo.getClassName())) continue;
            return themeInfo;
        }
        return IdeUIManager.getUIManager().getCurrentTheme(string);
    }
}

