/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Pair;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public class GlobalIgnoreList
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "global-ignore-list";
    private List _filterList;
    private static List _filterRegistry = new ArrayList();
    private static PatternFilters _patternFilters;

    void $init$() {
        this._filterList = new ArrayList();
    }

    public GlobalIgnoreList() {
        this.$init$();
    }

    public static void registerExcludeFilter(String string) {
        _filterRegistry.add(string);
    }

    public static PatternFilters getPatternFilters() throws TransientMarker {
        return GlobalIgnoreList._getPatternFiltersImpl();
    }

    public static URLFilter getURLFilter() {
        return new 1();
    }

    public List getList() {
        this._ensureFilterListInitialized();
        return this._filterList;
    }

    public void setList(List list) {
        this._filterList = list;
        _patternFilters = null;
    }

    public Object copyTo(Object object) {
        GlobalIgnoreList globalIgnoreList = object != null ? (GlobalIgnoreList)object : new GlobalIgnoreList();
        this._copyToImpl(globalIgnoreList);
        return globalIgnoreList;
    }

    static List createDefaults() {
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        String string = Ide.isRunning() ? Ide.getProperty("Ide.GlobalIgnoreListFilters", "") : System.getProperty("Ide.GlobalIgnoreListFilters");
        Pattern pattern = Pattern.compile(";");
        String[] stringArray = pattern.split(string);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length() > 0) {
                arrayList.add(new Pair(stringArray[n], true));
            }
            ++n;
        }
        int n2 = _filterRegistry.size();
        String string2 = null;
        int n3 = 0;
        while (n3 < n2) {
            string2 = (String)_filterRegistry.get(n3);
            if (!GlobalIgnoreList._containsFilter(string2, arrayList)) {
                arrayList.add(new Pair(_filterRegistry.get(n3), true));
            }
            ++n3;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _ensureFilterListInitialized() {
        List list = this._filterList;
        synchronized (list) {
            int n = this._filterList.size();
            if (n == 0) {
                List list2 = GlobalIgnoreList.createDefaults();
                this._filterList.addAll(list2);
            }
        }
    }

    private PatternFilters _createPatternFilters() {
        HashStructure hashStructure = HashStructure.newInstance();
        PatternFilters patternFilters = PatternFilters.getInstance(hashStructure);
        patternFilters.addInclude("**");
        int n = this._filterList.size();
        Pair pair = null;
        Boolean bl = null;
        int n2 = 0;
        while (n2 < n) {
            pair = (Pair)this._filterList.get(n2);
            bl = (Boolean)pair.getSecond();
            if (bl.booleanValue()) {
                patternFilters.addExclude((String)pair.getFirst());
            }
            ++n2;
        }
        return patternFilters;
    }

    private static boolean _containsFilter(String string, List list) {
        int n = list.size();
        Pair pair = null;
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            pair = (Pair)list.get(n2);
            string2 = (String)pair.getFirst();
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static synchronized PatternFilters _getPatternFiltersImpl() {
        if (_patternFilters == null) {
            GlobalIgnoreList globalIgnoreList = Ide.isRunning() && Ide.getSettings() != null ? (GlobalIgnoreList)Ide.getSettings().getData(KEY_SETTINGS) : new GlobalIgnoreList();
            globalIgnoreList._ensureFilterListInitialized();
            _patternFilters = globalIgnoreList._createPatternFilters();
        }
        return _patternFilters;
    }

    private final void _copyToImpl(GlobalIgnoreList globalIgnoreList) {
        globalIgnoreList._filterList.clear();
        int n = this._filterList.size();
        Pair pair = null;
        int n2 = 0;
        while (n2 < n) {
            pair = (Pair)this._filterList.get(n2);
            globalIgnoreList._filterList.add(new Pair(pair.getFirst(), pair.getSecond()));
            ++n2;
        }
        _patternFilters = null;
        globalIgnoreList.fireChangeEvent();
    }

    public static final class 1
    implements URLFilter {
        final PatternFilters _filters;

        void $init$() {
            this._filters = GlobalIgnoreList.getPatternFilters();
        }

        public boolean accept(URL uRL) {
            return this._filters.isIncluded(uRL.getPath());
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == this.getClass();
        }

        public 1() {
            this.$init$();
        }
    }
}

