/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Component;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.EnvironOptionsPanel;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.config.GlobalIgnoreListPanel;
import oracle.ide.config.LogOptionsPanel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.dialogs.SizeKeeperCallback;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokesConfigUI;
import oracle.ide.keyboard.XMLKeystrokeContextDefs;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableRegistry;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.resource.EnvironOptionsArb;
import oracle.ide.resource.GlobalIgnoreListArb;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;

public class IdeSettings
implements Copyable {
    public static final String FILENAME = "settings.xml";
    public static final String DATA_KEY = "ide-options";
    public static final String NAMESPACE_URI = XMLUtil.toNamespaceURI("ide-preferences");
    public static final String ROOT_TAG = "ide-settings";
    private static final NavigableRegistry _registry = new NavigableRegistry();
    private HashMap _configData;
    private HashMap _clientSettings;
    private static String[] _oldPath = null;
    private Navigable _environNavigable;
    private transient boolean _askExit;

    void $init$() {
        this._configData = new HashMap();
        this._clientSettings = new HashMap();
    }

    public IdeSettings() {
        this.$init$();
    }

    public IdeSettings(IdeSettings ideSettings) {
        this.$init$();
        if (ideSettings != null) {
            ideSettings.copyToImpl(this);
        }
    }

    private IdeSettings(boolean bl) {
        this.$init$();
        if (bl) {
            this.init();
        }
    }

    public void register() {
        this._environNavigable = new Navigable(EnvironOptionsArb.getString(1), EnvironOptionsPanel.class);
        this._environNavigable.addChildNavigable(new Navigable(EnvironOptionsArb.getString(2), LogOptionsPanel.class));
        IdeSettings.registerUI(this._environNavigable);
        IdeSettings.registerUI(new KeyStrokesConfigUI());
        Navigable navigable = new Navigable(GlobalIgnoreListArb.getString(0), GlobalIgnoreListPanel.class);
        IdeSettings.registerUI(navigable);
    }

    public void init() {
        if (this.getData("environment-options") == null) {
            this.setData("environment-options", new EnvironOptions());
        }
        if (this.getData(KeyStrokeOptions.KEY_SETTINGS) == null) {
            this.setData(KeyStrokeOptions.KEY_SETTINGS, new KeyStrokeOptions());
        }
        if (this.getData("global-ignore-list") == null) {
            this.setData("global-ignore-list", new GlobalIgnoreList());
        }
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ide/config/accelerators.xml");
    }

    public Object copyTo(Object object) {
        IdeSettings ideSettings = object != null ? (IdeSettings)object : new IdeSettings(true);
        this.copyToImpl(ideSettings);
        return ideSettings;
    }

    protected final void copyToImpl(IdeSettings ideSettings) {
        ModelUtil.deepCopy((Map)this._configData, (Map)ideSettings._configData);
        ModelUtil.deepCopy((Map)this._clientSettings, (Map)ideSettings._clientSettings);
    }

    public static void registerUI(Navigable navigable) {
        _registry.registerUI(navigable);
    }

    public static void deregisterUI(Navigable navigable) {
        _registry.deregisterUI(navigable);
    }

    public static Navigable[] getNavigables() {
        return _registry.getNavigables();
    }

    public boolean isAskExit() {
        return this._askExit;
    }

    public void setAskExit(boolean bl) {
        this._askExit = bl;
    }

    public Navigable getEnvironNavigable() {
        return this._environNavigable;
    }

    public boolean hasData(String string) {
        Object v = this._configData.get(string);
        if (v instanceof URL) {
            return URLFileSystem.exists((URL)v);
        }
        return v != null;
    }

    public ClientSetting getClientSetting(String string) throws TransientMarker {
        Object v = this._configData.get(string);
        if (v instanceof URL) {
            ClientSetting clientSetting = this.findClientSetting((URL)v);
            if (clientSetting == null) {
                clientSetting = new ClientSetting((URL)v);
                this._clientSettings.put(clientSetting.getURL(), clientSetting);
            }
            return clientSetting;
        }
        return null;
    }

    public Object getData(String string) throws TransientMarker {
        Object object = this._configData.get(string);
        if (object instanceof URL) {
            ClientSetting clientSetting = this.findClientSetting((URL)object);
            if (clientSetting == null) {
                clientSetting = new ClientSetting((URL)object);
                this._clientSettings.put(clientSetting.getURL(), clientSetting);
            }
            object = clientSetting.getData(string);
        }
        return object;
    }

    public void putData(String string, Copyable copyable) {
        this.setData(string, copyable);
    }

    public KeyStrokeOptions getKeyStrokeOptions() {
        return (KeyStrokeOptions)this.getData(KeyStrokeOptions.KEY_SETTINGS);
    }

    public boolean save() {
        boolean bl = false;
        try {
            URL uRL = IdeSettings.getConfigURL();
            Object2Dom object2Dom = Object2Dom.newInstance();
            object2Dom.setNamespaceURI(NAMESPACE_URI);
            object2Dom.toDocument((Object)this._configData, ROOT_TAG, uRL);
            this.saveClientSettings();
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean load() {
        PerformanceLogger.get().startTiming("IdeSettings.load");
        boolean bl = false;
        Ide.addIdeListener(new 2());
        try {
            URL uRL = IdeSettings.getConfigURL();
            Object2Dom object2Dom = Object2Dom.newInstance();
            this._configData = (HashMap)object2Dom.toObject(uRL);
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PerformanceLogger.get().stopTiming("IdeSettings.load", "IdeSettings.load()");
        return bl;
    }

    public void showDialog(Frame frame) {
        IdeSettings.showDialog(frame, IdeSettings.createMDDPanel(), this, null);
    }

    public void showDialog(Frame frame, String[] stringArray) {
        IdeSettings.showDialog(frame, IdeSettings.createMDDPanel(), this, stringArray);
    }

    public void showDialog(Frame frame, MDDPanel mDDPanel, String[] stringArray) {
        IdeSettings.showDialog(frame, mDDPanel, this, stringArray);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((IdeSettings)object);
    }

    protected final boolean equalsImpl(IdeSettings ideSettings) {
        return ModelUtil.areEqual((Object)this._configData, (Object)ideSettings._configData);
    }

    protected final void addClientSetting(ClientSetting clientSetting) {
        this._clientSettings.put(clientSetting.getURL(), clientSetting);
    }

    void setData(String string, Copyable copyable) {
        if (copyable == null) {
            throw new IllegalArgumentException();
        }
        if (copyable instanceof ClientSetting) {
            ClientSetting clientSetting = (ClientSetting)copyable;
            this._configData.put(string, clientSetting.getURL());
            if (this.findClientSetting(clientSetting.getURL()) == null) {
                this._clientSettings.put(clientSetting.getURL(), clientSetting);
            }
        } else {
            this._configData.put(string, copyable);
        }
    }

    ClientSetting findClientSetting(URL uRL) {
        return (ClientSetting)this._clientSettings.get(uRL);
    }

    private void saveClientSettings() {
        for (ClientSetting clientSetting : this._clientSettings.values()) {
            try {
                clientSetting.save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void addinsLoaded() {
        KeyStrokeOptions keyStrokeOptions = this.getKeyStrokeOptions();
        keyStrokeOptions.solvePostponedMaps();
        XMLKeystrokeContextDefs.getInstance().unload();
    }

    private static URL getConfigURL() {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        URL uRL = extensionRegistry.getSystemDirectory("oracle.ide");
        return URLFactory.newURL(uRL, FILENAME);
    }

    private ClientSetting getClientSetting(URL uRL) {
        ClientSetting clientSetting = this.findClientSetting(uRL);
        if (clientSetting == null) {
            clientSetting = new ClientSetting();
            clientSetting.setURL(uRL);
            this._clientSettings.put(uRL, clientSetting);
        }
        return clientSetting;
    }

    private static Map getAllSettingsMap(IdeSettings ideSettings) {
        HashMap hashMap = ideSettings._configData;
        HashSet hashSet = new HashSet(hashMap.size());
        Iterator iterator = hashMap.entrySet().iterator();
        HashMap hashMap2 = new HashMap(hashMap.size());
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object v = entry.getValue();
            if (v instanceof URL) {
                if (hashSet.contains(v)) continue;
                ClientSetting clientSetting = ideSettings.getClientSetting((URL)v);
                hashMap2.putAll(clientSetting.getClientData());
                hashSet.add(v);
                continue;
            }
            hashMap2.put(entry.getKey(), entry.getValue());
        }
        return hashMap2;
    }

    private static boolean showDialog(Frame frame, MDDPanel mDDPanel, IdeSettings ideSettings, String[] stringArray) {
        String string = EnvironOptionsArb.getString(0);
        mDDPanel.setChildComparator(new Navigable.NavigableComparator(EnvironOptionsArb.getString(1)));
        mDDPanel.setDefaultChildComparator(Navigable.NAVIGABLE_COMPARATOR);
        mDDPanel.setTitleDepth(2);
        IdeSettings ideSettings2 = (IdeSettings)ideSettings.copyTo(null);
        Namespace namespace = new Namespace(IdeSettings.getAllSettingsMap(ideSettings2));
        namespace.put(DATA_KEY, (Object)ideSettings2);
        TDialogLauncher tDialogLauncher = new TDialogLauncher(frame, string, mDDPanel, namespace, new SizeKeeperCallback("panel.idesettings"));
        if (stringArray != null) {
            mDDPanel.setTree1SelectionPath(stringArray);
        } else if (_oldPath == null) {
            mDDPanel.setTree1SelectionRow(0);
        } else {
            mDDPanel.setTree1SelectionPath(_oldPath);
        }
        boolean bl = tDialogLauncher.showDialog();
        _oldPath = mDDPanel.getTree1SelectionPath();
        if (bl) {
            IdeUtil.invokeAfterRepaint(new 1(namespace, ideSettings));
        }
        return bl;
    }

    private static boolean confirmExit() {
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), IdeArb.getString(445), IdeArb.getString(444), null);
    }

    private static boolean confirmRestart() {
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), IdeArb.getString(447), IdeArb.getString(446), null);
    }

    private static MDDPanel createMDDPanel() {
        return new MDDPanel(IdeSettings.getNavigables());
    }

    static void mav$addinsLoaded(IdeSettings ideSettings) {
        ideSettings.addinsLoaded();
    }

    static boolean maS$confirmExit() {
        return IdeSettings.confirmExit();
    }

    static boolean maS$confirmRestart() {
        return IdeSettings.confirmRestart();
    }

    public final class 2
    extends IdeAdapter {
        public void addinsLoaded(IdeEvent ideEvent) {
            IdeSettings.mav$addinsLoaded(IdeSettings.this);
            Ide.removeIdeListener(this);
        }
    }

    public static final class 1
    implements Runnable {
        private final /* synthetic */ Namespace v$data;
        private final /* synthetic */ IdeSettings v$ideSettings;

        public void run() {
            IdeSettings ideSettings = (IdeSettings)this.v$data.get(IdeSettings.DATA_KEY);
            if (ModelUtil.areDifferent((Object)this.v$ideSettings, (Object)ideSettings)) {
                ideSettings.copyTo(this.v$ideSettings);
                this.v$ideSettings.save();
            }
            if (ideSettings.isAskExit()) {
                if (!Ide.canRestart()) {
                    if (IdeSettings.maS$confirmExit()) {
                        Ide.quit();
                    }
                } else if (IdeSettings.maS$confirmRestart()) {
                    try {
                        Ide.restart();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        MessageDialog.error((Component)((Object)Ide.getMainWindow()), IdeArb.getString(449), IdeArb.getString(448), null);
                    }
                }
            }
        }

        public 1(Namespace namespace, IdeSettings ideSettings) {
            this.v$ideSettings = ideSettings;
            this.v$data = namespace;
        }
    }
}

