/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.File;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.IdeUIManager;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.migration.XMLMigrator;
import oracle.ide.net.URLFactory;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ModelUtil;

public final class IdeSettingsMigrator
extends XMLMigrator {
    public static final int IDE_SETTINGS = 0;

    public IdeSettingsMigrator() {
        super(new int[]{0});
    }

    protected Object adjustObject(File file, File file2, Object object) throws Exception {
        if (object instanceof Map) {
            Map map = (Map)object;
            boolean bl = map.containsKey(KeyStrokeOptions.KEY_SETTINGS);
            Object v = bl ? (Object)map.get(KeyStrokeOptions.KEY_SETTINGS) : null;
            boolean bl2 = map.containsKey("environment-options");
            EnvironOptions environOptions = bl2 ? (EnvironOptions)map.get("environment-options") : null;
            map.clear();
            if (bl) {
                map.put(KeyStrokeOptions.KEY_SETTINGS, v);
            }
            if (bl2) {
                IdeSettingsMigrator.adjustEnvironOptions(environOptions);
                map.put("environment-options", environOptions);
            }
        }
        return object;
    }

    public String getDescription(int n) {
        return n == 0 ? IdeArb.getString(186) : null;
    }

    protected String getFileName() {
        return "settings.xml";
    }

    protected String getNamespaceURI() {
        return IdeSettings.NAMESPACE_URI;
    }

    protected String getRootTag() {
        return "ide-settings";
    }

    protected void prepareToMigrate() {
        Class<IdeSettings> clazz = IdeSettings.class;
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/902/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-902-to-903.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/903/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-903-to-904.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/904/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-904-to-905.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/905/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-905-to-9051.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/9051/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-9051-to-10120.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/10120/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-10120-to-10130.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/10130/ide-preferences", this.getRootTag(), URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-10130-to-101303.xsl")));
        Object2Dom.registerTransform("java.util.HashMap", "http://xmlns.oracle.com/jdeveloper/10130/client-preferences", "client-settings", URLFactory.newFileURL(new File(Ide.getHomeDirectory(), "bin/settings-10130-to-101303.xsl")));
    }

    private static void adjustEnvironOptions(EnvironOptions environOptions) {
        environOptions.setLafClass("");
        IdeUIManager ideUIManager = IdeUIManager.getUIManager();
        String string = environOptions.getLafThemeClass();
        if (ModelUtil.hasLength((String)string)) {
            String string2 = environOptions.getLafClass();
            IdeUIManager.ThemeInfo[] themeInfoArray = ideUIManager.getInstalledThemes(string2);
            boolean bl = false;
            int n = 0;
            while (n < themeInfoArray.length) {
                IdeUIManager.ThemeInfo themeInfo = themeInfoArray[n];
                if (ModelUtil.areEqual((Object)string, (Object)themeInfo.getClassName())) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                environOptions.setLafThemeClass("");
            }
        }
    }
}

