/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.config.EnvironOptions;
import oracle.ide.controls.CustomColorChoice;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;

public class LogOptionsPanel
extends DefaultTraversablePanel
implements ActionListener {
    private JCheckBox _jcbSaveLogToFile;
    private URLTextField _jtfLogFilePreffix;
    private JLabel _lblLogFilePreffix;
    private JButton _butLogFilePreffix;
    private JTextField _jtfMaxLogLines;
    private CustomColorChoice _ccLogHrefColor;
    private CustomColorChoice _ccLogSystemOutColor;
    private CustomColorChoice _ccLogSystemErrColor;
    private CustomColorChoice _ccLogSystemInColor;

    public LogOptionsPanel() {
        this.setHelpID("f1_idedidesetlog_html");
        this.initComponents();
    }

    public void onEntry(TraversableContext traversableContext) {
        EnvironOptions environOptions = (EnvironOptions)traversableContext.find("environment-options");
        this.load(environOptions);
    }

    public void onExit(TraversableContext traversableContext) {
        EnvironOptions environOptions = (EnvironOptions)traversableContext.find("environment-options");
        this.commit(environOptions);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._jcbSaveLogToFile) {
            this.actionPerformed_SaveLogToFile();
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setLayout(new GridBagLayout());
        this._jcbSaveLogToFile = new JCheckBox();
        this._jtfLogFilePreffix = new URLTextField(null, true, false);
        this._lblLogFilePreffix = new JLabel();
        this._butLogFilePreffix = new JButton();
        this._butLogFilePreffix.addActionListener(this._jtfLogFilePreffix);
        JLabel jLabel = new JLabel();
        this._jtfMaxLogLines = new WholeNumberField(0, 6);
        JLabel jLabel2 = new JLabel();
        this._ccLogHrefColor = new CustomColorChoice();
        JLabel jLabel3 = new JLabel();
        this._ccLogSystemOutColor = new CustomColorChoice();
        JLabel jLabel4 = new JLabel();
        this._ccLogSystemErrColor = new CustomColorChoice();
        JLabel jLabel5 = new JLabel();
        this._ccLogSystemInColor = new CustomColorChoice();
        ResourceUtils.resLabel(jLabel, this._jtfMaxLogLines, EnvironOptions.getLabelMaxLogLines());
        ResourceUtils.resButton(this._jcbSaveLogToFile, EnvironOptions.getLabelSaveLogToFile());
        ResourceUtils.resLabel(this._lblLogFilePreffix, (Component)((Object)this._jtfLogFilePreffix), EnvironOptions.getLabelLogPreffix());
        ResourceUtils.resButton(this._butLogFilePreffix, EnvironOptions.getLabelBrowse());
        ResourceUtils.resLabel(jLabel2, (Component)((Object)this._ccLogHrefColor), EnvironOptions.getLabelLogHrefColor());
        ResourceUtils.resLabel(jLabel3, (Component)((Object)this._ccLogSystemOutColor), EnvironOptions.getLabelLogSystemOutColor());
        ResourceUtils.resLabel(jLabel4, (Component)((Object)this._ccLogSystemErrColor), EnvironOptions.getLabelLogSystemErrColor());
        ResourceUtils.resLabel(jLabel5, (Component)((Object)this._ccLogSystemInColor), EnvironOptions.getLabelLogSystemInColor());
        this._jcbSaveLogToFile.addActionListener(this);
        this.actionPerformed_SaveLogToFile();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this._jcbSaveLogToFile, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left += 23;
        this.add((Component)this._lblLogFilePreffix, gridBagConstraints);
        gridBagConstraints.insets.left -= 23;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.left += 4;
        gridBagConstraints.fill = 2;
        this.add((Component)((Object)this._jtfLogFilePreffix), gridBagConstraints);
        gridBagConstraints.insets.left -= 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.insets.left += 8;
        this.add((Component)this._butLogFilePreffix, gridBagConstraints);
        gridBagConstraints.insets.left -= 8;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        this.add((Component)this._jtfMaxLogLines, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)((Object)this._ccLogHrefColor), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)((Object)this._ccLogSystemOutColor), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)((Object)this._ccLogSystemErrColor), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.right = 4;
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)((Object)this._ccLogSystemInColor), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(), gridBagConstraints);
    }

    private void actionPerformed_SaveLogToFile() {
        boolean bl = this._jcbSaveLogToFile.isSelected();
        this._jtfLogFilePreffix.setEnabled(bl);
        this._lblLogFilePreffix.setEnabled(bl);
        this._butLogFilePreffix.setEnabled(bl);
    }

    private void load(EnvironOptions environOptions) {
        this._jtfLogFilePreffix.setURL(environOptions.getLogFilePreffix());
        this._jcbSaveLogToFile.setSelected(environOptions.isSaveLogToFile());
        this.actionPerformed_SaveLogToFile();
        this._jtfMaxLogLines.setText(Integer.toString(environOptions.getMaxLogLines()));
        this._ccLogHrefColor.setClosestSelectedColor(new Color(environOptions.getLogHrefColor()));
        this._ccLogSystemOutColor.setClosestSelectedColor(new Color(environOptions.getLogSystemOutColor()));
        this._ccLogSystemErrColor.setClosestSelectedColor(new Color(environOptions.getLogSystemErrColor()));
        this._ccLogSystemInColor.setClosestSelectedColor(new Color(environOptions.getLogSystemInColor()));
    }

    private void commit(EnvironOptions environOptions) {
        environOptions.setLogFilePreffix(URLFileSystem.canonicalize(this._jtfLogFilePreffix.getURL()));
        environOptions.setSaveLogToFile(this._jcbSaveLogToFile.isSelected());
        try {
            int n = Integer.parseInt(this._jtfMaxLogLines.getText());
            environOptions.setMaxLogLines(n);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        environOptions.setLogHrefColor(this._ccLogHrefColor.getSelectedColor().getRGB());
        environOptions.setLogSystemOutColor(this._ccLogSystemOutColor.getSelectedColor().getRGB());
        environOptions.setLogSystemErrColor(this._ccLogSystemErrColor.getSelectedColor().getRGB());
        environOptions.setLogSystemInColor(this._ccLogSystemInColor.getSelectedColor().getRGB());
    }
}

