/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.OrderedProperties;

public final class PlatformProperties
extends OrderedProperties {
    private static final String PATH = "oracle/ide/resource/";
    private static final String SPECS = "psfiles.properties";
    private static PlatformProperties INSTANCE;
    private static boolean _bValid;
    private static URL _forceLoad;
    private static boolean _bTrace;

    private PlatformProperties() {
    }

    public static PlatformProperties getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlatformProperties();
            INSTANCE.load();
        }
        return INSTANCE.isValid() ? INSTANCE : null;
    }

    public static void setForceLoad(String string) {
        if (string != null && (_forceLoad = URLFactory.newURL(string)) == null) {
            _bTrace = true;
        }
    }

    private boolean isValid() {
        return _bValid;
    }

    private boolean load() {
        _bValid = false;
        URL uRL = _forceLoad == null ? this.getPlatformPropertiesURL() : _forceLoad;
        if (uRL != null) {
            try {
                InputStream inputStream = URLFileSystem.openInputStream(uRL);
                this.load(inputStream);
                _bValid = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return _bValid;
    }

    private URL getPlatformPropertiesURL() {
        URL uRL = null;
        try {
            URL uRL2;
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (classLoader != null && (uRL2 = classLoader.getResource("oracle/ide/resource/psfiles.properties")) != null) {
                InputStream inputStream = uRL2.openStream();
                String string = this.getPlatformPropertiesName(inputStream);
                if (_bTrace) {
                    System.err.println("Loading platform settings :oracle/ide/resource/" + string);
                }
                if (string != null) {
                    uRL = classLoader.getResource(PATH + string);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return uRL;
    }

    private String getPlatformPropertiesName(InputStream inputStream) {
        String string = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while (string == null && (string2 = bufferedReader.readLine()) != null) {
                String string3 = IdeUtil.getSubString(string2 = IdeUtil.getSubString(string2, '#', true), ':', true);
                if (string3 == null || (string2 = IdeUtil.getSubString(string2, ':', false)) == null) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                boolean bl = true;
                while (bl && stringTokenizer.hasMoreTokens()) {
                    boolean bl2 = false;
                    String string4 = stringTokenizer.nextToken();
                    String string5 = IdeUtil.getSubString(string4, '=', true);
                    String string6 = IdeUtil.getSubString(string4, '=', false);
                    if (string5 != null && string6 != null) {
                        string5 = IdeUtil.removeChars(string5, " ");
                        string6 = IdeUtil.removeChars(string6, " ");
                        String string7 = System.getProperty(string5);
                        if (string7 != null) {
                            string7 = IdeUtil.removeChars(string7, " ");
                            bl2 = true;
                            if (!string6.equals(string7)) {
                                bl = false;
                            }
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                }
                if (!bl) continue;
                string = string3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

