/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.config;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import oracle.ide.Ide;

public final class SplashScreenOptions {
    private static final String IS_SPLASH_FILE = ".issplash";
    private static final int DEFAULT_STEPS = 153;

    private SplashScreenOptions() {
    }

    public static boolean getShowSplashScreen() {
        return SplashScreenOptions.splashFileExists();
    }

    public static void setShowSplashScreen(boolean bl) {
        if (bl) {
            if (!SplashScreenOptions.splashFileExists()) {
                SplashScreenOptions.createSplashFile(-1);
            }
        } else {
            SplashScreenOptions.deleteSplashFile();
        }
    }

    public static void setSplashScreenCounter(int n) {
        if (SplashScreenOptions.getShowSplashScreen()) {
            SplashScreenOptions.createSplashFile(n);
        }
    }

    public static int getSplashScreenCounter() {
        if (SplashScreenOptions.splashFileExists()) {
            return SplashScreenOptions.readSplashCounter();
        }
        return -1;
    }

    private static File getSplashFile() {
        return new File(Ide.getSystemDirectory(), IS_SPLASH_FILE);
    }

    private static boolean splashFileExists() {
        File file = SplashScreenOptions.getSplashFile();
        if (file.exists()) {
            return true;
        }
        if (SplashScreenOptions.checkSplashFileDirectory()) {
            SplashScreenOptions.createSplashFile(153);
            return true;
        }
        return false;
    }

    private static int readSplashCounter() {
        if (SplashScreenOptions.splashFileExists()) {
            File file = SplashScreenOptions.getSplashFile();
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                int n = dataInputStream.readInt();
                dataInputStream.close();
                if (n > 0) {
                    int n2 = n;
                    return n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean checkSplashFileDirectory() {
        File file = SplashScreenOptions.getSplashFile().getParentFile();
        if (file.exists()) {
            return false;
        }
        return file.mkdirs();
    }

    private static boolean createSplashFile(int n) {
        File file = SplashScreenOptions.getSplashFile();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeInt(n);
            dataOutputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean deleteSplashFile() {
        File file = SplashScreenOptions.getSplashFile();
        return file.delete();
    }
}

