/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.HistoryGeneratingCommand;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.controller.Command;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.Observer;
import oracle.ide.model.TextNode;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.resource.IdeArb;
import oracle.javatools.buffer.TextBuffer;

public final class CommandProcessor
implements Observer {
    private Map _undoStacks;
    private MasterStack _masterStack;
    private int _batchLevel;
    private Thread _batchThread;
    private boolean _aborted;
    private BatchCommand _batchCommand;
    private static final CommandProcessor _INSTANCE = new CommandProcessor();
    private static final int _COMPOUND_COMMAND_ID = Ide.findOrCreateCmdID(CompoundCommand.class.getName());
    private static final int _COMMAND_PART_ID = Ide.findOrCreateCmdID(CommandPart.class.getName());

    void $init$() {
        this._undoStacks = new HashMap();
        this._masterStack = new MasterStack(null);
        this._batchThread = null;
    }

    public static CommandProcessor getInstance() {
        return _INSTANCE;
    }

    private CommandProcessor() {
        this.$init$();
        IdeSettings ideSettings = Ide.getSettings();
        EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
        environOptions.addChangeListener(new 2());
        this.whenUndoStackChanges(environOptions);
    }

    public final int invoke(Command command) throws Exception {
        Context context = command.getContext();
        boolean bl = IdeAction.handlerStarting();
        FeedbackManager feedbackManager = FeedbackManager.getFeedbackManager();
        if (feedbackManager.isOn()) {
            String string = command.getName();
            if (string == null) {
                string = command.getClass().getName();
            }
            feedbackManager.addFeedback("Invoking command: " + string, context);
        }
        try {
            try {
                int n = 1;
                switch (command.getType()) {
                    case 0: {
                        UndoStack undoStack = this.getUndoStack(context);
                        if (undoStack != null) {
                            if (command instanceof HistoryGeneratingCommand) {
                                this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)command));
                            }
                            if (this._batchLevel == 0) {
                                n = this._masterStack.doit(command, undoStack);
                                break;
                            }
                            Node[] nodeArray = command.getAffectedNodes();
                            if (Thread.currentThread() == this._batchThread && (nodeArray == null || nodeArray.length == 0)) {
                                n = this._batchCommand.add(command);
                                break;
                            }
                            if (this._masterStack.isEnabled()) {
                                this._masterStack.setEnabled(false);
                            }
                            n = command.doit();
                            break;
                        }
                    }
                    case 2: {
                        UndoStack undoStack = this.findUndoStack(context);
                        if (command instanceof HistoryGeneratingCommand) {
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)command));
                        }
                        if (this._batchLevel > 0 && this._masterStack.isEnabled()) {
                            this._masterStack.setEnabled(false);
                        }
                        if ((n = command.doit()) != 0) break;
                        if (undoStack != null) {
                            undoStack.flush();
                        }
                        this.flush(command.getAffectedNodes());
                        break;
                    }
                    case 3: {
                        if (this._batchLevel == 0) {
                            command = new CompoundCommand(command);
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)command));
                            n = this._masterStack.doit(command, null);
                            break;
                        }
                        if (command instanceof HistoryGeneratingCommand) {
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)command));
                        }
                        if (Thread.currentThread() == this._batchThread) {
                            n = this._batchCommand.add(command);
                            break;
                        }
                        if (this._masterStack.isEnabled()) {
                            this._masterStack.setEnabled(false);
                        }
                        n = command.doit();
                        break;
                    }
                    case 1: {
                        if (command instanceof HistoryGeneratingCommand) {
                            this.preprocessHistoricalEvent((HistoryGeneratingCommand)((Object)command));
                        }
                        n = command.doit();
                        break;
                    }
                    default: {
                        throw new Exception("Unrecognized Command type");
                    }
                }
                if (n == 0) {
                    if (command instanceof HistoryGeneratingCommand) {
                        this.persistHistoricalEvent((HistoryGeneratingCommand)((Object)command));
                    }
                    NavigationManager navigationManager = NavigationManager.getNavigationManager();
                    Context context2 = command.getContext();
                    if (navigationManager != null) {
                        if (!SwingUtilities.isEventDispatchThread()) {
                            SwingUtilities.invokeLater(new 1(this, navigationManager, context2));
                        } else {
                            navigationManager.setLastEdit(context2);
                        }
                    }
                }
                int n2 = n;
                IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_ACTION_PERFORMED);
                return n2;
            }
            catch (Exception exception) {
                feedbackManager.reportException("Exception while processing command " + command.getName(), exception);
                throw exception;
            }
        }
        catch (Throwable throwable) {
            IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_ACTION_PERFORMED);
            throw throwable;
        }
    }

    public final int undo(Context context) throws Exception {
        if (this._batchLevel != 0) {
            IllegalStateException illegalStateException = new IllegalStateException("Attempting to undo while still in batch mode!");
            illegalStateException.printStackTrace();
            return 1;
        }
        if (context == null) {
            return this._masterStack.undo();
        }
        UndoStack undoStack = this.findUndoStack(context);
        return undoStack != null && this._batchLevel == 0 ? undoStack.undo() : 1;
    }

    public final int redo(Context context) throws Exception {
        if (this._batchLevel != 0) {
            IllegalStateException illegalStateException = new IllegalStateException("Attempting to redo while still in batch mode!");
            illegalStateException.printStackTrace();
            return 1;
        }
        if (context == null) {
            return this._masterStack.redo();
        }
        UndoStack undoStack = this.findUndoStack(context);
        return undoStack != null && this._batchLevel == 0 ? undoStack.redo() : 1;
    }

    public boolean canUndo(Context context) {
        if (this._batchLevel > 0) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canUndo();
        }
        UndoStack undoStack = this.findUndoStack(context);
        return undoStack != null ? undoStack.canUndo(null) : false;
    }

    public String getUndoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getUndoLabel();
        }
        UndoStack undoStack = this.findUndoStack(context);
        return undoStack != null ? undoStack.getUndoLabel() : "";
    }

    public Command getCommand(Context context) {
        try {
            UndoStack undoStack = this.findUndoStack(context);
            Command command = undoStack != null ? undoStack.peek(0) : null;
            return command;
        }
        catch (Exception exception) {
            Command command = null;
            return command;
        }
    }

    public boolean canRedo(Context context) {
        if (this._batchLevel > 0) {
            return false;
        }
        if (context == null) {
            return this._masterStack.canRedo();
        }
        UndoStack undoStack = this.findUndoStack(context);
        return undoStack != null ? undoStack.canRedo(null) : false;
    }

    public String getRedoLabel(Context context) {
        if (context == null) {
            return this._masterStack.getRedoLabel();
        }
        UndoStack undoStack = this.findUndoStack(context);
        return undoStack != null ? undoStack.getRedoLabel() : "";
    }

    public void flush(Object object) {
        UndoStack undoStack = (UndoStack)this._undoStacks.get(object);
        if (undoStack != null) {
            undoStack.flush();
        }
    }

    public void flush(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            this.flush(objectArray[n]);
            ++n;
        }
    }

    public void beginTrans(String string) {
        ++this._batchLevel;
        if (this._batchLevel == 1) {
            this._batchCommand = new BatchCommand(string);
            this._batchThread = Thread.currentThread();
        }
    }

    public void endTrans() {
        --this._batchLevel;
        if (this._batchLevel == 0) {
            this._batchThread = null;
            if (this._masterStack.isEnabled()) {
                try {
                    this._masterStack.doit(this._batchCommand, null);
                    this._batchCommand = null;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this._masterStack.setEnabled(true);
            }
        }
    }

    public void abortTrans() {
        --this._batchLevel;
        if (this._batchLevel == 0) {
            this._batchCommand.abort();
            this._batchCommand = null;
            this._batchThread = null;
            this._aborted = false;
        } else {
            this._aborted = true;
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        UndoStack undoStack;
        if (updateMessage != null && updateMessage.getMessageID() == NodeFactory.NODE_UNCACHED && (undoStack = (UndoStack)this._undoStacks.get(object)) != null) {
            undoStack.release();
            this._undoStacks.remove(object);
        }
    }

    private UndoStack findUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return (UndoStack)this._undoStacks.get(node);
        }
        return null;
    }

    private UndoStack getUndoStack(Context context) {
        if (context != null) {
            Node node = CommandProcessor.getSingleNodeOrNull(context);
            return this.getUndoStack(node);
        }
        return null;
    }

    private UndoStack getUndoStack(Node node) {
        if (node == null) {
            return null;
        }
        UndoStack undoStack = (UndoStack)this._undoStacks.get(node);
        if (undoStack == null) {
            undoStack = new UndoStack(node);
            undoStack.addUndoStackListener(this._masterStack);
            this._undoStacks.put(node, undoStack);
            NodeFactory.attach(this, node.getClass());
        }
        return undoStack;
    }

    private void preprocessHistoricalEvent(HistoryGeneratingCommand historyGeneratingCommand) {
        Node[] nodeArray = historyGeneratingCommand.getHistoriedNodes();
        HistoryManager historyManager = HistoryManager.getHistoryManager();
        if (historyManager != null) {
            URL[] uRLArray = new URL[nodeArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                uRLArray[n] = nodeArray[n].getURL();
                ++n;
            }
            try {
                historyManager.persistInitialState(uRLArray);
                if (historyGeneratingCommand.isGeneratePrecedingState()) {
                    ArrayList<URL> arrayList = new ArrayList<URL>();
                    int n2 = 0;
                    while (n2 < nodeArray.length) {
                        if (nodeArray[n2].isDirty()) {
                            arrayList.add(nodeArray[n2].getURL());
                        }
                        ++n2;
                    }
                    int n3 = arrayList.size();
                    if (n3 > 0) {
                        uRLArray = new URL[n3];
                        arrayList.toArray(uRLArray);
                        historyManager.persist(uRLArray, null);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void persistHistoricalEvent(HistoryGeneratingCommand historyGeneratingCommand) {
        Node[] nodeArray = historyGeneratingCommand.getHistoriedNodes();
        HistoryManager historyManager = HistoryManager.getHistoryManager();
        if (historyManager != null) {
            URL[] uRLArray = new URL[nodeArray.length];
            int n = 0;
            while (n < nodeArray.length) {
                uRLArray[n] = nodeArray[n].getURL();
                ++n;
            }
            try {
                historyManager.persist(uRLArray, historyGeneratingCommand.getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void whenUndoStackChanges(EnvironOptions environOptions) {
        this._masterStack.setStackSize(environOptions.getUndoLevel());
    }

    public static final Command createCommand(String string, Context context) {
        Command command = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                command = (Command)clazz.newInstance();
                command.setContext(context);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return command;
    }

    private static Node getSingleNodeOrNull(Context context) {
        if (!CommandProcessor.areMultipleNodesSelected(context)) {
            return context.getNode();
        }
        return null;
    }

    private static boolean areMultipleNodesSelected(Context context) {
        int n;
        Element[] elementArray = context.getSelection();
        if (elementArray != null && elementArray.length > 1 && (n = elementArray.length) > 1) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                if (elementArray[n3] instanceof Node && ++n2 > 1) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    static void mav$whenUndoStackChanges(CommandProcessor commandProcessor, EnvironOptions environOptions) {
        commandProcessor.whenUndoStackChanges(environOptions);
    }

    static UndoStack mav$getUndoStack(CommandProcessor commandProcessor, Context context) {
        return commandProcessor.getUndoStack(context);
    }

    static UndoStack mav$findUndoStack(CommandProcessor commandProcessor, Context context) {
        return commandProcessor.findUndoStack(context);
    }

    static UndoStack mav$getUndoStack(CommandProcessor commandProcessor, Node node) {
        return commandProcessor.getUndoStack(node);
    }

    static int ra$_COMPOUND_COMMAND_ID() {
        return _COMPOUND_COMMAND_ID;
    }

    static int ra$_COMMAND_PART_ID() {
        return _COMMAND_PART_ID;
    }

    public final class 2
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            CommandProcessor.mav$whenUndoStackChanges(CommandProcessor.this, (EnvironOptions)changeEvent.getSource());
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ NavigationManager v$mgr;
        private final /* synthetic */ Context v$ctx;
        final /* synthetic */ CommandProcessor this$0;

        public void run() {
            this.v$mgr.setLastEdit(this.v$ctx);
        }

        public 1(CommandProcessor commandProcessor, NavigationManager navigationManager, Context context) {
            this.v$ctx = context;
            this.v$mgr = navigationManager;
            this.this$0 = commandProcessor;
        }
    }

    private static final class UndoStack
    extends NodeListener {
        static final int DONE = 0;
        static final int UNDONE = 1;
        private Stack _doneStack;
        private Stack _undoneStack;
        private List _listeners;
        private Node _node;
        private int _timestamp;

        UndoStack(Node node) {
            this._node = node;
            node.addNodeListener(this);
            this._doneStack = new Stack();
            this._undoneStack = new Stack();
            this._listeners = new ArrayList();
        }

        int doit(Command command) throws Exception {
            int n;
            if (!this._undoneStack.isEmpty() || !this._doneStack.isEmpty()) {
                this.checkTimestamp();
            }
            if ((n = this.executeCommand(command)) == 0) {
                this._doneStack.push(command);
                this.trim(1, 0);
            }
            return n;
        }

        boolean canUndo(Command command) {
            if (!this._doneStack.isEmpty()) {
                return command == null || this._doneStack.get(this._doneStack.size() - 1) == command;
            }
            return false;
        }

        String getUndoLabel() {
            Command command = !this._doneStack.isEmpty() ? (Command)this._doneStack.get(this._doneStack.size() - 1) : null;
            return command != null ? command.getName() : null;
        }

        int undo() throws Exception {
            boolean bl = Ide.isQuitting();
            Command command = null;
            int n = 1;
            try {
                try {
                    command = this.peek(0);
                    if (command != null) {
                        bl = bl || IdeAction.handlerStarting();
                        n = command.undo();
                        if (n == 0 && this._undoneStack != null && this._doneStack != null) {
                            this._undoneStack.push(this._doneStack.pop());
                        }
                    }
                    int n2 = n;
                    if (command != null) {
                        IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_UNDO);
                    }
                    return n2;
                }
                catch (ExternalModificationException externalModificationException) {
                    int n3 = n;
                    if (command != null) {
                        IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_UNDO);
                    }
                    return n3;
                }
            }
            catch (Throwable throwable) {
                if (command != null) {
                    IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_UNDO);
                }
                throw throwable;
            }
        }

        boolean canRedo(Command command) {
            if (!this._undoneStack.isEmpty()) {
                return command == null || this._undoneStack.get(this._undoneStack.size() - 1) == command;
            }
            return false;
        }

        String getRedoLabel() {
            Command command = !this._undoneStack.isEmpty() ? (Command)this._undoneStack.get(this._undoneStack.size() - 1) : null;
            return command != null ? command.getName() : null;
        }

        int redo() throws Exception {
            boolean bl = Ide.isQuitting();
            Command command = null;
            int n = 1;
            try {
                try {
                    command = this.peek(1);
                    if (command != null) {
                        bl = bl || IdeAction.handlerStarting();
                        n = this.executeCommand(command);
                        if (n == 0) {
                            this._doneStack.push(this._undoneStack.pop());
                        }
                    }
                    int n2 = n;
                    if (command != null) {
                        IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_UNDO);
                    }
                    return n2;
                }
                catch (ExternalModificationException externalModificationException) {
                    int n3 = n;
                    if (command != null) {
                        IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_UNDO);
                    }
                    return n3;
                }
            }
            catch (Throwable throwable) {
                if (command != null) {
                    IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_UNDO);
                }
                throw throwable;
            }
        }

        int executeCommand(Command command) throws Exception {
            int n = command.doit();
            if (n == 0) {
                CommandProcessor.getInstance().flush(command.getAffectedNodes());
            }
            return n;
        }

        boolean isDone(Command command) {
            if (!this._doneStack.isEmpty()) {
                return this._doneStack.contains(command);
            }
            return false;
        }

        boolean isUndone(Command command) {
            if (!this._undoneStack.isEmpty()) {
                return this._undoneStack.contains(command);
            }
            return false;
        }

        Command peek(int n) throws Exception {
            if (!this._undoneStack.isEmpty() || !this._doneStack.isEmpty()) {
                this.checkTimestamp();
            }
            Stack stack = n == 0 ? this._doneStack : this._undoneStack;
            return !stack.isEmpty() ? (Command)stack.lastElement() : null;
        }

        void flush() {
            this.trim(0, 0);
            this.trim(1, 0);
        }

        void flush(Command command) {
            if (!this._undoneStack.isEmpty() || !this._doneStack.isEmpty()) {
                try {
                    this.checkTimestamp();
                }
                catch (ExternalModificationException externalModificationException) {
                    return;
                }
                catch (Exception exception) {
                    this.flush();
                }
                int n = this._undoneStack.indexOf(command);
                if (n >= 0) {
                    this.trim(1, this._undoneStack.size() - ++n);
                } else {
                    n = this._doneStack.indexOf(command);
                    if (n >= 0) {
                        this.trim(0, this._doneStack.size() - ++n);
                    }
                }
            }
        }

        void trim(int n, int n2) {
            Stack stack;
            Stack stack2 = stack = n == 0 ? this._doneStack : this._undoneStack;
            if (stack != null && stack.size() > n2) {
                List list = stack.subList(0, stack.size() - n2);
                Command[] commandArray = new Command[list.size()];
                list.toArray(commandArray);
                int n3 = 0;
                while (n3 < commandArray.length) {
                    stack.remove(commandArray[n3]);
                    ++n3;
                }
                this.fireCommandsDropped(new UndoStackEvent(this, commandArray));
            }
        }

        void release() {
            this.flush();
            this._doneStack = null;
            this._undoneStack = null;
            this._listeners.clear();
            this._listeners = null;
            this._node = null;
            this._timestamp = -1;
        }

        void addUndoStackListener(UndoStackListener undoStackListener) {
            if (!this._listeners.contains(undoStackListener)) {
                this._listeners.add(undoStackListener);
            }
        }

        void removeUndoStackListener(UndoStackListener undoStackListener) {
            this._listeners.remove(undoStackListener);
        }

        void fireCommandsDropped(UndoStackEvent undoStackEvent) {
            UndoStackListener[] undoStackListenerArray = new UndoStackListener[this._listeners.size()];
            this._listeners.toArray(undoStackListenerArray);
            if (undoStackListenerArray != null) {
                int n = 0;
                while (n < undoStackListenerArray.length) {
                    undoStackListenerArray[n].commandsDropped(undoStackEvent);
                    ++n;
                }
            }
        }

        public void nodeOpened(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            if (node instanceof TextNode) {
                int n;
                TextBuffer textBuffer = ((TextNode)node).acquireTextBuffer();
                int n2 = n = textBuffer != null ? textBuffer.getChangeId() : -1;
                if (this._timestamp != n) {
                    this._timestamp = n;
                    this.flush();
                }
            }
        }

        public void nodeClosing(NodeEvent nodeEvent) {
            Node node = nodeEvent.getNode();
            if (node instanceof TextNode) {
                TextBuffer textBuffer = ((TextNode)node).acquireTextBuffer();
                this._timestamp = textBuffer != null ? textBuffer.getChangeId() : -1;
            } else {
                this.flush();
            }
        }

        void checkTimestamp() throws Exception {
            if (this._node instanceof TextNode && !this._node.isOpen() && (this._doneStack.size() > 0 || this._undoneStack.size() > 0)) {
                int n = this._timestamp;
                this._node.ensureOpen();
                if (n != this._timestamp) {
                    throw new ExternalModificationException();
                }
            }
        }

        static Stack ra$_undoneStack(UndoStack undoStack) {
            return undoStack._undoneStack;
        }

        static Stack ra$_doneStack(UndoStack undoStack) {
            return undoStack._doneStack;
        }
    }

    private static interface UndoStackListener {
        public void commandsDropped(UndoStackEvent var1);
    }

    private static final class UndoStackEvent
    extends EventObject {
        private Command[] _commands;

        public UndoStackEvent(Object object, Command[] commandArray) {
            super(object);
            this._commands = commandArray;
        }

        public Command[] getCommands() {
            return this._commands;
        }
    }

    private static final class MasterStack
    implements UndoStackListener {
        private int _maxSize;
        private boolean _enabled;
        private ArrayList _commandStackPairs;

        void $init$() {
            this._enabled = true;
            this._commandStackPairs = new ArrayList();
        }

        int doit(Command command, UndoStack undoStack) throws Exception {
            int n;
            int n2 = n = undoStack != null ? undoStack.doit(command) : command.doit();
            if (n == 0) {
                this._commandStackPairs.add(command);
                this._commandStackPairs.add(undoStack);
                this.trim();
            }
            return n;
        }

        boolean canUndo() {
            int n = this._commandStackPairs.size() - 2;
            while (n >= 0) {
                Command command = (Command)this._commandStackPairs.get(n);
                if (command.isGlobal()) {
                    UndoStack undoStack = (UndoStack)this._commandStackPairs.get(n + 1);
                    if (undoStack == null) {
                        if (((CompoundCommand)command).isDone()) {
                            return true;
                        }
                    } else if (undoStack.isDone(command)) {
                        return undoStack.canUndo(command);
                    }
                }
                n -= 2;
            }
            return false;
        }

        String getUndoLabel() {
            int n = this._commandStackPairs.size() - 2;
            while (n >= 0) {
                Command command = (Command)this._commandStackPairs.get(n);
                if (command.isGlobal()) {
                    UndoStack undoStack = (UndoStack)this._commandStackPairs.get(n + 1);
                    if (undoStack == null) {
                        if (((CompoundCommand)command).isDone()) {
                            return command.getName();
                        }
                    } else if (undoStack.isDone(command)) {
                        return undoStack.canUndo(command) ? command.getName() : "";
                    }
                }
                n -= 2;
            }
            return "";
        }

        int undo() throws Exception {
            int n = this._commandStackPairs.size() - 2;
            while (n >= 0) {
                Command command = (Command)this._commandStackPairs.get(n);
                if (command.isGlobal()) {
                    UndoStack undoStack = (UndoStack)this._commandStackPairs.get(n + 1);
                    if (undoStack == null) {
                        if (((CompoundCommand)command).isDone()) {
                            return command.undo();
                        }
                    } else if (undoStack.isDone(command)) {
                        boolean bl = Ide.getIdeArgs().getCreateUI() ^ true;
                        if (!bl) {
                            bl = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), IdeArb.format(455, new String[]{command.getName()}), IdeArb.getString(82), null);
                        }
                        if (bl) {
                            return undoStack.canUndo(command) ? undoStack.undo() : 1;
                        }
                        return 1;
                    }
                }
                n -= 2;
            }
            return 1;
        }

        boolean canRedo() {
            int n = this._commandStackPairs.size() - 2;
            while (n >= 0) {
                Command command = (Command)this._commandStackPairs.get(n);
                if (command.isGlobal()) {
                    UndoStack undoStack = (UndoStack)this._commandStackPairs.get(n + 1);
                    if (undoStack == null) {
                        if (!((CompoundCommand)command).isDone()) {
                            return true;
                        }
                    } else if (undoStack.isUndone(command)) {
                        return undoStack.canRedo(command);
                    }
                }
                n -= 2;
            }
            return false;
        }

        String getRedoLabel() {
            int n = this._commandStackPairs.size() - 2;
            while (n >= 0) {
                Command command = (Command)this._commandStackPairs.get(n);
                if (command.isGlobal()) {
                    UndoStack undoStack = (UndoStack)this._commandStackPairs.get(n + 1);
                    if (undoStack == null) {
                        if (!((CompoundCommand)command).isDone()) {
                            return command.getName();
                        }
                    } else if (undoStack.isUndone(command)) {
                        return undoStack.canRedo(command) ? command.getName() : "";
                    }
                }
                n -= 2;
            }
            return "";
        }

        int redo() throws Exception {
            int n = this._commandStackPairs.size() - 2;
            while (n >= 0) {
                Command command = (Command)this._commandStackPairs.get(n);
                if (command.isGlobal()) {
                    UndoStack undoStack = (UndoStack)this._commandStackPairs.get(n + 1);
                    if (undoStack == null) {
                        if (!((CompoundCommand)command).isDone()) {
                            return command.doit();
                        }
                    } else if (undoStack.isUndone(command)) {
                        boolean bl = Ide.getIdeArgs().getCreateUI() ^ true;
                        if (!bl) {
                            bl = MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), IdeArb.format(456, new String[]{command.getName()}), IdeArb.getString(85), null);
                        }
                        if (bl) {
                            return undoStack.canRedo(command) ? undoStack.redo() : 1;
                        }
                        return 1;
                    }
                }
                n -= 2;
            }
            return 1;
        }

        int getStackSize() {
            return this._maxSize;
        }

        void setStackSize(int n) {
            if (!this.isEnabled()) {
                return;
            }
            if (n >= 0) {
                this._maxSize = n;
                this.trim();
                IdeAction ideAction = IdeAction.find(5);
                if (ideAction != null) {
                    Ide.getIdeController().update(ideAction, null);
                }
                if ((ideAction = IdeAction.find(6)) != null) {
                    Ide.getIdeController().update(ideAction, null);
                }
            }
        }

        void setEnabled(boolean bl) {
            if (bl != this._enabled) {
                if (bl) {
                    IdeSettings ideSettings = Ide.getSettings();
                    EnvironOptions environOptions = (EnvironOptions)ideSettings.getData("environment-options");
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new 2());
                    } else {
                        this.showEnabledDialog(true);
                    }
                    this._enabled = bl;
                    this.setStackSize(environOptions.getUndoLevel());
                } else {
                    IllegalStateException illegalStateException = new IllegalStateException("Cannot invoke Command from other thread, or with non undoable side effects, while in batch mode\nDisabling Undo support until batch completed.");
                    illegalStateException.printStackTrace();
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(new 1());
                    } else {
                        this.showEnabledDialog(false);
                    }
                    this.setStackSize(0);
                    this._enabled = bl;
                }
            }
        }

        boolean isEnabled() {
            return this._enabled;
        }

        void showEnabledDialog(boolean bl) {
            MessageDialog.information((Component)((Object)Ide.getMainWindow()), bl ? IdeArb.getString(458) : IdeArb.getString(457), IdeArb.format(82, ""), null);
        }

        void trim() {
            int n = this._commandStackPairs.size();
            while (n / 2 > this._maxSize) {
                Command command = (Command)this._commandStackPairs.get(0);
                UndoStack undoStack = (UndoStack)this._commandStackPairs.get(1);
                if (undoStack == null) {
                    CompoundCommand compoundCommand = (CompoundCommand)command;
                    boolean bl = compoundCommand.isDone();
                    List list = compoundCommand.getParts();
                    Iterator iterator = list.iterator();
                    while (undoStack == null && iterator.hasNext()) {
                        CommandPart commandPart = (CommandPart)iterator.next();
                        if (commandPart.isDeletion()) {
                            if (bl || (undoStack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), commandPart.getContext())) == null) continue;
                            command = commandPart;
                            continue;
                        }
                        if (commandPart.isAddition()) {
                            if (!bl || (undoStack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), commandPart.getContext())) == null) continue;
                            command = commandPart;
                            continue;
                        }
                        undoStack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), commandPart.getContext());
                        if (undoStack == null) continue;
                        command = commandPart;
                    }
                }
                if (undoStack != null) {
                    undoStack.flush(command);
                } else {
                    this.commandsDropped(new UndoStackEvent(this, new Command[]{command}));
                }
                n = this._commandStackPairs.size();
            }
        }

        public void commandsDropped(UndoStackEvent undoStackEvent) {
            Command[] commandArray;
            Command[] commandArray2 = commandArray = undoStackEvent != null ? undoStackEvent.getCommands() : null;
            if (commandArray != null) {
                int n = 0;
                while (n < commandArray.length) {
                    Command command = commandArray[n];
                    int n2 = this._commandStackPairs.indexOf(command);
                    if (n2 < 0 && command instanceof CommandPart) {
                        command = CommandPart.ra$_owner((CommandPart)command);
                        n2 = this._commandStackPairs.indexOf(command);
                    }
                    if (n2 >= 0) {
                        this._commandStackPairs.remove(n2);
                        this._commandStackPairs.remove(n2);
                    }
                    ++n;
                }
            }
        }

        private MasterStack() {
            this.$init$();
        }

        MasterStack(1 var1_1) {
            this();
        }

        public final class 2
        implements Runnable {
            public void run() {
                MasterStack.this.showEnabledDialog(true);
            }
        }

        public final class 1
        implements Runnable {
            public void run() {
                MasterStack.this.showEnabledDialog(false);
            }
        }
    }

    private static class CompoundCommand
    extends Command
    implements UndoStackListener,
    HistoryGeneratingCommand {
        private List _historied;
        private boolean _working;
        private boolean _adjusted;
        protected boolean _firstTime;
        protected boolean _done;
        protected List _parts;
        protected Command[] _commands;

        void $init$() {
            this._firstTime = true;
        }

        CompoundCommand(Command command) {
            super(CommandProcessor.ra$_COMPOUND_COMMAND_ID(), 1, command.getName());
            this.$init$();
            this.setContext(command.getContext());
            this._commands = new Command[]{command};
        }

        protected CompoundCommand(String string) {
            super(CommandProcessor.ra$_COMPOUND_COMMAND_ID(), 1, string);
            this.$init$();
            this._commands = new Command[0];
        }

        boolean isWorking() {
            return this._working;
        }

        boolean isDone() {
            return this._done;
        }

        public boolean isGlobal() {
            return this.getParts().size() > 1;
        }

        public int doit() throws Exception {
            return this.doit(null);
        }

        int doit(CommandPart commandPart) throws Exception {
            if (!this.canDo()) {
                CompoundCommand.showErrorMessage(false);
                return 1;
            }
            boolean bl = this._firstTime ^ true;
            if (bl && Ide.getIdeArgs().getCreateUI() && this.isGlobal() && !oracle.javatools.dialogs.MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.redoConfirmation", (Component)((Object)Ide.getMainWindow()), (String)IdeArb.format(456, new String[]{this.getName()}), (String)IdeArb.format(85, new String[]{""}), null)) {
                return 1;
            }
            int n = this.doCommands();
            if (n == 0) {
                try {
                    this._working = true;
                    this.adjustParts();
                    CommandProcessor commandProcessor = CommandProcessor.getInstance();
                    List list = this.getParts();
                    CommandPart[] commandPartArray = new CommandPart[list.size()];
                    list.toArray(commandPartArray);
                    int n2 = 0;
                    while (n2 < commandPartArray.length) {
                        CommandPart commandPart2 = commandPartArray[n2];
                        if (commandPart2 != commandPart && !commandPart2.isDeletion()) {
                            try {
                                Context context = commandPart2.getContext();
                                UndoStack undoStack = CommandProcessor.mav$getUndoStack(commandProcessor, context);
                                if (bl) {
                                    if (commandPart2.isAddition()) {
                                        undoStack.flush();
                                        UndoStack.ra$_doneStack(undoStack).add(commandPart2);
                                    } else {
                                        undoStack.redo();
                                    }
                                } else {
                                    undoStack.doit(commandPart2);
                                }
                            }
                            catch (Exception exception) {
                                n = 1;
                            }
                        }
                        ++n2;
                    }
                }
                finally {
                    this._working = false;
                }
            }
            return n;
        }

        protected boolean canDo() {
            List list = this.getParts();
            CommandPart[] commandPartArray = new CommandPart[list.size()];
            list.toArray(commandPartArray);
            int n = 0;
            while (n < commandPartArray.length) {
                CommandPart commandPart = commandPartArray[n];
                if (!CompoundCommand.canDo(commandPart)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private static boolean canDo(CommandPart commandPart) {
            if (commandPart != null && commandPart.isAddition()) {
                return true;
            }
            UndoStack undoStack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), commandPart.getContext());
            if (undoStack != null) {
                if (undoStack.isUndone(commandPart)) {
                    try {
                        undoStack.checkTimestamp();
                    }
                    catch (Exception exception) {
                        boolean bl = false;
                        return bl;
                    }
                    return undoStack.canRedo(commandPart);
                }
                return undoStack.isDone(commandPart) ^ true;
            }
            return false;
        }

        public int undo() throws Exception {
            return this.undo(null);
        }

        int undo(CommandPart commandPart) throws Exception {
            List list = this.getParts();
            CommandPart[] commandPartArray = new CommandPart[list.size()];
            list.toArray(commandPartArray);
            int n = 0;
            while (n < commandPartArray.length) {
                CommandPart commandPart2 = commandPartArray[n];
                if (!CompoundCommand.canUndo(commandPart2)) {
                    CompoundCommand.showErrorMessage(true);
                    return 1;
                }
                ++n;
            }
            if (Ide.getIdeArgs().getCreateUI() && this.isGlobal() && !oracle.javatools.dialogs.MessageDialog.optionalConfirm((String)"oracle.ide.controller.CommandProcessor.undoConfirmation", (Component)((Object)Ide.getMainWindow()), (String)IdeArb.format(455, new String[]{this.getName()}), (String)IdeArb.format(82, new String[]{""}), null)) {
                return 1;
            }
            int n2 = this.undoCommands();
            if (n2 == 0) {
                try {
                    this._working = true;
                    list = this.getParts();
                    commandPartArray = new CommandPart[list.size()];
                    list.toArray(commandPartArray);
                    CommandProcessor commandProcessor = CommandProcessor.getInstance();
                    int n3 = 0;
                    while (n3 < commandPartArray.length) {
                        CommandPart commandPart3 = commandPartArray[n3];
                        if (commandPart3 != commandPart && !commandPart3.isAddition()) {
                            try {
                                UndoStack undoStack = CommandProcessor.mav$getUndoStack(commandProcessor, commandPart3.getContext());
                                if (commandPart3.isDeletion()) {
                                    undoStack.flush();
                                    UndoStack.ra$_undoneStack(undoStack).add(commandPart3);
                                } else {
                                    undoStack.undo();
                                }
                            }
                            catch (Exception exception) {
                                n2 = 1;
                            }
                        }
                        ++n3;
                    }
                }
                finally {
                    this._working = false;
                }
            }
            return n2;
        }

        private static boolean canUndo(CommandPart commandPart) {
            if (commandPart != null && commandPart.isDeletion()) {
                return true;
            }
            UndoStack undoStack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), commandPart.getContext());
            if (undoStack != null) {
                try {
                    undoStack.checkTimestamp();
                }
                catch (Exception exception) {
                    boolean bl = false;
                    return bl;
                }
            }
            return undoStack != null && undoStack.canUndo(commandPart);
        }

        /*
         * Unable to fully structure code
         */
        protected int doCommands() throws Exception {
            var1_1 = 0;
            while (var1_1 < this._commands.length) {
                block10: {
                    try {
                        if (this._commands[var1_1].doit() != 0) {
                            while (--var1_1 >= 0) {
                                try {
                                    this._commands[var1_1].undo();
                                }
                                catch (Exception var2_2) {
                                    // empty catch block
                                }
                            }
                            var5_3 = 1;
                            return var5_3;
                        }
                        break block10;
                    }
                    catch (Exception var3_4) {
                        ** while (--var1_1 >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this._commands[var1_1].undo();
                        }
                        catch (Exception var4_5) {
                            // empty catch block
                        }
                        continue;
                    }
lbl25:
                    // 1 sources

                    throw var3_4;
                }
                ++var1_1;
            }
            this._firstTime = false;
            this._done = true;
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        protected int undoCommands() throws Exception {
            var1_1 = this._commands.length - 1;
            while (var1_1 >= 0) {
                block10: {
                    try {
                        if (this._commands[var1_1].undo() != 0) {
                            while (++var1_1 < this._commands.length) {
                                try {
                                    this._commands[var1_1].doit();
                                }
                                catch (Exception var2_2) {
                                    // empty catch block
                                }
                            }
                            var5_3 = 1;
                            return var5_3;
                        }
                        break block10;
                    }
                    catch (Exception var3_4) {
                        ** while (++var1_1 < this._commands.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this._commands[var1_1].doit();
                        }
                        catch (Exception var4_5) {
                            // empty catch block
                        }
                        continue;
                    }
lbl25:
                    // 1 sources

                    throw var3_4;
                }
                --var1_1;
            }
            this._done = false;
            return 0;
        }

        public Node[] getHistoriedNodes() {
            if (this._historied == null) {
                this._historied = new ArrayList();
                int n = 0;
                while (n < this._commands.length) {
                    Context context = this._commands[n].getContext();
                    Node node = context.getNode();
                    Node[] nodeArray = this._commands[n].getAffectedNodes();
                    if (node != null && !this._historied.contains(node)) {
                        this._historied.add(node);
                    }
                    if (nodeArray != null) {
                        int n2 = 0;
                        while (n2 < nodeArray.length) {
                            if (nodeArray[n2] != null && !this._historied.contains(nodeArray[n2])) {
                                this._historied.add(nodeArray[n2]);
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            Node[] nodeArray = new Node[this._historied.size()];
            this._historied.toArray(nodeArray);
            return nodeArray;
        }

        public boolean isGeneratePrecedingState() {
            return true;
        }

        protected List getParts() {
            if (this._parts == null) {
                this._parts = new ArrayList();
                int n = 0;
                while (n < this._commands.length) {
                    Node[] nodeArray = this._commands[n].getAffectedNodes();
                    Context context = this._commands[n].getContext();
                    context = new Context(context);
                    this.addPart(context);
                    if (nodeArray != null) {
                        int n2 = 0;
                        while (n2 < nodeArray.length) {
                            context = new Context(context);
                            context.setNode(nodeArray[n2]);
                            this.addPart(context);
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            return this._parts;
        }

        protected CommandPart addPart(Context context) {
            Node node = context != null ? context.getNode() : null;
            CommandPart commandPart = this.getPart(node);
            if (commandPart == null && (commandPart = this.createPart(context)) != null) {
                this._parts.add(commandPart);
            }
            return commandPart;
        }

        protected CommandPart getPart(Node node) {
            Iterator iterator;
            Iterator iterator2 = iterator = this._parts != null ? this._parts.iterator() : null;
            if (iterator != null) {
                while (iterator.hasNext()) {
                    CommandPart commandPart = (CommandPart)iterator.next();
                    Context context = commandPart.getContext();
                    Node node2 = context.getNode();
                    if (node != node2) continue;
                    return commandPart;
                }
            }
            return null;
        }

        protected CommandPart createPart(Context context) {
            Node node = context != null ? context.getNode() : null;
            UndoStack undoStack = CommandProcessor.mav$getUndoStack(CommandProcessor.getInstance(), node);
            if (undoStack == null) {
                return null;
            }
            CommandPart commandPart = new CommandPart(this);
            context.setNode(node);
            context.setSelection(null);
            commandPart.setContext(context);
            undoStack.addUndoStackListener(this);
            return commandPart;
        }

        protected void adjustParts() {
            if (this._adjusted) {
                return;
            }
            this._adjusted = true;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            int n = 0;
            while (n < this._commands.length) {
                Context context = this._commands[n].getContext();
                Node[] nodeArray = this._commands[n].getAffectedNodes();
                Node node = context.getNode();
                if (node != null && !arrayList.contains(node)) {
                    arrayList.add(node);
                }
                if (nodeArray != null) {
                    int n2 = 0;
                    while (n2 < nodeArray.length) {
                        if (nodeArray[n2] != null && !arrayList.contains(nodeArray[n2])) {
                            arrayList.add(nodeArray[n2]);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            List list = this.getParts();
            for (CommandPart commandPart : list) {
                Context context = commandPart.getContext();
                Node node = context.getNode();
                if (!arrayList.contains(node)) {
                    commandPart.setDeletion(true);
                    continue;
                }
                arrayList.remove(node);
            }
            int n3 = arrayList.size() - 1;
            while (n3 >= 0) {
                CommandPart commandPart = this.addPart(new Context((Node)arrayList.get(n3)));
                commandPart.setAddition(true);
                --n3;
            }
            arrayList.clear();
        }

        public void commandsDropped(UndoStackEvent undoStackEvent) {
            Command[] commandArray = undoStackEvent.getCommands();
            int n = 0;
            while (n < commandArray.length) {
                Command command = commandArray[n];
                if (this.getParts().contains(command)) {
                    UndoStack undoStack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), command.getContext());
                    this.getParts().remove(command);
                    if (undoStack != null) {
                        undoStack.removeUndoStackListener(this);
                    }
                    while (this.getParts().size() > 0) {
                        Command command2 = (Command)this.getParts().get(0);
                        Context context = command2 != null ? command2.getContext() : null;
                        undoStack = CommandProcessor.mav$findUndoStack(CommandProcessor.getInstance(), context);
                        this.getParts().remove(command2);
                        if (undoStack == null) continue;
                        undoStack.removeUndoStackListener(this);
                        undoStack.flush(command2);
                    }
                    break;
                }
                ++n;
            }
        }

        private static void showErrorMessage(boolean bl) {
            String string;
            String string2 = string = bl ? IdeArb.getString(424) : IdeArb.getString(425);
            if (Ide.getIdeArgs().getCreateUI()) {
                MessageDialog.error((Component)((Object)Ide.getMainWindow()), string, IdeArb.getString(235), null);
            } else {
                System.err.println(string);
            }
        }
    }

    private static final class BatchCommand
    extends CompoundCommand {
        BatchCommand(String string) {
            super(string);
            Context context = Context.newIdeContext();
            context.setView(null);
            context.setNode(null);
            context.setSelection(null);
            this.setContext(context);
            this._parts = new ArrayList();
        }

        protected boolean canDo() {
            return this._firstTime ? true : super.canDo();
        }

        protected int doCommands() throws Exception {
            if (this._firstTime) {
                this._firstTime = false;
                this._done = true;
                return 0;
            }
            return super.doCommands();
        }

        int add(Command command) throws Exception {
            int n;
            Context context = new Context(command.getContext());
            Node[] nodeArray = command.getAffectedNodes();
            this.addPart(context);
            if (nodeArray != null) {
                int n2 = 0;
                while (n2 < nodeArray.length) {
                    context = new Context(context);
                    context.setNode(nodeArray[n2]);
                    this.addPart(context);
                    ++n2;
                }
            }
            if ((n = command.doit()) == 0) {
                Command[] commandArray = new Command[this._commands.length + 1];
                System.arraycopy(this._commands, 0, commandArray, 0, this._commands.length);
                commandArray[commandArray.length - 1] = command;
                this._commands = commandArray;
            }
            return n;
        }

        void abort() {
            if (this._commands != null) {
                int n = this._commands.length - 1;
                while (n >= 0) {
                    try {
                        this._commands[n].undo();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --n;
                }
                this._commands = null;
            }
        }
    }

    private static final class CommandPart
    extends Command {
        private CompoundCommand _owner;
        private boolean _isAddition;
        private boolean _isDeletion;
        private URL _url;

        CommandPart(CompoundCommand compoundCommand) {
            super(CommandProcessor.ra$_COMMAND_PART_ID(), 0, compoundCommand.getName());
            this._owner = compoundCommand;
        }

        public int doit() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.doit(this);
        }

        public int undo() throws Exception {
            return this._owner.isWorking() ? 0 : this._owner.undo(this);
        }

        public Context getContext() {
            if (this._url != null) {
                Context context = new Context(this.context);
                try {
                    context.setNode(NodeFactory.findOrCreate(this._url));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return context;
            }
            return super.getContext();
        }

        void setAddition(boolean bl) {
            this._isAddition = bl;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        boolean isAddition() {
            return this._isAddition;
        }

        void setDeletion(boolean bl) {
            this._isDeletion = bl;
            this._url = this.context.getNode().getURL();
            this.context.setNode(null);
        }

        boolean isDeletion() {
            return this._isDeletion;
        }

        static CompoundCommand ra$_owner(CommandPart commandPart) {
            return commandPart._owner;
        }
    }

    private static final class ExternalModificationException
    extends RuntimeException {
    }
}

