/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Context;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.model.Element;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.MnemonicSolver;

public final class ContextMenu
extends MenuManager {
    private static final String CONTEXTMENU_CONTEXT = "ContextMenuContext";
    private final ArrayList listeners;
    private Context currentContext;
    private JPopupMenu popup;
    private MnemonicSolver _mnemonicSolver;

    void $init$() {
        this.listeners = new ArrayList(10);
    }

    public ContextMenu() {
        this.$init$();
    }

    public ContextMenu(MnemonicSolver mnemonicSolver) {
        this.$init$();
        this._mnemonicSolver = mnemonicSolver;
    }

    public void add(Component component) {
        this.add(component, Float.MAX_VALUE);
    }

    public void add(Component component, float f) {
        this.add(component, f, false);
    }

    public void add(Component component, float f, boolean bl) {
        super.add(component, f);
        this.addToSolver(component, bl);
    }

    public void addContextMenuListener(ContextMenuListener contextMenuListener) {
        this.addContextMenuListener(contextMenuListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextMenuListener(ContextMenuListener contextMenuListener, Class clazz) {
        if (contextMenuListener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                this.listeners.add(contextMenuListener);
                this.listeners.add(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextMenuListener(ContextMenuListener contextMenuListener) {
        if (contextMenuListener != null) {
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int n = this.listeners.indexOf(contextMenuListener);
                if (n < 0) {
                    return;
                }
                this.listeners.remove(n + 1);
                this.listeners.remove(n);
            }
        }
    }

    public synchronized Container getGUI(boolean bl) {
        if (this.popup == null && bl) {
            this.popup = new JPopupMenu();
            this.popup.putClientProperty("menu-addin-section-id", new Float(MenuConstants.SECTION_ADDITIONAL_CTXT_MENU));
            this.popup.addContainerListener(this._containerListener);
            this.popup.addPopupMenuListener(new 1());
        }
        return this.popup;
    }

    public int getMenuCount() {
        return this.getGUI(true).getComponentCount();
    }

    public void removeAll() {
        if (this.popup != null) {
            this.popup.removeAll();
        }
    }

    public final void show(Context context) {
        EventObject eventObject = context.getEvent();
        MouseEvent mouseEvent = (MouseEvent)eventObject;
        this.currentContext = new Context(context);
        this.getGUI(true);
        this.popup.removeAll();
        this.callMenuWillShow();
        if (this.popup.getComponentCount() == 0) {
            return;
        }
        MenuManager.updatePopupMenuItems(this.popup, this.currentContext);
        this.popup.putClientProperty(CONTEXTMENU_CONTEXT, this.currentContext);
        Component component = (Component)mouseEvent.getSource();
        Point point = GraphicsUtils.getPopupMenuShowPoint(this.popup, mouseEvent);
        this.popup.show(component, point.x, point.y);
    }

    public final Context getContext() {
        return this.currentContext;
    }

    static final Context getContext(JMenuItem jMenuItem, EventObject eventObject) {
        Context context = null;
        Container container = jMenuItem;
        while (container != null) {
            if (container instanceof JPopupMenu || container instanceof JMenuBar) {
                JComponent jComponent = container;
                context = (Context)jComponent.getClientProperty(CONTEXTMENU_CONTEXT);
                if (context == null) break;
                context.setEvent(eventObject);
                break;
            }
            container = container.getParent();
        }
        return context;
    }

    static final void clearContext(JMenuItem jMenuItem) {
        Container container = jMenuItem;
        while (container != null) {
            if (container instanceof JPopupMenu || container instanceof JMenuBar) {
                JComponent jComponent = container;
                jComponent.putClientProperty(CONTEXTMENU_CONTEXT, null);
                break;
            }
            container = container.getParent();
        }
    }

    public void addSeparator() {
        int n = this.popup.getComponentCount();
        if (n > 0 && this.popup.getComponent(n - 1) instanceof JPopupMenu.Separator) {
            return;
        }
        this.popup.add(new JPopupMenu.Separator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fireDefaultAction(Context context) {
        Element element = null;
        Class<?> clazz = null;
        try {
            element = context.getElement();
            clazz = element.getData().getClass();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = new ArrayList(this.listeners);
            int n = arrayList2.size() - 2;
            while (n >= 0) {
                ContextMenuListener contextMenuListener = (ContextMenuListener)arrayList2.get(n);
                Class clazz2 = (Class)arrayList2.get(n + 1);
                if ((clazz2 == null || context != null && element != null && clazz2 == clazz) && contextMenuListener.handleDefaultAction(context)) {
                    IdeMainWindow.updateVisibleActions(Controller.UPDATE_FROM_ACTION_PERFORMED);
                    boolean bl = true;
                    return bl;
                }
                n -= 2;
            }
        }
        return false;
    }

    public MnemonicSolver getMnemonicSolver() {
        return this._mnemonicSolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callMenuWillShow() {
        Class<?> clazz = null;
        try {
            clazz = this.currentContext.getElement().getData().getClass();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (this._mnemonicSolver != null) {
                this._mnemonicSolver.clear();
            }
            String string = "oracle.ide.ContextMenu.callMenuWillShow";
            ArrayList arrayList2 = new ArrayList(this.listeners);
            int n = arrayList2.size();
            int n2 = 0;
            while (n2 < n) {
                Class clazz2 = (Class)arrayList2.get(n2 + 1);
                ContextMenuListener contextMenuListener = null;
                if (clazz2 != null) {
                    if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                        contextMenuListener = (ContextMenuListener)arrayList2.get(n2);
                    }
                } else {
                    contextMenuListener = (ContextMenuListener)arrayList2.get(n2);
                }
                if (contextMenuListener != null) {
                    try {
                        contextMenuListener.menuWillShow(this);
                    }
                    catch (ThreadDeath threadDeath) {
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                n2 += 2;
            }
            if (n > 0 && this._mnemonicSolver != null) {
                this._mnemonicSolver.solve();
            }
            this.sortContainer(this.popup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callMenuWillHide() {
        Class<?> clazz = null;
        try {
            clazz = this.currentContext.getElement().getData().getClass();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            ArrayList arrayList2 = new ArrayList(this.listeners);
            int n = arrayList2.size();
            int n2 = 0;
            while (n2 < n) {
                Class clazz2 = (Class)arrayList2.get(n2 + 1);
                try {
                    if (clazz2 != null) {
                        if (clazz != null && clazz2.isAssignableFrom(clazz)) {
                            ((ContextMenuListener)arrayList2.get(n2)).menuWillHide(this);
                        }
                    } else {
                        ((ContextMenuListener)arrayList2.get(n2)).menuWillHide(this);
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                n2 += 2;
            }
        }
    }

    private void addToSolver(Component component, boolean bl) {
        if (this._mnemonicSolver != null) {
            this._mnemonicSolver.addMenuLabel(component, bl);
        }
    }

    static void mav$callMenuWillHide(ContextMenu contextMenu) {
        contextMenu.callMenuWillHide();
    }

    static void wa$currentContext(ContextMenu contextMenu, Context context) {
        contextMenu.currentContext = context;
    }

    public final class 1
    implements PopupMenuListener {
        public final void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            ContextMenu.mav$callMenuWillHide(ContextMenu.this);
            ContextMenu.wa$currentContext(ContextMenu.this, null);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public final void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }
}

