/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.View;
import oracle.javatools.dialogs.ExceptionDialog;

public class IdeAction
extends ToggleAction {
    private final ArrayList _controllers;
    private String _command;
    private int _commandId;
    private static boolean _handlerInProgress;

    void $init$() {
        this._controllers = new ArrayList(1);
    }

    protected IdeAction() {
        super(null, null);
        this.$init$();
        if (!"oracle.ideimpl.jsr198.JSR198Action".equals(this.getClass().getName())) {
            throw new UnsupportedOperationException();
        }
    }

    private IdeAction(String string, Icon icon) {
        super(string, icon);
        this.$init$();
    }

    private IdeAction(IdeAction ideAction) {
        super(ideAction);
        this.$init$();
        this._command = ideAction._command;
        this._commandId = ideAction._commandId;
    }

    private IdeAction(String string, ResourceBundle resourceBundle, String string2) {
        super(string, resourceBundle, string2);
        this.$init$();
    }

    private IdeAction(String string, ArrayResourceBundle arrayResourceBundle, int n) {
        super(string, arrayResourceBundle, n);
        this.$init$();
    }

    public static IdeAction get(int n, String string, String string2) {
        ActionMap actionMap = Ide.getIdeActionMap();
        IdeAction ideAction = (IdeAction)actionMap.get(new Integer(n));
        if (ideAction != null) {
            return ideAction;
        }
        ideAction = IdeAction.create(n, string, string2, null, null, null, null, null, -1, null, true);
        actionMap.put(new Integer(n), ideAction);
        return ideAction;
    }

    public static IdeAction get(int n, String string, String string2, ArrayResourceBundle arrayResourceBundle, int n2) {
        ActionMap actionMap = Ide.getIdeActionMap();
        IdeAction ideAction = (IdeAction)actionMap.get(new Integer(n));
        if (ideAction != null) {
            return ideAction;
        }
        ideAction = IdeAction.create(n, string, string2, null, null, null, arrayResourceBundle, null, n2, null, true);
        actionMap.put(new Integer(n), ideAction);
        return ideAction;
    }

    public static IdeAction get(int n, String string, String string2, String string3, Integer n2, Icon icon, Object object, boolean bl) {
        ActionMap actionMap = Ide.getIdeActionMap();
        IdeAction ideAction = (IdeAction)actionMap.get(new Integer(n));
        if (ideAction != null) {
            return ideAction;
        }
        ideAction = IdeAction.create(n, string, string2, string3, n2, icon, null, null, -1, object, bl);
        actionMap.put(new Integer(n), ideAction);
        return ideAction;
    }

    public static IdeAction get(int n, String string, String string2, String string3, Integer n2, ArrayResourceBundle arrayResourceBundle, int n3, Object object, boolean bl) {
        ActionMap actionMap = Ide.getIdeActionMap();
        IdeAction ideAction = (IdeAction)actionMap.get(new Integer(n));
        if (ideAction != null) {
            return ideAction;
        }
        ideAction = IdeAction.create(n, string, string2, string3, n2, null, arrayResourceBundle, null, n3, object, bl);
        actionMap.put(new Integer(n), ideAction);
        return ideAction;
    }

    public static IdeAction get(int n, String string, String string2, String string3, Integer n2, ResourceBundle resourceBundle, String string4, Object object, boolean bl) {
        ActionMap actionMap = Ide.getIdeActionMap();
        IdeAction ideAction = (IdeAction)actionMap.get(new Integer(n));
        if (ideAction != null) {
            return ideAction;
        }
        ideAction = IdeAction.create(n, string, string2, string3, n2, null, resourceBundle, string4 != null ? string4 : "", -1, object, bl);
        actionMap.put(new Integer(n), ideAction);
        return ideAction;
    }

    public static IdeAction get(int n) {
        return IdeAction.get(n, (String)null, (Integer)null);
    }

    public static IdeAction get(int n, String string, Integer n2) {
        IdeAction ideAction = IdeAction.get(n, null, string);
        if (n2 != null) {
            ideAction.putValue("MnemonicKey", n2);
        }
        return ideAction;
    }

    public static IdeAction find(int n) {
        Integer n2 = new Integer(n);
        return (IdeAction)Ide.getIdeActionMap().get(n2);
    }

    public static void remove(int n) {
        Integer n2 = new Integer(n);
        Ide.getIdeActionMap().remove(n2);
    }

    public static IdeAction[] findGroup(String string) {
        ActionMap actionMap = Ide.getIdeActionMap();
        Object[] objectArray = actionMap.allKeys();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        TreeMap<Object, IdeAction> treeMap = new TreeMap<Object, IdeAction>();
        int n = 0;
        while (n < objectArray.length) {
            IdeAction ideAction;
            String string2;
            Object object = objectArray[n];
            Action action = actionMap.get(object);
            if (action instanceof IdeAction && (string2 = (String)(ideAction = (IdeAction)action).getValue("RadioGroupName")) != null && string2.equals(string)) {
                treeMap.put(object, ideAction);
            }
            ++n;
        }
        return treeMap.size() > 0 ? treeMap.values().toArray(new IdeAction[treeMap.size()]) : null;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        if (ToggleAction.PERFORM_ACTION_LATER) {
            2 var2_2 = new 2(this, actionEvent);
            IdeUtil.invokeAfterRepaint(var2_2);
        } else {
            this.actionPerformedImpl(actionEvent);
        }
    }

    public final void performAction() throws Exception {
        this.performAction(this.getView().getContext());
    }

    public final void performAction(Context context) throws Exception {
        boolean bl = IdeAction.handlerStarting();
        FeedbackManager feedbackManager = FeedbackManager.getFeedbackManager();
        feedbackManager.addFeedback("Performing action " + this.getValue("Name"), context);
        try {
            ControllerIterator controllerIterator = new ControllerIterator(null);
            while (controllerIterator.hasNext()) {
                Controller controller = controllerIterator.next();
                try {
                    if (!controller.handleEvent(this, context)) continue;
                    IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_ACTION_PERFORMED);
                    return;
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    feedbackManager.reportException("Exception while performing action " + this.getValue("Name"), throwable);
                }
            }
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            Command command = CommandProcessor.createCommand(this.getCommand(), context);
            if (command != null) {
                commandProcessor.invoke(command);
            }
        }
        finally {
            IdeAction.handlerFinished(bl, Controller.UPDATE_FROM_ACTION_PERFORMED);
        }
    }

    public final void updateAction() {
        this.updateAction(this.getView().getContext());
    }

    public final void updateAction(Context context) {
        ControllerIterator controllerIterator = new ControllerIterator(null);
        while (controllerIterator.hasNext()) {
            Controller controller = controllerIterator.next();
            try {
                if (!controller.update(this, context)) continue;
                return;
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public final void addController(Controller controller) {
        if (controller != null && !this._controllers.contains(controller)) {
            this._controllers.add(0, controller);
        }
    }

    public static final void addController(int n, Controller controller) {
        IdeAction ideAction = IdeAction.find(n);
        if (ideAction != null) {
            ideAction.addController(controller);
        }
    }

    public final void removeController(Controller controller) {
        if (controller != null) {
            this._controllers.remove(controller);
        }
    }

    public static final void removeController(int n, Controller controller) {
        IdeAction ideAction = IdeAction.find(n);
        if (ideAction != null) {
            ideAction.removeController(controller);
        }
    }

    public final String getCommand() {
        return this._command;
    }

    public final void setCommand(String string) {
        this._command = string;
    }

    public final void setCommandId(int n) {
        this._commandId = n;
    }

    public final int getCommandId() {
        return this._commandId;
    }

    public final void putValueDirectly(String string, Object object) {
        super.putValue(string, object);
    }

    public static final IdeAction newLocalAction(int n, View view) {
        IdeAction ideAction = IdeAction.find(n);
        if (ideAction != null) {
            return ideAction.newLocalAction(view);
        }
        return null;
    }

    public IdeAction newLocalAction(View view) {
        return new Local(this, view);
    }

    public final boolean isLocalAction() {
        return this.getClass() == Local.class;
    }

    View getView() {
        return Ide.getMainWindow().getLastActiveView();
    }

    ArrayList getControllers() {
        return (ArrayList)this.getControllersDirectly().clone();
    }

    final ArrayList getControllersDirectly() {
        return this._controllers;
    }

    final void actionPerformedImpl(ActionEvent actionEvent) {
        MenuSelectionManager.defaultManager().clearSelectedPath();
        1 var2_2 = new 1(this, actionEvent);
        if (ToggleAction.PERFORM_ACTION_LATER) {
            SwingUtilities.invokeLater(var2_2);
        } else {
            var2_2.run();
        }
    }

    static final synchronized boolean handlerStarting() {
        boolean bl = _handlerInProgress;
        _handlerInProgress = true;
        return bl;
    }

    public static final synchronized boolean isHandlerInProgress() {
        return _handlerInProgress;
    }

    static final synchronized void handlerFinished(boolean bl, int n) {
        try {
            if (!bl) {
                IdeMainWindow.updateVisibleActions(n);
                _handlerInProgress = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static IdeAction create(int n, String string, String string2, String string3, Integer n2, Icon icon, ResourceBundle resourceBundle, String string4, int n3, Object object, boolean bl) {
        IdeAction ideAction = icon != null ? new IdeAction(string2, icon) : (string4 != null ? new IdeAction(string2, resourceBundle, string4) : new IdeAction(string2, (ArrayResourceBundle)resourceBundle, n3));
        ideAction._commandId = n;
        ideAction._command = string;
        if (string3 != null) {
            ideAction.putValue("Category", string3);
        }
        if (n2 != null) {
            ideAction.putValue("MnemonicKey", n2);
        }
        if (object != null) {
            ideAction.putValue("UserData", object);
        }
        ideAction.setEnabled(bl);
        return ideAction;
    }

    static void maS$freezeKeyboard(boolean bl) {
        ToggleAction.freezeKeyboard(bl);
    }

    IdeAction(IdeAction ideAction, 1 var2_2) {
        this(ideAction);
    }

    public final class 2
    implements Runnable {
        private final /* synthetic */ ActionEvent v$event;
        final /* synthetic */ IdeAction this$0;

        public void run() {
            this.this$0.actionPerformedImpl(this.v$event);
        }

        public 2(IdeAction ideAction, ActionEvent actionEvent) {
            this.v$event = actionEvent;
            this.this$0 = ideAction;
        }
    }

    public final class 1
    implements Runnable {
        private final /* synthetic */ ActionEvent v$event;
        final /* synthetic */ IdeAction this$0;

        public void run() {
            if (this.this$0.isEnabled()) {
                try {
                    try {
                        IdeAction.maS$freezeKeyboard(true);
                        Context context = null;
                        if (this.v$event.getSource() instanceof JMenuItem) {
                            JMenuItem jMenuItem = (JMenuItem)this.v$event.getSource();
                            context = ContextMenu.getContext(jMenuItem, this.v$event);
                            ContextMenu.clearContext(jMenuItem);
                        }
                        if (context == null) {
                            context = this.this$0.getView().getContext(this.v$event);
                        }
                        this.this$0.performAction(context);
                    }
                    catch (Exception exception) {
                        ExceptionDialog.showExceptionDialog((Window)((Object)Ide.getMainWindow()), (Exception)exception);
                    }
                }
                finally {
                    IdeAction.maS$freezeKeyboard(false);
                }
            }
        }

        public 1(IdeAction ideAction, ActionEvent actionEvent) {
            this.v$event = actionEvent;
            this.this$0 = ideAction;
        }
    }

    private final class ControllerIterator {
        private final ArrayList _actionControllers;
        private final Iterator _actionControllersIter;
        private boolean _triedActionViewController;
        private int _i;
        private List _controllerStack;
        private boolean _triedIdeController;
        private Controller _curController;

        void $init$() {
            this._actionControllers = IdeAction.this.getControllers();
            this._actionControllersIter = this._actionControllers.iterator();
        }

        boolean hasNext() {
            this.tryNext();
            return this._curController != null;
        }

        Controller next() {
            this.tryNext();
            Controller controller = this._curController;
            this._curController = null;
            return controller;
        }

        private void tryNext() {
            if (this._curController == null) {
                this._curController = this.nextImpl();
            }
        }

        private Controller nextImpl() {
            if (this._actionControllersIter.hasNext()) {
                return (Controller)this._actionControllersIter.next();
            }
            View view = IdeAction.this.getView();
            if (!this._triedActionViewController) {
                Controller controller;
                this._triedActionViewController = true;
                if (view != null && (controller = view.getController()) != null) {
                    return controller;
                }
            }
            if (this._controllerStack == null) {
                IdeMainWindow ideMainWindow = Ide.getMainWindow();
                IdeMainWindow.ControllerContext controllerContext = ideMainWindow.getControllerContext();
                this._controllerStack = controllerContext.getControllerProviders(view);
            }
            int n = this._controllerStack.size();
            if (this._i < n) {
                ControllerProvider controllerProvider = (ControllerProvider)this._controllerStack.get(this._i++);
                Controller controller = controllerProvider.getController();
                return controller;
            }
            if (!this._triedIdeController) {
                this._triedIdeController = true;
                return Ide.getIdeController();
            }
            return null;
        }

        private ControllerIterator() {
            this.$init$();
        }

        ControllerIterator(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class Local
    extends IdeAction {
        private final IdeAction _action;
        private final View _view;

        Local(IdeAction ideAction, View view) {
            super(ideAction, null);
            this._action = ideAction;
            this._view = view;
            this.setEnabled(ideAction.isEnabled());
        }

        public Object getValue(String string) {
            Object object = super.getValue(string);
            if (object == null) {
                object = this._action.getValue(string);
            }
            return object;
        }

        public void putValue(String string, Object object) {
            this.putValueDirectly(string, object);
            if (this._action != null) {
                this._action.putValue(string, object);
            }
        }

        public IdeAction newLocalAction(View view) {
            return new Local(this._action, view);
        }

        final View getView() {
            return this._view != null ? this._view : super.getView();
        }

        final ArrayList getControllers() {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.getControllersDirectly());
            if (this._action != null) {
                arrayList.addAll(this._action.getControllersDirectly());
            }
            return arrayList;
        }
    }
}

