/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuWeightComparator;
import oracle.ide.controls.ChangeAdaptor;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.IdeProfile;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class MenuManager {
    private final MenuListener _menuListener;
    final ContainerListener _containerListener;
    private final L _listener;
    private static final int LAST_POSITION = -1;
    private static final String ALPHA_SORT_SECTION_KEY = "alpha-sort-sections";
    private static final String SORT_MENU_KEY = "menu-is-sorted";
    private static final InitialContext _ic = Names.newInitialContext();

    void $init$() {
        this._menuListener = new PrivateMenuListener(null);
        this._containerListener = new PrivateContainerListener(null);
        this._listener = new L(null);
    }

    MenuManager() {
        this.$init$();
    }

    public static final JMenu getJMenu(String string) {
        return (JMenu)Names.lookup((javax.naming.Context)_ic, (String)MenuManager.menuKey(string));
    }

    public static final void putJMenu(String string, JMenu jMenu) {
        String string2 = MenuManager.menuKey(string);
        if (jMenu == null) {
            Names.unbind((javax.naming.Context)_ic, (String)string2);
        } else {
            Names.bind((javax.naming.Context)_ic, (String)string2, (Object)jMenu);
        }
    }

    private static String menuKey(String string) {
        return "env/menus/" + string;
    }

    public JMenu createMenu(String string, Integer n) {
        return this.createMenu(string, n, Float.MAX_VALUE);
    }

    public JMenu createMenu(String string, Integer n, float f) {
        return this.createMenu(string, n, f, Float.MAX_VALUE);
    }

    public JMenu createMenu(String string, Integer n, float f, float f2) {
        return this.createMenu(string, n, f, Float.MAX_VALUE, f2);
    }

    private JMenu createMenu(String string, Integer n, float f, float f2, float f3) {
        JMenu jMenu = new JMenu(string);
        if (n != null) {
            int n2 = n;
            if (n2 >= 97 && n2 <= 122) {
                n2 -= 32;
            }
            jMenu.setMnemonic(n2);
        }
        this.setWeight(jMenu, f, "menu-weight");
        this.setWeight(jMenu, f2, "menu-section-id");
        this.setWeight(jMenu, f3, "menu-addin-section-id");
        this.addMenuManagerAsListener(jMenu);
        return jMenu;
    }

    public JMenu createSubMenu(String string, Integer n) {
        return this.createSubMenu(string, n, Float.MAX_VALUE);
    }

    public JMenu createSubMenu(String string, Integer n, float f) {
        return this.createSubMenu(string, n, f, Float.MAX_VALUE);
    }

    public JMenu createSubMenu(String string, Integer n, float f, float f2) {
        return this.createMenu(string, n, f, f2, Float.MAX_VALUE);
    }

    public JMenuItem createMenuItem(ToggleAction toggleAction) {
        return this.createMenuItem(toggleAction, Float.MAX_VALUE);
    }

    public JMenuItem createMenuItem(ToggleAction toggleAction, float f) {
        if (toggleAction == null) {
            return null;
        }
        JMenuItem jMenuItem = toggleAction.isRadio() ? new RadioMenuItem(toggleAction) : (toggleAction.isToggle() ? new ToggleMenuItem(toggleAction) : new MenuItem(toggleAction));
        if (f != Float.MAX_VALUE) {
            jMenuItem.putClientProperty("menu-weight", new Float(f));
        } else {
            jMenuItem.putClientProperty("menu-weight", new Float(toggleAction.getMenuWeight()));
        }
        if (toggleAction instanceof IdeAction) {
            MenuManager.refreshMenuItem(jMenuItem);
            KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
            InnerChangeAdaptor innerChangeAdaptor = new InnerChangeAdaptor(jMenuItem, keyStrokeOptions);
            keyStrokeOptions.addChangeListener(innerChangeAdaptor);
        }
        return jMenuItem;
    }

    public void add(Component component) {
        this.add(component, Float.MAX_VALUE);
    }

    public void add(Component component, float f) {
        Container container;
        if (component != null && (container = this.getGUI(true)) != null) {
            this.setWeight(component, f, "menu-section-id");
            if (container instanceof JMenuBar) {
                this.addToMenubar((JMenuBar)container, component);
            } else {
                container.add(component);
            }
            this.addMenuManagerAsListener(component);
        }
    }

    public void add(Component component, JMenu jMenu) {
        this.add(component, jMenu, Float.MAX_VALUE);
    }

    public void add(Component component, JMenu jMenu, float f) {
        if (component == null) {
            throw new NullPointerException("child is null");
        }
        if (jMenu == null) {
            throw new NullPointerException("parent is null");
        }
        this.setWeight(component, f, "menu-section-id");
        jMenu.add(component);
        this.addMenuManagerAsListener(component);
    }

    public void remove(Component component) {
        Container container;
        if (component != null && (container = this.getGUI(false)) != null) {
            container.remove(component);
            this.adjustSeparators(container);
            this.removeMenuManagerAsListener(component);
        }
    }

    public void remove(Component component, JMenu jMenu) {
        int n;
        if (component != null && jMenu != null && (n = this.getIndexOfChild(jMenu, component)) != -1) {
            jMenu.remove(n);
            this.removeMenuManagerAsListener(component);
        }
    }

    public abstract Container getGUI(boolean var1);

    public int getIndexOfChild(Container container, Component component) {
        if (container instanceof JMenu) {
            container = ((JMenu)container).getPopupMenu();
        }
        if (container == null || component == null) {
            return -1;
        }
        int n = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        while (n2 < n) {
            Component component2 = componentArray[n2];
            if (component2 == component) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int getIndexOfCommandId(Container container, int n) {
        if (container instanceof JMenu) {
            container = ((JMenu)container).getPopupMenu();
        }
        if (container == null) {
            return -1;
        }
        int n2 = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < n2) {
            JComponent jComponent = (JComponent)componentArray[n3];
            IdeAction ideAction = this._getIdeAction(jComponent);
            if (ideAction != null && ideAction.getCommandId() == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public Component getChildById(Container container, int n) {
        if (container instanceof JMenu) {
            container = ((JMenu)container).getPopupMenu();
        }
        if (container == null) {
            return null;
        }
        int n2 = container.getComponentCount();
        Component[] componentArray = container.getComponents();
        int n3 = 0;
        while (n3 < n2) {
            JComponent jComponent = (JComponent)componentArray[n3];
            IdeAction ideAction = this._getIdeAction(jComponent);
            if (ideAction != null && ideAction.getCommandId() == n) {
                return jComponent;
            }
            ++n3;
        }
        return null;
    }

    public void sortSectionByName(JMenu jMenu, float f) {
        Float f2;
        ArrayList<Float> arrayList = (ArrayList<Float>)jMenu.getClientProperty(ALPHA_SORT_SECTION_KEY);
        if (arrayList == null) {
            arrayList = new ArrayList<Float>(1);
        }
        if (!arrayList.contains(f2 = new Float(f))) {
            arrayList.add(f2);
        }
        jMenu.putClientProperty(ALPHA_SORT_SECTION_KEY, arrayList);
    }

    public void removeMenuManagerMenuListener(JMenu jMenu) {
        if (jMenu != null) {
            jMenu.removeMenuListener(this._listener);
        }
    }

    private void setWeight(Component component, float f, String string) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)component;
        if (f != Float.MAX_VALUE) {
            jComponent.putClientProperty(string, new Float(f));
        } else {
            Float f2 = (Float)jComponent.getClientProperty(string);
            if (f2 == null || f2.floatValue() == Float.MAX_VALUE) {
                jComponent.putClientProperty(string, new Float(f));
            }
        }
    }

    private IdeAction _getIdeAction(Component component) {
        AbstractButton abstractButton;
        Action action;
        if (component instanceof AbstractButton && (action = (abstractButton = (AbstractButton)component).getAction()) != null && action instanceof IdeAction) {
            return (IdeAction)action;
        }
        return null;
    }

    private static void updateMenuItems(JMenu jMenu, EventObject eventObject) {
        MenuManager.workaroundExpandingSwingJPopupMenuBug(jMenu.getPopupMenu());
        View view = Ide.getMainWindow().getLastActiveView();
        Context context = view != null ? view.getContext(eventObject) : Context.newIdeContext();
        int n = jMenu.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            MenuManager.updateMenuItemAction(jMenu.getItem(n2), context);
            ++n2;
        }
    }

    static void updatePopupMenuItems(JPopupMenu jPopupMenu, Context context) {
        MenuManager.workaroundExpandingSwingJPopupMenuBug(jPopupMenu);
        MenuElement[] menuElementArray = jPopupMenu.getSubElements();
        if (menuElementArray != null) {
            int n = menuElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                MenuElement menuElement = menuElementArray[n2];
                if (menuElement instanceof JMenuItem) {
                    MenuManager.updateMenuItemAction((JMenuItem)menuElement, context);
                }
                ++n2;
            }
        }
    }

    private static void workaroundExpandingSwingJPopupMenuBug(JComponent jComponent) {
        jComponent.putClientProperty("maxTextWidth", null);
        jComponent.putClientProperty("maxAccWidth", null);
    }

    private static void updateMenuItemAction(JMenuItem jMenuItem, Context context) {
        Action action;
        if (jMenuItem != null && (action = jMenuItem.getAction()) instanceof IdeAction) {
            IdeAction ideAction = (IdeAction)action;
            ideAction.updateAction(context);
        }
    }

    private static void refreshMenuItem(JMenuItem jMenuItem) {
        KeyStroke keyStroke;
        int n = IdeProfile.startEvent(500, "RefreshMenu");
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        IdeAction ideAction = (IdeAction)jMenuItem.getAction();
        KeyStroke keyStroke2 = null;
        if (ideAction != null) {
            HashMap hashMap;
            int n2 = ideAction.getCommandId();
            KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
            keyStroke2 = KeyUtil.getBestAccelerator(keyStrokeMap, n2);
            if (keyStroke2 == null && (hashMap = keyStrokeOptions.getLocalKeyMaps()) != null) {
                Iterator iterator = hashMap.values().iterator();
                while (keyStroke2 == null && iterator.hasNext()) {
                    KeyStrokeMap keyStrokeMap2 = (KeyStrokeMap)iterator.next();
                    keyStroke2 = KeyUtil.getBestAccelerator(keyStrokeMap2, n2);
                }
            }
        }
        if ((keyStroke = jMenuItem.getAccelerator()) == null) {
            if (keyStroke2 != null) {
                jMenuItem.setAccelerator(keyStroke2);
                MenuManager.updateAccessibleMenuName(jMenuItem, keyStroke2);
            }
        } else if (!keyStroke.equals(keyStroke2)) {
            jMenuItem.setAccelerator(null);
            MenuManager.updateAccessibleMenuName(jMenuItem, keyStroke2);
            if (keyStroke2 != null) {
                jMenuItem.setAccelerator(keyStroke2);
                MenuManager.updateAccessibleMenuName(jMenuItem, keyStroke2);
            }
        }
        IdeProfile.endEvent(n);
    }

    private static void updateAccessibleMenuName(JMenuItem jMenuItem, KeyStroke keyStroke) {
        String string = jMenuItem.getText();
        if (string != null && keyStroke != null) {
            StringBuffer stringBuffer = new StringBuffer(string.trim());
            String string2 = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
            String string3 = KeyEvent.getKeyText(keyStroke.getKeyCode());
            if (string2.length() > 0) {
                stringBuffer.append(string2);
                if (string3.length() > 0) {
                    stringBuffer.append("+");
                    stringBuffer.append(string3);
                }
            } else if (string3.length() > 0) {
                stringBuffer.append(string3);
            }
            jMenuItem.getAccessibleContext().setAccessibleName(stringBuffer.toString());
        }
    }

    private void adjustSeparators(Container container) {
        if (container.getComponentCount() < 2) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        Component[] componentArray = container.getComponents();
        int n = componentArray.length - 1;
        while (n >= 0) {
            boolean bl3 = componentArray[n] instanceof JSeparator;
            if (bl2 && bl3) {
                container.remove(componentArray[n]);
                bl = true;
            }
            bl2 = bl3;
            --n;
        }
        if (bl) {
            container.validate();
        }
    }

    private void addToMenubar(JMenuBar jMenuBar, Component component) {
        if (jMenuBar.getComponentCount() == 0) {
            jMenuBar.add(component);
            jMenuBar.validate();
            return;
        }
        JComponent jComponent = (JComponent)component;
        Float f = (Float)jComponent.getClientProperty("menu-weight");
        if (f == null) {
            f = new Float(Float.MAX_VALUE);
        }
        Component[] componentArray = jMenuBar.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            int n2;
            if (componentArray[n] == component) {
                return;
            }
            JComponent jComponent2 = (JComponent)componentArray[n];
            Float f2 = (Float)jComponent2.getClientProperty("menu-weight");
            int n3 = n2 = f2 != null ? f.compareTo(f2) : 1;
            if (n2 < 0) {
                jMenuBar.add(component, n);
                jMenuBar.validate();
                return;
            }
            ++n;
        }
        jMenuBar.add(component);
        jMenuBar.validate();
    }

    public void sortContainer(Container container) {
        if (container == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        Component[] componentArray = container instanceof JMenu ? ((JMenu)container).getMenuComponents() : container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (!(componentArray[n] instanceof JSeparator) && componentArray[n] instanceof JComponent) {
                ArrayList<JComponent> arrayList;
                JComponent jComponent = (JComponent)componentArray[n];
                Float f = (Float)jComponent.getClientProperty("menu-section-id");
                if (f == null) {
                    f = new Float(Float.MAX_VALUE);
                }
                if ((arrayList = (ArrayList<JComponent>)hashMap.get(f)) == null) {
                    arrayList = new ArrayList<JComponent>();
                    hashMap.put(f, arrayList);
                }
                if (!arrayList.contains(jComponent)) {
                    arrayList.add(jComponent);
                }
            }
            ++n;
        }
        container.removeAll();
        ArrayList arrayList = new ArrayList(hashMap.keySet());
        if (arrayList.size() > 1) {
            Collections.sort(arrayList);
        }
        ArrayList arrayList2 = container instanceof JMenu ? (ArrayList)((JMenu)container).getClientProperty(ALPHA_SORT_SECTION_KEY) : null;
        MenuWeightComparator menuWeightComparator = new MenuWeightComparator(arrayList2);
        boolean bl = !(container instanceof JMenuBar);
        int n2 = 0;
        int n3 = arrayList.size();
        Component component = null;
        for (Float f : arrayList) {
            ArrayList arrayList3 = (ArrayList)hashMap.get(f);
            if (arrayList3.size() > 1) {
                Collections.sort(arrayList3, menuWeightComparator);
            }
            for (Component component2 : arrayList3) {
                if (component2 == null || component2 instanceof JSeparator) continue;
                container.add(component2);
                component = component2;
            }
            if (!bl || ++n2 == n3 || component == null) continue;
            container.add(new JSeparator());
        }
        container.validate();
    }

    private void addMenuManagerAsListener(Component component) {
        if (component instanceof JMenu) {
            JMenu jMenu = (JMenu)component;
            MenuListener[] menuListenerArray = (MenuListener[])jMenu.getListeners(MenuListener.class);
            int n = 0;
            while (n < menuListenerArray.length) {
                if (menuListenerArray[n] == this._listener) {
                    return;
                }
                ++n;
            }
            jMenu.addMenuListener(this._listener);
            jMenu.getPopupMenu().addContainerListener(this._listener);
        }
    }

    private void removeMenuManagerAsListener(Component component) {
        if (component instanceof JMenu) {
            JMenu jMenu = (JMenu)component;
            jMenu.removeMenuListener(this._listener);
            jMenu.getPopupMenu().removeContainerListener(this._listener);
        }
    }

    static void maS$refreshMenuItem(JMenuItem jMenuItem) {
        MenuManager.refreshMenuItem(jMenuItem);
    }

    static void maS$updateMenuItems(JMenu jMenu, EventObject eventObject) {
        MenuManager.updateMenuItems(jMenu, eventObject);
    }

    static MenuListener ra$_menuListener(MenuManager menuManager) {
        return menuManager._menuListener;
    }

    private static final class InnerChangeAdaptor
    extends ChangeAdaptor {
        public InnerChangeAdaptor(AbstractButton abstractButton, ChangeEventSource changeEventSource) {
            super(abstractButton, changeEventSource);
        }

        protected void _stateChanged(ChangeEvent changeEvent) {
            JMenuItem jMenuItem = (JMenuItem)this.getAdaptee();
            MenuManager.maS$refreshMenuItem(jMenuItem);
        }
    }

    private final class PrivateMenuListener
    implements MenuListener {
        public final void menuSelected(MenuEvent menuEvent) {
            MenuManager.maS$updateMenuItems((JMenu)menuEvent.getSource(), menuEvent);
        }

        public final void menuDeselected(MenuEvent menuEvent) {
        }

        public final void menuCanceled(MenuEvent menuEvent) {
        }

        private PrivateMenuListener() {
        }

        PrivateMenuListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class PrivateContainerListener
    implements ContainerListener {
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                this.addListenersToTree(((JMenu)component).getPopupMenu());
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                this.removeListenersFromTree(((JMenu)component).getPopupMenu());
            }
        }

        private void addListenersToTree(JPopupMenu jPopupMenu) {
            JMenu jMenu = (JMenu)jPopupMenu.getInvoker();
            if (jMenu != null) {
                jMenu.addMenuListener(MenuManager.ra$_menuListener(MenuManager.this));
                jPopupMenu.addContainerListener(this);
            }
            Component[] componentArray = jPopupMenu.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JMenu) {
                    this.addListenersToTree(((JMenu)componentArray[n]).getPopupMenu());
                }
                ++n;
            }
        }

        private void removeListenersFromTree(JPopupMenu jPopupMenu) {
            JMenu jMenu = (JMenu)jPopupMenu.getInvoker();
            if (jMenu != null) {
                jMenu.removeMenuListener(MenuManager.ra$_menuListener(MenuManager.this));
                jPopupMenu.removeContainerListener(this);
            }
            Component[] componentArray = jPopupMenu.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (componentArray[n] instanceof JMenu) {
                    this.removeListenersFromTree(((JMenu)componentArray[n]).getPopupMenu());
                }
                ++n;
            }
        }

        private PrivateContainerListener() {
        }

        PrivateContainerListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    implements MenuListener,
    ContainerListener {
        public void menuSelected(MenuEvent menuEvent) {
            JMenu jMenu = (JMenu)menuEvent.getSource();
            if (!Boolean.TRUE.equals(jMenu.getClientProperty(MenuManager.SORT_MENU_KEY))) {
                MenuManager.this.sortContainer(jMenu);
                jMenu.putClientProperty(MenuManager.SORT_MENU_KEY, Boolean.TRUE);
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)containerEvent.getSource();
            JMenu jMenu = (JMenu)jPopupMenu.getInvoker();
            jMenu.putClientProperty(MenuManager.SORT_MENU_KEY, null);
        }

        public void componentRemoved(ContainerEvent containerEvent) {
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

