/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.ide.controller.MenuManager;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.JDK;
import oracle.ide.view.View;

public final class Menubar
extends MenuManager {
    private View view;
    private JMenuBar gui;
    private JMenu _activeMenu;
    private Component _wasFocused;
    private boolean _bIsActive;
    private final L _listener;
    private static boolean _mustWorkAround4647105 = Menubar.mustWorkAround4647105();

    void $init$() {
        this.view = null;
        this.gui = null;
        this._bIsActive = true;
        this._listener = new L(null);
    }

    private static boolean mustWorkAround4647105() {
        Rectangle[] rectangleArray;
        if (JDK.HAS_BUG_4647105 && (rectangleArray = GraphicsUtils.getScreenBounds()).length > 1) {
            System.setProperty("javax.swing.adjustPopupLocationToFit", Boolean.toString(false));
            return true;
        }
        return false;
    }

    public Menubar(View view) {
        this.$init$();
        this.view = view;
    }

    public synchronized Container getGUI(boolean bl) {
        if (this.gui == null && bl) {
            Component component;
            Component component2 = component = this.view != null ? this.view.getGUI() : null;
            if (component != null && component instanceof JFrame) {
                JFrame jFrame = (JFrame)component;
                this.gui = jFrame.getJMenuBar();
                if (this.gui == null) {
                    this.gui = JDK.SEARCH_ACCELERATORS_IN_MENUS ? new JMenuBar() : new 1();
                    jFrame.setJMenuBar(this.gui);
                }
                if (JDK.HAS_BUG_4336775 || JDK.HAS_BUG_4776532) {
                    jFrame.addWindowListener(this._listener);
                }
                this.gui.addContainerListener(this._containerListener);
            }
        }
        return this.gui;
    }

    public JMenu createMenu(String string, Integer n) {
        if (JDK.HAS_BUG_4336775 || JDK.HAS_BUG_4647105) {
            JTopMenu jTopMenu = new JTopMenu(string);
            if (n != null) {
                jTopMenu.setMnemonic(n);
            }
            return jTopMenu;
        }
        return super.createMenu(string, n);
    }

    static Component ra$_wasFocused(Menubar menubar) {
        return menubar._wasFocused;
    }

    static boolean ra$_bIsActive(Menubar menubar) {
        return menubar._bIsActive;
    }

    static void wa$_wasFocused(Menubar menubar, Component component) {
        menubar._wasFocused = component;
    }

    static boolean ra$_mustWorkAround4647105() {
        return _mustWorkAround4647105;
    }

    static JMenu ra$_activeMenu(Menubar menubar) {
        return menubar._activeMenu;
    }

    static void wa$_activeMenu(Menubar menubar, JMenu jMenu) {
        menubar._activeMenu = jMenu;
    }

    static void wa$_bIsActive(Menubar menubar, boolean bl) {
        menubar._bIsActive = bl;
    }

    private class TryLater
    implements Runnable {
        private Window _w;

        TryLater(Window window) {
            this._w = window;
        }

        public void run() {
            if (Menubar.ra$_wasFocused(Menubar.this) != null && Menubar.ra$_bIsActive(Menubar.this)) {
                Component component;
                Container container = Menubar.this.getGUI(false);
                if (container != null && container.isAncestorOf(component = this._w.getFocusOwner())) {
                    Menubar.ra$_wasFocused(Menubar.this).requestFocus();
                }
                Menubar.wa$_wasFocused(Menubar.this, null);
            }
        }
    }

    public final class 1
    extends JMenuBar {
        private final MenuElement[] NOMENUS;
        private boolean _returnNoMenus;

        void $init$() {
            this.NOMENUS = new MenuElement[0];
            this._returnNoMenus = false;
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            this._returnNoMenus = true;
            try {
                boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                this._returnNoMenus = false;
                return bl2;
            }
            catch (Throwable throwable) {
                this._returnNoMenus = false;
                throw throwable;
            }
        }

        public MenuElement[] getSubElements() {
            if (this._returnNoMenus) {
                return this.NOMENUS;
            }
            return super.getSubElements();
        }

        public 1() {
            this.$init$();
        }
    }

    public class JTopMenu
    extends JMenu {
        JTopMenu(String string) {
            super(string);
        }

        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            Window window;
            if (!JDK.HAS_BUG_4336775) {
                return super.processKeyBinding(keyStroke, keyEvent, n, bl);
            }
            JMenu jMenu = Menubar.ra$_activeMenu(Menubar.this);
            boolean bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
            if (bl2 && jMenu != null && Menubar.ra$_activeMenu(Menubar.this) == null && Menubar.ra$_wasFocused(Menubar.this) != null && Menubar.ra$_bIsActive(Menubar.this) && (window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null) {
                SwingUtilities.invokeLater(new TryLater(window));
            }
            return bl2;
        }

        public void setSelected(boolean bl) {
            if (JDK.HAS_BUG_4336775) {
                if (bl) {
                    JComponent jComponent;
                    Component component;
                    Window window;
                    if (Menubar.ra$_activeMenu(Menubar.this) == null && Menubar.ra$_wasFocused(Menubar.this) == null && (window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this)) != null && (component = window.getFocusOwner()) instanceof JComponent && (jComponent = (JComponent)component).getRootPane() != this.getRootPane()) {
                        Menubar.wa$_wasFocused(Menubar.this, component);
                    }
                    Menubar.wa$_activeMenu(Menubar.this, this);
                } else {
                    Menubar.wa$_activeMenu(Menubar.this, null);
                }
            }
            super.setSelected(bl);
        }

        protected Point getPopupMenuOrigin() {
            if (Menubar.ra$_mustWorkAround4647105() && !(this.getParent() instanceof JPopupMenu)) {
                Rectangle[] rectangleArray = GraphicsUtils.getScreenBounds();
                Point point = this.getLocationOnScreen();
                int n = 0;
                while (n < rectangleArray.length) {
                    Rectangle rectangle = rectangleArray[n];
                    if (rectangle.contains(point)) {
                        int n2 = 0;
                        int n3 = 0;
                        JPopupMenu jPopupMenu = this.getPopupMenu();
                        Dimension dimension = this.getSize();
                        Dimension dimension2 = jPopupMenu.getSize();
                        if (dimension2.width == 0) {
                            dimension2 = jPopupMenu.getPreferredSize();
                        }
                        n2 = this.getComponentOrientation().isLeftToRight() ? (point.x + dimension2.width < rectangle.x + rectangle.width ? 0 : dimension.width - dimension2.width) : (point.x + dimension.width < dimension2.width ? 0 : dimension.width - dimension2.width);
                        n3 = point.y + dimension.height + dimension2.height < rectangle.y + rectangle.height ? dimension.height : 0 - dimension2.height;
                        return new Point(n2, n3);
                    }
                    ++n;
                }
            }
            return super.getPopupMenuOrigin();
        }
    }

    private class L
    implements WindowListener {
        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
            Menubar.wa$_bIsActive(Menubar.this, true);
            if (Menubar.ra$_wasFocused(Menubar.this) != null) {
                SwingUtilities.invokeLater(new TryLater(windowEvent.getWindow()));
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Menubar.wa$_bIsActive(Menubar.this, false);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.clearSelectedPath();
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

