/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controller;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ide.menu.ActionRegistry;
import javax.ide.menu.ItemFactory;
import javax.ide.menu.spi.Item;
import javax.ide.menu.spi.MenuHook;
import javax.ide.menu.spi.Section;
import javax.ide.view.GUIPanel;
import javax.naming.Context;
import javax.swing.ButtonGroup;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.view.View;
import oracle.javatools.jndi.Names;

public abstract class ToolbarManager
implements Addin {
    private static final String TOOLBAR_MGR_NAME = "ide/toolbar-manager";

    public static ToolbarManager getToolbarManager() {
        return (ToolbarManager)Names.lookup((Context)Names.newInitialContext(), (String)TOOLBAR_MGR_NAME);
    }

    public static void setToolbarManager(ToolbarManager toolbarManager) {
        Names.bind((Context)Names.newInitialContext(), (String)TOOLBAR_MGR_NAME, (Object)toolbarManager);
    }

    public void installToolbar(String string, Toolbar toolbar, View view) {
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getOracleRegistry();
        MenuHook menuHook = (MenuHook)extensionRegistry.getHook(MenuHook.ELEMENT);
        Collection collection = menuHook.getModel().getItemFactories();
        javax.ide.menu.spi.Toolbar toolbar2 = (javax.ide.menu.spi.Toolbar)menuHook.getModel().getToolbars().get(string);
        List list = toolbar2.getSections();
        boolean bl = false;
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                toolbar.addSeparator();
            }
            Section section = (Section)iterator.next();
            List list2 = section.getContent();
            for (Item item : list2) {
                String string2 = item.getActionID();
                this.addToolbarItem(collection, string, section.getID(), view, toolbar, string2, hashMap);
            }
            bl = true;
        }
    }

    protected abstract IdeAction getAction(String var1);

    private Component getCustomComponent(Collection collection, String string) {
        for (ItemFactory itemFactory : collection) {
            GUIPanel gUIPanel = itemFactory.createItem(string);
            if (gUIPanel == null) continue;
            return (Component)gUIPanel.getRootComponent();
        }
        return null;
    }

    private void addToolbarItem(Collection collection, String string, String string2, View view, Toolbar toolbar, String string3, Map map) {
        Component component;
        String string4 = AddinManager.getAddinManager().getCommand(string3, "");
        IdeAction ideAction = null;
        ToggleAction[] toggleActionArray = null;
        Integer n = Ide.findCmdID(string3);
        if (n != null) {
            ideAction = this.getAction(string3);
        }
        if ((component = this.getCustomComponent(collection, string + '/' + string2 + '/' + string3)) != null) {
            toolbar.add(component);
            return;
        }
        if (ideAction == null) {
            toggleActionArray = IdeAction.findGroup(string3);
            if (toggleActionArray == null) {
                ExtensionRegistry.getOracleRegistry().getLogger().warning("action-ref '" + string3 + "' not found in section '" + string2 + "' on toolbar '" + string + "'.");
            }
        } else if (string4.length() != 0) {
            ideAction.setCommand(string4);
        }
        if (toggleActionArray != null) {
            if (view != null) {
                int n2 = 0;
                while (n2 < toggleActionArray.length) {
                    ToggleAction toggleAction = toggleActionArray[n2];
                    IdeAction ideAction2 = ((IdeAction)toggleAction).newLocalAction(view);
                    toggleActionArray[n2] = ideAction2;
                    ++n2;
                }
            }
            toolbar.addMenuButton(toggleActionArray);
        } else if (ideAction != null) {
            if (view != null) {
                ideAction = ideAction.newLocalAction(view);
            }
            if (ideAction.isToggle()) {
                toolbar.addToggleButton(ideAction);
            } else if (ideAction.isRadio()) {
                ButtonGroup buttonGroup;
                String string5 = (String)ideAction.getValue("RadioGroupName");
                if (string5 == null) {
                    string5 = "UnknownButtonGroup";
                }
                if ((buttonGroup = (ButtonGroup)map.get(string5)) == null) {
                    buttonGroup = new ButtonGroup();
                    map.put(string5, buttonGroup);
                }
                toolbar.addRadioButton(ideAction, buttonGroup);
            } else if (ideAction.isActionMenu()) {
                toolbar.addActionMenuButton(ideAction);
            } else {
                toolbar.add(ideAction);
            }
        }
    }

    public void initialize() {
        ActionRegistry.getActionRegistry();
    }
}

