/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import oracle.bali.ewt.chooser.color.BaseColorEditor;
import oracle.ide.controls.ColorIcon;
import oracle.ide.resource.ControlsArb;
import oracle.ide.util.ResourceUtils;

public class AWTColorComponent
extends BaseColorEditor {
    private static final HashMap COLORS = new HashMap();
    private boolean _ignoreEvents;
    private JLabel _label;
    private JComboBox _combo;

    static {
        COLORS.put(Color.black, "Color.black");
        COLORS.put(Color.blue, "Color.blue");
        COLORS.put(Color.cyan, "Color.cyan");
        COLORS.put(Color.darkGray, "Color.darkGray");
        COLORS.put(Color.gray, "Color.gray");
        COLORS.put(Color.green, "Color.green");
        COLORS.put(Color.lightGray, "Color.lightGray");
        COLORS.put(Color.magenta, "Color.magenta");
        COLORS.put(Color.orange, "Color.orange");
        COLORS.put(Color.pink, "Color.pink");
        COLORS.put(Color.red, "Color.red");
        COLORS.put(Color.white, "Color.white");
        COLORS.put(Color.yellow, "Color.yellow");
        COLORS.put(SystemColor.activeCaption, "SystemColor.activeCaption");
        COLORS.put(SystemColor.activeCaptionBorder, "SystemColor.activeCaptionBorder");
        COLORS.put(SystemColor.activeCaptionText, "SystemColor.activeCaptionText");
        COLORS.put(SystemColor.control, "SystemColor.control");
        COLORS.put(SystemColor.controlDkShadow, "SystemColor.controlDkShadow");
        COLORS.put(SystemColor.controlHighlight, "SystemColor.controlHighlight");
        COLORS.put(SystemColor.controlShadow, "SystemColor.controlShadow");
        COLORS.put(SystemColor.controlText, "SystemColor.controlText");
        COLORS.put(SystemColor.desktop, "SystemColor.desktop");
        COLORS.put(SystemColor.inactiveCaption, "SystemColor.inactiveCaption");
        COLORS.put(SystemColor.inactiveCaptionBorder, "SystemColor.inactiveCaptionBorder");
        COLORS.put(SystemColor.inactiveCaptionText, "SystemColor.inactiveCaptionText");
        COLORS.put(SystemColor.info, "SystemColor.info");
        COLORS.put(SystemColor.infoText, "SystemColor.infoText");
        COLORS.put(SystemColor.menu, "SystemColor.menu");
        COLORS.put(SystemColor.menuText, "SystemColor.menuText");
        COLORS.put(SystemColor.scrollbar, "SystemColor.scrollbar");
        COLORS.put(SystemColor.text, "SystemColor.text");
        COLORS.put(SystemColor.textHighlight, "SystemColor.textHighlight");
        COLORS.put(SystemColor.textHighlightText, "SystemColor.textHighlightText");
        COLORS.put(SystemColor.textInactiveText, "SystemColor.textInactiveText");
        COLORS.put(SystemColor.textText, "SystemColor.textText");
        COLORS.put(SystemColor.window, "SystemColor.window");
        COLORS.put(SystemColor.windowBorder, "SystemColor.windowBorder");
        COLORS.put(SystemColor.windowText, "SystemColor.windowText");
    }

    public static Color getColor(Object object) {
        Iterator iterator;
        if (object == null) {
            return null;
        }
        Set set = COLORS.keySet();
        Iterator iterator2 = iterator = set != null ? set.iterator() : null;
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (!object.equals(COLORS.get(k))) continue;
                return (Color)k;
            }
        }
        return null;
    }

    public static String getText(Color color) {
        return color != null ? (String)COLORS.get(color) : null;
    }

    public AWTColorComponent() {
        Listener listener = new Listener(null);
        this._combo = new JComboBox();
        this.populateComboBox();
        this._combo.addActionListener(listener);
        this._label = new JLabel();
        ResourceUtils.resLabel(this._label, this._combo, ControlsArb.getString(10));
        this.setLayout(new BorderLayout(5, 5));
        this.add("West", this._label);
        this.add("Center", this._combo);
    }

    public void addNotify() {
        super.addNotify();
        try {
            int n;
            FontMetrics fontMetrics = this._combo.getFontMetrics(this._combo.getFont());
            int n2 = 12;
            if (fontMetrics != null && (n = fontMetrics.getHeight() - fontMetrics.getLeading()) > 0) {
                n2 = n;
            }
            this._combo.setRenderer(new Renderer(n2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._label.setEnabled(bl);
        this._combo.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        String string = (String)COLORS.get(color);
        this._ignoreEvents = true;
        this._combo.setSelectedItem(string);
        this._ignoreEvents = false;
    }

    private void _updateColor(Color color) {
        this.storeColor(color);
    }

    private void populateComboBox() {
        this._combo.addItem("Color.black");
        this._combo.addItem("Color.blue");
        this._combo.addItem("Color.cyan");
        this._combo.addItem("Color.darkGray");
        this._combo.addItem("Color.gray");
        this._combo.addItem("Color.green");
        this._combo.addItem("Color.lightGray");
        this._combo.addItem("Color.magenta");
        this._combo.addItem("Color.orange");
        this._combo.addItem("Color.pink");
        this._combo.addItem("Color.red");
        this._combo.addItem("Color.white");
        this._combo.addItem("Color.yellow");
        this._combo.addItem("SystemColor.activeCaption");
        this._combo.addItem("SystemColor.activeCaptionBorder");
        this._combo.addItem("SystemColor.activeCaptionText");
        this._combo.addItem("SystemColor.control");
        this._combo.addItem("SystemColor.controlDkShadow");
        this._combo.addItem("SystemColor.controlHighlight");
        this._combo.addItem("SystemColor.controlShadow");
        this._combo.addItem("SystemColor.controlText");
        this._combo.addItem("SystemColor.desktop");
        this._combo.addItem("SystemColor.inactiveCaption");
        this._combo.addItem("SystemColor.inactiveCaptionBorder");
        this._combo.addItem("SystemColor.inactiveCaptionText");
        this._combo.addItem("SystemColor.info");
        this._combo.addItem("SystemColor.infoText");
        this._combo.addItem("SystemColor.menu");
        this._combo.addItem("SystemColor.menuText");
        this._combo.addItem("SystemColor.scrollbar");
        this._combo.addItem("SystemColor.text");
        this._combo.addItem("SystemColor.textHighlight");
        this._combo.addItem("SystemColor.textHighlightText");
        this._combo.addItem("SystemColor.textInactiveText");
        this._combo.addItem("SystemColor.textText");
        this._combo.addItem("SystemColor.window");
        this._combo.addItem("SystemColor.windowBorder");
        this._combo.addItem("SystemColor.windowText");
    }

    static boolean ra$_ignoreEvents(AWTColorComponent aWTColorComponent) {
        return aWTColorComponent._ignoreEvents;
    }

    static void mav$_updateColor(AWTColorComponent aWTColorComponent, Color color) {
        aWTColorComponent._updateColor(color);
    }

    private class Listener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!AWTColorComponent.ra$_ignoreEvents(AWTColorComponent.this)) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                AWTColorComponent.mav$_updateColor(AWTColorComponent.this, AWTColorComponent.getColor(jComboBox.getSelectedItem()));
            }
        }

        private Listener() {
        }

        Listener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private ColorIcon icon;

        public Renderer(int n) {
            this.icon = new ColorIcon(Color.black, n, n);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            Color color = Color.black;
            if (object != null && (color = AWTColorComponent.getColor(object.toString())) == null) {
                color = Color.black;
            }
            this.icon.setColor(color);
            this.setIcon(this.icon);
            return this;
        }
    }
}

