/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import oracle.ide.resource.ControlsArb;

public abstract class AbstractPicker
extends JComboBox
implements ActionListener {
    protected PickerResultValidator validator;
    protected PickerValueEncoder encoder;
    private boolean editing;

    void $init$() {
        this.validator = null;
        this.encoder = null;
        this.editing = false;
    }

    public AbstractPicker() {
        this.$init$();
        this.addItemListener(new 2());
        if (this.getEditor() != null) {
            Component component = this.getEditor().getEditorComponent();
            component.addFocusListener(new 1());
        }
    }

    public PickerResultValidator getValidator() {
        return this.validator;
    }

    public void setValidator(PickerResultValidator pickerResultValidator) {
        this.validator = pickerResultValidator;
    }

    public PickerValueEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PickerValueEncoder pickerValueEncoder) {
        this.encoder = pickerValueEncoder;
    }

    public Object getCurrentValue() {
        return this.getSelectedItem();
    }

    public Object getSelectedItem() {
        if (this.editing) {
            this.editFinished();
        }
        return super.getSelectedItem();
    }

    public void setCurrentValue(Object object) {
        this.setSelectedItem(object);
    }

    public void setSelectedItem(Object object) {
        Object object2 = this.getCurrentValue();
        this.addValue(object);
        super.setSelectedItem(object);
    }

    protected String getInvalidValueErrorTitle() {
        return ControlsArb.getString(11);
    }

    protected String getInvalidValueErrorHelpID() {
        return null;
    }

    public final void setBrowseResult(Object object) {
        if (object == null) {
            return;
        }
        if (this.validator == null || this.validator.isResultValid(object)) {
            Object object2 = this.encoder != null ? this.encoder.encodeValue(object) : object;
            this.setCurrentValue(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValue(Object object) {
        MutableComboBoxModel mutableComboBoxModel;
        if (object == null || object.toString().length() == 0) {
            return;
        }
        MutableComboBoxModel mutableComboBoxModel2 = mutableComboBoxModel = (MutableComboBoxModel)this.getModel();
        synchronized (mutableComboBoxModel2) {
            int n = 0;
            while (n < mutableComboBoxModel.getSize()) {
                if (mutableComboBoxModel.getElementAt(n).equals(object)) {
                    return;
                }
                ++n;
            }
            mutableComboBoxModel.addElement(object);
        }
    }

    private void editFinished() {
        this.editing = false;
        Object object = this.getEditor().getItem();
        this.setBrowseResult(object);
    }

    public void requestFocus() {
        if (this.isEditable()) {
            if (this.getEditor() != null) {
                this.getEditor().getEditorComponent().requestFocus();
            }
        } else {
            super.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.getEditor() != null && (object == this.getEditor() || object == this.getEditor().getEditorComponent())) {
            super.actionPerformed(actionEvent);
        } else {
            this.doBrowse();
        }
    }

    protected abstract void doBrowse();

    static boolean ra$editing(AbstractPicker abstractPicker) {
        return abstractPicker.editing;
    }

    static void mav$editFinished(AbstractPicker abstractPicker) {
        abstractPicker.editFinished();
    }

    static void wa$editing(AbstractPicker abstractPicker, boolean bl) {
        abstractPicker.editing = bl;
    }

    public final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (AbstractPicker.ra$editing(AbstractPicker.this)) {
                AbstractPicker.mav$editFinished(AbstractPicker.this);
            }
        }
    }

    public final class 1
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            AbstractPicker.wa$editing(AbstractPicker.this, true);
        }

        public void focusLost(FocusEvent focusEvent) {
            AbstractPicker.mav$editFinished(AbstractPicker.this);
        }
    }

    public interface PickerValueEncoder {
        public Object encodeValue(Object var1);
    }

    public interface PickerResultValidator {
        public boolean isResultValid(Object var1);

        public String getInvalidValueMsg(Object var1);
    }
}

