/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.PopupMenuListener;
import oracle.ide.controls.BaseToggleToolButton;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.MenuToolButton;
import oracle.ide.controls.MenuToolButtonUtils;
import oracle.ide.controls.RadioMenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToggleMenuItem;
import oracle.ide.controls.ToolButton;

public class ActionMenuToolButton
extends BaseToggleToolButton {
    protected static final Action[] NULL_ACTIONS = new Action[0];
    protected static final PopupMenuListener POPUP_MENU_LISTENER = MenuToolButton.POPUP_MENU_LISTENER;
    protected static final Icon POPUP_ICON = MenuToolButton.POPUP_ICON;
    protected static final int POPUP_WIDTH = Math.max(3 + POPUP_ICON.getIconWidth() + 3, 13);
    protected JPopupMenu _popup;
    private Image _capturedImage;

    public ActionMenuToolButton(Action action) {
        super(action);
        this.setHorizontalAlignment(2);
        ButtonCaptureAdapter buttonCaptureAdapter = new ButtonCaptureAdapter(null);
        this.addComponentListener(buttonCaptureAdapter);
        this.addMouseListener(buttonCaptureAdapter);
        this.addMouseMotionListener(buttonCaptureAdapter);
        this.addPropertyChangeListener(buttonCaptureAdapter);
    }

    public void setMenuActions(Action[] actionArray) {
        if (actionArray == null) {
            this.releasePopupMenu();
        } else {
            if (this._popup == null) {
                this.createPopupMenu();
            } else {
                this._popup.removeAll();
            }
            int n = 0;
            while (n < actionArray.length) {
                Action action = actionArray[n];
                if (action instanceof ToggleAction) {
                    ToggleAction toggleAction = (ToggleAction)action;
                    JMenuItem jMenuItem = toggleAction.isRadio() ? new RadioMenuItem(toggleAction) : (toggleAction.isToggle() ? new ToggleMenuItem(toggleAction) : new MenuItem(toggleAction));
                    this._popup.add(jMenuItem);
                } else if (action != null) {
                    this._popup.add(action);
                } else {
                    this._popup.addSeparator();
                }
                ++n;
            }
        }
    }

    protected ButtonModel createModel() {
        return new 2();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += POPUP_WIDTH + 1;
        return dimension;
    }

    public void updateUI() {
        super.updateUI();
        if (this._popup != null) {
            SwingUtilities.updateComponentTreeUI(this._popup);
        }
    }

    public void paint(Graphics graphics) {
        if (this._capturedImage != null && (this.isPopupVisible() || this.getModel().isPressed())) {
            graphics.drawImage(this._capturedImage, 0, 0, this);
            return;
        }
        this._capturedImage = null;
        super.paint(graphics);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.isEnabled() && (this.getModel().isRollover() || this.getModel().isSelected())) {
            int n3 = n - POPUP_WIDTH - 1;
            boolean bl = true;
            Color color = graphics.getColor();
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n3, 1, n3, n2 - 1 - 1);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n3 + 1, 1, n3 + 1, n2 - 1 - 1);
            graphics.setColor(color);
        }
        int n4 = -1;
        int n5 = n - 1 - (POPUP_WIDTH + POPUP_ICON.getIconWidth()) / 2 + -1;
        int n6 = (n2 - 1 - POPUP_ICON.getIconHeight()) / 2;
        POPUP_ICON.paintIcon(this, graphics, n5, n6);
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        this.setMenuActions(action != null ? (Action[])action.getValue("ActionMenuActions") : NULL_ACTIONS);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new 1(this, action);
    }

    protected ActionListener createActionListener() {
        return new FilterActionEvents(this);
    }

    protected JPopupMenu createPopupMenu() {
        if (this._popup != null) {
            this.releasePopupMenu();
        }
        this._popup = new JPopupMenu();
        this._popup.addPopupMenuListener(POPUP_MENU_LISTENER);
        this.invalidate();
        return this._popup;
    }

    protected void releasePopupMenu() {
        if (this._popup != null) {
            this._popup.removePopupMenuListener(POPUP_MENU_LISTENER);
            this._popup = null;
            this.invalidate();
        }
    }

    protected boolean hasPopup() {
        return this._popup != null;
    }

    protected boolean isPopupVisible() {
        return this._popup != null && this._popup.isVisible();
    }

    static void wa$_capturedImage(ActionMenuToolButton actionMenuToolButton, Image image) {
        actionMenuToolButton._capturedImage = image;
    }

    static Image ra$_capturedImage(ActionMenuToolButton actionMenuToolButton) {
        return actionMenuToolButton._capturedImage;
    }

    static void mav$fireActionPerformed(ActionMenuToolButton actionMenuToolButton, ActionEvent actionEvent) {
        actionMenuToolButton.fireActionPerformed(actionEvent);
    }

    public final class 2
    extends JToggleButton.ToggleButtonModel {
        public boolean isSelected() {
            return ActionMenuToolButton.this.isPopupVisible();
        }

        public void setPressed(boolean bl) {
            super.setPressed(bl);
            if (!bl && !ActionMenuToolButton.this.isPopupVisible()) {
                ActionMenuToolButton.wa$_capturedImage(ActionMenuToolButton.this, null);
            }
        }
    }

    public final class 1
    extends ToolButton.DefaultActionPropertyChangeListener {
        protected void _propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("ActionMenuActions")) {
                this.menuActionsChanged(propertyChangeEvent);
            } else {
                super._propertyChange(propertyChangeEvent);
            }
        }

        protected void menuActionsChanged(PropertyChangeEvent propertyChangeEvent) {
            Action[] actionArray = (Action[])propertyChangeEvent.getNewValue();
            ActionMenuToolButton actionMenuToolButton = (ActionMenuToolButton)this.getAdaptee();
            actionMenuToolButton.setMenuActions(actionArray != null ? actionArray : NULL_ACTIONS);
        }

        public 1(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }
    }

    protected static class FilterActionEvents
    implements Serializable,
    ActionListener {
        private ActionMenuToolButton _button;

        public FilterActionEvents(ActionMenuToolButton actionMenuToolButton) {
            this._button = actionMenuToolButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.canPerformAction()) {
                ActionMenuToolButton.mav$fireActionPerformed(this._button, actionEvent);
            }
        }

        protected boolean canPerformAction() {
            return !this._button.isPopupVisible() && ActionMenuToolButton.ra$_capturedImage(this._button) == null;
        }
    }

    private static final class ButtonCaptureAdapter
    implements PropertyChangeListener,
    ComponentListener,
    MouseInputListener {
        private BufferedImage _buttonImage;
        private boolean _captured;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!this._captured) {
                this.captureButtonImage(mouseEvent);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.mouseEntered(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ActionMenuToolButton actionMenuToolButton = (ActionMenuToolButton)mouseEvent.getComponent();
            if (actionMenuToolButton._popup.getComponentCount() > 0 && this.isInPopup(mouseEvent)) {
                if (!this._captured) {
                    this.capturePopupImage(mouseEvent);
                }
                ActionMenuToolButton.wa$_capturedImage(actionMenuToolButton, this._captured ? this._buttonImage : null);
                MenuToolButtonUtils.showComponentPopupMenu(actionMenuToolButton, actionMenuToolButton._popup);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.uncaptureImage(componentEvent);
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.uncaptureImage(componentEvent);
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.uncaptureImage(componentEvent);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("icon") || string.equals("foreground") || string.equals("background") || string.equals("border") || string.equals("opaque") || string.equals("contentAreaFilled") || string.equals("borderPainted") || string.equals("rolloverEnabled") || string.equals("rolloverIcon") || string.equals("UI")) {
                this.uncaptureImage(propertyChangeEvent);
            }
        }

        private void captureButtonImage(EventObject eventObject) {
            AbstractButton abstractButton = (AbstractButton)eventObject.getSource();
            if (abstractButton.isEnabled() && abstractButton.isRolloverEnabled()) {
                BufferedImage bufferedImage = this.getBufferedImage(abstractButton);
                if (!abstractButton.getModel().isRollover()) {
                    abstractButton.getModel().setRollover(true);
                }
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setClip(0, 0, abstractButton.getWidth() - POPUP_WIDTH, abstractButton.getHeight());
                abstractButton.paintAll(graphics2D);
                graphics2D.dispose();
            }
        }

        private void capturePopupImage(EventObject eventObject) {
            AbstractButton abstractButton = (AbstractButton)eventObject.getSource();
            if (abstractButton.isEnabled() && abstractButton.isRolloverEnabled()) {
                BufferedImage bufferedImage = this.getBufferedImage(abstractButton);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setClip(abstractButton.getWidth() - POPUP_WIDTH, 0, POPUP_WIDTH, abstractButton.getHeight());
                abstractButton.paintAll(graphics2D);
                graphics2D.dispose();
                this._captured = true;
            }
        }

        private void uncaptureImage(EventObject eventObject) {
            ActionMenuToolButton actionMenuToolButton = (ActionMenuToolButton)eventObject.getSource();
            ActionMenuToolButton.wa$_capturedImage(actionMenuToolButton, null);
            this._captured = false;
        }

        private BufferedImage getBufferedImage(AbstractButton abstractButton) {
            if (this._buttonImage == null) {
                this._buttonImage = new BufferedImage(abstractButton.getWidth(), abstractButton.getHeight(), 2);
            }
            return this._buttonImage;
        }

        private boolean isInPopup(MouseEvent mouseEvent) {
            ActionMenuToolButton actionMenuToolButton = (ActionMenuToolButton)mouseEvent.getComponent();
            return SwingUtilities.isLeftMouseButton(mouseEvent) && actionMenuToolButton.isEnabled() && actionMenuToolButton.hasPopup() && actionMenuToolButton.contains(mouseEvent.getX(), mouseEvent.getY()) && mouseEvent.getX() >= actionMenuToolButton.getWidth() - POPUP_WIDTH;
        }

        private ButtonCaptureAdapter() {
        }

        ButtonCaptureAdapter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

