/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

public class ButtonsLayoutManager
implements SwingConstants,
LayoutManager2 {
    public static final boolean DIRECTION_RTL = true;
    public static final boolean DIRECTION_LTR = false;
    private static int DEFAULTGAP = 0;
    private int _nGap;
    private ArrayList _buttons;
    private int _nOrient;
    private boolean _rtl;
    private Rectangle _rSpaceLeft;

    void $init$() {
        this._nGap = DEFAULTGAP;
        this._buttons = new ArrayList(2);
        this._nOrient = 0;
        this._rtl = true;
        this._rSpaceLeft = new Rectangle();
    }

    public ButtonsLayoutManager() {
        this(0);
    }

    public ButtonsLayoutManager(int n) {
        this.$init$();
        this.setGap(n);
    }

    public void setGap(int n) {
        this._nGap = n;
    }

    public int getGap() {
        return this._nGap;
    }

    public void setDirection(boolean bl) {
        this._rtl = bl;
    }

    public boolean getDirection() {
        return this._rtl;
    }

    public Rectangle getSpaceLeft() {
        return this._rSpaceLeft;
    }

    public void setOrientation(int n) {
        this._nOrient = n;
    }

    public int getOrientation() {
        return this._nOrient;
    }

    private Dimension getOrientedDimension(int n, int n2) {
        if (this._nOrient == 1) {
            return new Dimension(n2, n);
        }
        return new Dimension(n, n2);
    }

    public final int getButtonCount() {
        return this._buttons.size();
    }

    public final Component getButton(int n) {
        Component component = n >= 0 && n < this._buttons.size() ? (Component)this._buttons.get(n) : null;
        return component;
    }

    protected final void addButton(Component component, int n) {
        int n2 = this._buttons.size();
        while (n2 < n) {
            this._buttons.add(null);
            ++n2;
        }
        this._buttons.add(n, component);
    }

    protected final void removeButton(int n) {
        if (n >= 0 && n < this._buttons.size()) {
            this._buttons.remove(n);
        }
    }

    public void addLayoutComponent(String string, Component component) {
        Integer n = new Integer(string);
        this.addLayoutComponent(component, n);
    }

    public void removeLayoutComponent(Component component) {
        this._buttons.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        int n3 = this._buttons.size();
        int n4 = n3 - 1;
        while (n4 >= 0) {
            JComponent jComponent = (JComponent)this._buttons.get(n4);
            if (jComponent != null && jComponent.isVisible()) {
                Dimension dimension = jComponent.getPreferredSize();
                if (this._nOrient == 1) {
                    n2 += dimension.height + this._nGap;
                    if (dimension.width > n) {
                        n = dimension.width;
                    }
                } else {
                    n += dimension.width + this._nGap;
                    if (dimension.height > n2) {
                        n2 = dimension.height;
                    }
                }
            }
            --n4;
        }
        return new Dimension(n, n2);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        this.layoutContainer(container, dimension);
    }

    protected int layoutContainer(Container container, Dimension dimension) {
        int n = this._buttons.size();
        int n2 = 0;
        this._rSpaceLeft.setBounds(0, 0, dimension.width, dimension.height);
        if (this._nOrient == 1) {
            int n3 = dimension.width / 2;
            int n4 = 0;
            n2 = 0;
            while (n2 < n) {
                JComponent jComponent = (JComponent)this._buttons.get(n2);
                if (jComponent != null && jComponent.isVisible()) {
                    Dimension dimension2 = jComponent.getPreferredSize();
                    if (n4 + dimension2.height > dimension.height) break;
                    jComponent.setBounds(n3 - dimension2.width / 2, n4, dimension2.width, dimension2.height);
                    n4 += dimension2.height + this._nGap;
                }
                ++n2;
            }
            this._rSpaceLeft.y = n4;
            this._rSpaceLeft.height = dimension.height - n4;
        } else if (this._rtl) {
            int n5 = dimension.width;
            int n6 = dimension.height / 2;
            n2 = 0;
            while (n2 < n) {
                JComponent jComponent = (JComponent)this._buttons.get(n2);
                if (jComponent != null && jComponent.isVisible()) {
                    Dimension dimension3 = jComponent.getPreferredSize();
                    if (n5 - dimension3.width < 0) break;
                    jComponent.setBounds(n5 - dimension3.width, n6 - dimension3.height / 2, dimension3.width, dimension3.height);
                    n5 -= dimension3.width + this._nGap;
                }
                ++n2;
            }
            this._rSpaceLeft.width = n5;
        } else {
            int n7 = 0;
            int n8 = dimension.height / 2;
            n2 = 0;
            while (n2 < n) {
                JComponent jComponent = (JComponent)this._buttons.get(n2);
                if (jComponent != null && jComponent.isVisible()) {
                    Dimension dimension4 = jComponent.getPreferredSize();
                    if (n7 + dimension4.width > dimension.width) break;
                    jComponent.setBounds(n7, n8 - dimension4.height / 2, dimension4.width, dimension4.height);
                    n7 += dimension4.width + this._nGap;
                }
                ++n2;
            }
            this._rSpaceLeft.x = n7;
            this._rSpaceLeft.width = dimension.width - n7;
        }
        int n9 = n2;
        while (n9 < n) {
            JComponent jComponent = (JComponent)this._buttons.get(n9);
            if (jComponent != null) {
                jComponent.setBounds(0, 0, 0, 0);
            }
            ++n9;
        }
        if (container instanceof JComponent) {
            JComponent jComponent = (JComponent)container;
            jComponent.repaint();
        }
        return n2;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof Integer)) {
            throw new IllegalArgumentException("ButtonsLayoutManager must be used with Integer constraints");
        }
        int n = (Integer)object;
        this.addButton(component, n);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public float getLayoutAlignmentX(Container container) {
        return 1.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }
}

