/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.config.ChangeEventSource;

public abstract class ChangeAdaptor
implements ChangeListener {
    private static ReferenceQueue _queue = new ReferenceQueue();
    private WeakAbstractButton _adapteeReference;

    public ChangeAdaptor(AbstractButton abstractButton, ChangeEventSource changeEventSource) {
        ChangeAdaptor.clearQueue();
        this._adapteeReference = new WeakAbstractButton(abstractButton, changeEventSource, this, _queue);
    }

    private static void clearQueue() {
        Reference reference;
        while ((reference = _queue.poll()) != null) {
            WeakAbstractButton weakAbstractButton = (WeakAbstractButton)reference;
            weakAbstractButton.clearReference();
        }
    }

    protected AbstractButton getAdaptee() {
        ChangeAdaptor.clearQueue();
        return (AbstractButton)this._adapteeReference.get();
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        ChangeAdaptor.clearQueue();
        if (!this.isDead()) {
            this._stateChanged(changeEvent);
        }
    }

    private boolean isDead() {
        return this._adapteeReference.get() == null;
    }

    protected abstract void _stateChanged(ChangeEvent var1);

    public static class WeakAbstractButton
    extends WeakReference {
        protected ChangeListener _listener;
        protected ChangeEventSource _changeEventSource;

        public WeakAbstractButton(AbstractButton abstractButton, ChangeEventSource changeEventSource, ChangeListener changeListener, ReferenceQueue referenceQueue) {
            super(abstractButton, referenceQueue);
            this._changeEventSource = changeEventSource;
            this._listener = changeListener;
        }

        protected void clearReference() {
            this._changeEventSource.removeChangeListener(this._listener);
        }
    }
}

