/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.accessibility.AccessibleContext;
import javax.swing.JLabel;
import javax.swing.JTable;
import oracle.javatools.clipboard.ClipboardStack;

public class CopyableJTableAdapter {
    private final JTable _table;
    private String _nullValue;

    void $init$() {
        this._nullValue = "(null)";
    }

    public CopyableJTableAdapter(JTable jTable) {
        this.$init$();
        this._table = jTable;
    }

    public void setNullString(String string) {
        this._nullValue = string;
    }

    public String getNullString() {
        return this._nullValue;
    }

    public boolean canCopy() {
        return CopyableJTableAdapter.isSelectionSizeOk(this._table.getSelectedRowCount(), this._table.getSelectedRows()) && (this._table.getRowSelectionAllowed() || CopyableJTableAdapter.isSelectionSizeOk(this._table.getSelectedColumnCount(), this._table.getSelectedColumns()));
    }

    public boolean copyToClipboard() {
        int n = this._table.getSelectedRowCount();
        int[] nArray = this._table.getSelectedRows();
        int n2 = 0;
        int[] nArray2 = null;
        if (this._table.getRowSelectionAllowed()) {
            n2 = this._table.getColumnCount();
            nArray2 = CopyableJTableAdapter._getColumnList(this._table);
        } else {
            n2 = this._table.getSelectedColumnCount();
            nArray2 = this._table.getSelectedColumns();
        }
        StringBuffer stringBuffer = new StringBuffer(n * n2 * 10);
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                String string;
                Object object = this._table.getValueAt(nArray[n3], nArray2[n4]);
                if (object instanceof JLabel) {
                    AccessibleContext accessibleContext;
                    JLabel jLabel = (JLabel)object;
                    string = jLabel.getText();
                    if (!(string != null && string.length() != 0 || (string = (accessibleContext = jLabel.getAccessibleContext()).getAccessibleName()) != null && string.length() != 0)) {
                        string = accessibleContext.getAccessibleDescription();
                    }
                } else {
                    string = object != null ? object.toString() : this._nullValue;
                }
                stringBuffer.append(string);
                if (n4 < n2 - 1) {
                    stringBuffer.append("\t");
                }
                ++n4;
            }
            stringBuffer.append("\n");
            ++n3;
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        ClipboardStack.pushCurrentClipboard();
        clipboard.setContents(stringSelection, stringSelection);
        return true;
    }

    public static boolean isSelectionSizeOk(int n, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        int n2 = nArray[nArray.length - 1] - nArray[0];
        return n - 1 == n2 && n == nArray.length;
    }

    private static int[] _getColumnList(JTable jTable) {
        if (jTable == null) {
            return new int[0];
        }
        int n = jTable.getColumnCount();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return nArray;
    }
}

