/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultListTableModel
extends AbstractTableModel
implements Serializable {
    protected ArrayList dataList;
    protected ArrayList columnIdentifiers;
    private boolean _isEditable;

    void $init$() {
        this._isEditable = true;
    }

    public DefaultListTableModel() {
        this((List)null, 0);
    }

    public DefaultListTableModel(int n, int n2) {
        this.$init$();
        ArrayList arrayList = new ArrayList(n2);
        DefaultListTableModel.ensureCapacityHelper(arrayList, n2);
        this.setColumnIdentifiers(arrayList);
        this.dataList = new ArrayList();
        this.setNumRows(n);
    }

    public DefaultListTableModel(List list, int n) {
        this.$init$();
        this.setColumnIdentifiers(list);
        this.dataList = new ArrayList();
        this.setNumRows(n);
    }

    public DefaultListTableModel(Object[] objectArray, int n) {
        this(DefaultListTableModel.convertToList(objectArray), n);
    }

    public DefaultListTableModel(List list, List list2) {
        this.$init$();
        this.setDataList(list, list2);
    }

    public DefaultListTableModel(Object[][] objectArray, Object[] objectArray2) {
        this.$init$();
        this.setDataList(objectArray, objectArray2);
    }

    public List getDataList() {
        return this.dataList;
    }

    public void setDataList(List list, List list2) {
        if (list == null) {
            throw new IllegalArgumentException("setDataList() - Null parameter");
        }
        this.dataList = new ArrayList(0);
        this.setColumnIdentifiers(list2);
        this.dataList.addAll(list);
        this.newRowsAdded(new TableModelEvent(this, 0, this.getRowCount() - 1, -1, 1));
    }

    public void setDataList(Object[][] objectArray, Object[] objectArray2) {
        this.setDataList(DefaultListTableModel.convertToList(objectArray), DefaultListTableModel.convertToList(objectArray2));
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = this.getRowCount() - 1;
        }
        int n3 = n;
        while (n3 < n2) {
            List list = (List)this.dataList.get(n3);
            DefaultListTableModel.ensureCapacityHelper(list, this.getColumnCount());
            ++n3;
        }
        this.fireTableChanged(tableModelEvent);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void setColumnIdentifiers(List list) {
        this.columnIdentifiers = new ArrayList();
        if (list != null) {
            this.columnIdentifiers.clear();
            this.columnIdentifiers.addAll(list);
        }
        this.fireTableStructureChanged();
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultListTableModel.convertToList(objectArray));
    }

    public void setNumRows(int n) {
        if (n < 0 || n == this.getRowCount()) {
            return;
        }
        int n2 = this.getRowCount();
        if (n <= this.getRowCount()) {
            DefaultListTableModel.ensureCapacityHelper(this.dataList, n);
            this.fireTableRowsDeleted(this.getRowCount(), n2 - 1);
        } else {
            int n3 = this.getColumnCount();
            while (this.getRowCount() < n) {
                ArrayList arrayList = new ArrayList(n3);
                DefaultListTableModel.ensureCapacityHelper(arrayList, n3);
                this.dataList.add(arrayList);
            }
            this.fireTableRowsInserted(n2, this.getRowCount() - 1);
        }
    }

    public void setRowCount(int n) {
        this.setNumRows(n);
    }

    public void setColumnCount(int n) {
        int n2 = 0;
        while (n2 < this.getRowCount()) {
            ArrayList arrayList = (ArrayList)this.dataList.get(n2);
            DefaultListTableModel.ensureCapacityHelper(arrayList, n);
            ++n2;
        }
        DefaultListTableModel.ensureCapacityHelper(this.columnIdentifiers, n);
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object) {
        this.addColumn(object, (List)null);
    }

    public void addColumn(Object object, List list) {
        if (object == null) {
            throw new IllegalArgumentException("addColumn() - null parameter");
        }
        this.columnIdentifiers.add(object);
        int n = 0;
        Iterator iterator = this.dataList.iterator();
        while (iterator.hasNext()) {
            Object e = list != null && n < list.size() ? (Object)list.get(n) : null;
            ((List)iterator.next()).add(e);
            ++n;
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object, Object[] objectArray) {
        this.addColumn(object, DefaultListTableModel.convertToList(objectArray));
    }

    public void addRow(List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList(this.getColumnCount());
        } else {
            DefaultListTableModel.ensureCapacityHelper(arrayList, this.getColumnCount());
        }
        this.dataList.add(arrayList);
        this.newRowsAdded(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
    }

    public void addRow(Object[] objectArray) {
        this.addRow(DefaultListTableModel.convertToList(objectArray));
    }

    public void insertRow(int n, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList(this.getColumnCount());
        } else {
            DefaultListTableModel.ensureCapacityHelper(arrayList, this.getColumnCount());
        }
        this.dataList.add(n, arrayList);
        this.newRowsAdded(new TableModelEvent(this, n, n, -1, 1));
    }

    public void insertRow(int n, Object[] objectArray) {
        this.insertRow(n, DefaultListTableModel.convertToList(objectArray));
    }

    public void moveRow(int n, int n2, int n3) {
        if (n < 0 || n >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n2 < 0 || n2 >= this.getRowCount()) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n <= n3 && n3 <= n2) {
            return;
        }
        boolean bl = n3 < n;
        int n4 = n;
        while (n4 <= n2) {
            Object e = this.dataList.get(n4);
            this.dataList.remove(n4);
            this.dataList.add(n3, e);
            if (bl) {
                ++n3;
            }
            ++n4;
        }
        this.fireTableDataChanged();
    }

    public void removeRow(int n) {
        this.dataList.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public int getRowCount() {
        return this.dataList.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int n) {
        if (this.columnIdentifiers == null || this.columnIdentifiers.size() <= n) {
            return super.getColumnName(n);
        }
        Object e = this.columnIdentifiers.get(n);
        if (e == null) {
            return super.getColumnName(n);
        }
        return e.toString();
    }

    public boolean isCellEditable(int n, int n2) {
        return this._isEditable;
    }

    public void setEditable(boolean bl) {
        this._isEditable = bl;
    }

    public boolean isEditable() {
        return this._isEditable;
    }

    public Object getValueAt(int n, int n2) {
        List list = (List)this.dataList.get(n);
        return list.get(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        List list = (List)this.dataList.get(n);
        list.set(n2, object);
        this.fireTableChanged(new TableModelEvent(this, n, n, n2));
    }

    protected static List convertToList(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n]);
            ++n;
        }
        return arrayList;
    }

    protected static List convertToList(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<List> arrayList = new ArrayList<List>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(DefaultListTableModel.convertToList(objectArray[n]));
            ++n;
        }
        return arrayList;
    }

    private static void ensureCapacityHelper(List list, int n) {
    }
}

