/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import oracle.ide.controls.FocusHierarchyEvent;
import oracle.ide.controls.FocusHierarchyListener;

public final class FocusHierarchyDispatcher
implements AWTEventListener {
    private static final boolean DEBUG = false;
    private ArrayList _listeners;
    private static FocusHierarchyDispatcher INSTANCE;

    void $init$() {
        this._listeners = new ArrayList(5);
    }

    private FocusHierarchyDispatcher() {
        this.$init$();
    }

    public synchronized void install() {
        this.uninstall();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this, 4);
    }

    public void uninstall() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this);
    }

    public static synchronized FocusHierarchyDispatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FocusHierarchyDispatcher();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFocusHierarchyListener(FocusHierarchyListener focusHierarchyListener) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            WeakReference<FocusHierarchyListener> weakReference = new WeakReference<FocusHierarchyListener>(focusHierarchyListener);
            this._listeners.add(weakReference);
            int n = this._listeners.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                WeakReference weakReference2 = (WeakReference)this._listeners.get(n2);
                if (weakReference2.get() == null) {
                    this._listeners.remove(n2);
                }
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFocusHierarchyListener(FocusHierarchyListener focusHierarchyListener) {
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            int n = this._listeners.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                WeakReference weakReference = (WeakReference)this._listeners.get(n2);
                if (weakReference.get() == focusHierarchyListener) {
                    this._listeners.remove(n2);
                    break;
                }
                --n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDispatched(AWTEvent aWTEvent) {
        FocusEvent focusEvent = (FocusEvent)aWTEvent;
        ArrayList arrayList = this._listeners;
        synchronized (arrayList) {
            FocusHierarchyEvent focusHierarchyEvent = new FocusHierarchyEvent(focusEvent);
            int n = this._listeners.size();
            WeakReference[] weakReferenceArray = this._listeners.toArray(new WeakReference[n]);
            int n2 = 0;
            while (n2 < n) {
                FocusHierarchyListener focusHierarchyListener = (FocusHierarchyListener)weakReferenceArray[n2].get();
                if (focusHierarchyListener != null) {
                    switch (focusEvent.getID()) {
                        case 1004: {
                            focusHierarchyListener.focusGained(focusHierarchyEvent);
                            break;
                        }
                        case 1005: {
                            focusHierarchyListener.focusLost(focusHierarchyEvent);
                        }
                    }
                }
                ++n2;
            }
        }
    }
}

