/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JDesktopPane;
import oracle.ide.docking.DockableContainer;

public class FocusHierarchyEvent
extends AWTEvent {
    public static int FOCUS_HIERARCHY_GAINED = 3708;
    public static int FOCUS_HIERARCHY_LOST = 3709;
    public static int FOCUS_HIERARCHY_FIRST = FOCUS_HIERARCHY_GAINED;
    public static int FOCUS_HIERARCHY_LAST = FOCUS_HIERARCHY_LOST;
    private static int IDE_CONTAINER_UNDEF = -1;
    public static int IDE_CONTAINER_UNKNOWN = 0;
    public static int IDE_CONTAINER_EDITOR = 1;
    public static int IDE_CONTAINER_DOCKABLE = 2;
    private ArrayList _hierarchy;
    private HashSet _set;
    private boolean _bIsTemporary;
    private int _ideContainerType;

    void $init$() {
        this._ideContainerType = -1;
    }

    public FocusHierarchyEvent(FocusEvent focusEvent) {
        super(focusEvent.getSource(), focusEvent.getID() == 1004 ? FOCUS_HIERARCHY_GAINED : FOCUS_HIERARCHY_LOST);
        this.$init$();
        this.buildHierarchy(focusEvent.getComponent());
        this._bIsTemporary = focusEvent.isTemporary();
    }

    private void buildHierarchy(Component component) {
        ArrayList<Component> arrayList = new ArrayList<Component>(10);
        while (component != null) {
            arrayList.add(component);
            component = component instanceof Window ? null : component.getParent();
        }
        this.setHierarchy(arrayList);
    }

    public ArrayList getHierarchy() {
        return this._hierarchy;
    }

    private void setHierarchy(ArrayList arrayList) {
        this._hierarchy = arrayList;
        this._set = new HashSet(this._hierarchy);
    }

    public boolean isTemporary() {
        return this._bIsTemporary;
    }

    public boolean contains(Component component) {
        return this._set.contains(component);
    }

    public Window top() {
        int n;
        Component component;
        Window window = null;
        if (!this._hierarchy.isEmpty() && (component = (Component)this._hierarchy.get((n = this._hierarchy.size()) - 1)) instanceof Window) {
            window = (Window)component;
        }
        return window;
    }

    public int getIdeContainerType() {
        if (this._ideContainerType == IDE_CONTAINER_UNDEF) {
            int n = this._hierarchy.size();
            int n2 = 0;
            while (n2 < n) {
                Component component = (Component)this._hierarchy.get(n2);
                if (component instanceof JDesktopPane) {
                    this._ideContainerType = IDE_CONTAINER_EDITOR;
                    break;
                }
                if (component instanceof DockableContainer) {
                    this._ideContainerType = IDE_CONTAINER_DOCKABLE;
                    break;
                }
                ++n2;
            }
            if (this._ideContainerType == IDE_CONTAINER_UNDEF) {
                this._ideContainerType = IDE_CONTAINER_UNKNOWN;
            }
        }
        return this._ideContainerType;
    }
}

