/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.util.SwingUtils;

public class FocusableLabel
extends JComponent
implements Accessible,
MouseListener {
    private String _sText;
    private Rectangle2D _rText;

    public FocusableLabel() {
        this.init(null);
    }

    public FocusableLabel(String string) {
        this.init(string);
    }

    private void init(String string) {
        this.setText(string);
        this.setBackground((Color)UIManager.get("window"));
        this.setForeground((Color)UIManager.get("textText"));
        this.addMouseListener(this);
    }

    public void setText(String string) {
        String string2 = null;
        if (this.accessibleContext != null) {
            string2 = this.accessibleContext.getAccessibleName();
        }
        String string3 = this._sText;
        this._sText = string;
        this._rText = null;
        this.firePropertyChange("text", string3, string);
        if (this.accessibleContext != null && this.accessibleContext.getAccessibleName() != string2) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, this.accessibleContext.getAccessibleName());
        }
        this.revalidate();
        this.repaint();
    }

    public String getText() {
        return this._sText;
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            String string = this.getText();
            int n = fontMetrics.stringWidth(string);
            int n2 = fontMetrics.getHeight();
            Insets insets = this.getInsets();
            Dimension dimension = new Dimension(insets.left + n + insets.right, insets.top + n2 + insets.bottom);
            this.setPreferredSize(dimension);
        }
        return super.getPreferredSize();
    }

    public void addNotify() {
        super.addNotify();
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    private Rectangle2D getTextBounds(Graphics2D graphics2D) {
        if (this._rText == null) {
            Font font = graphics2D.getFont();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout(this._sText, font, fontRenderContext);
            this._rText = textLayout.getBounds();
        }
        return this._rText;
    }

    public boolean isFocusable() {
        return true;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFocusableLabel();
        }
        return this.accessibleContext;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        graphics2D.setColor(this.getBackground());
        graphics2D.fillRect(insets.left, insets.top, dimension.width, dimension.height);
        Rectangle2D rectangle2D = this.getTextBounds(graphics2D);
        float f = (float)(((double)dimension.width - rectangle2D.getWidth()) / 2.0);
        float f2 = (float)(((double)dimension.height - rectangle2D.getHeight()) / 2.0 - rectangle2D.getY());
        graphics2D.setColor(this.getBackground().darker());
        SwingUtils.drawString((Graphics2D)graphics2D, (String)this._sText, (float)(f + (float)insets.left), (float)(f2 + (float)insets.right));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isFocusable()) {
            this.requestFocus();
            mouseEvent.consume();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected class AccessibleFocusableLabel
    extends JComponent.AccessibleJComponent {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (FocusableLabel.this.getText() == null) {
                return super.getAccessibleName();
            }
            return FocusableLabel.this.getText();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        protected AccessibleFocusableLabel() {
            super(FocusableLabel.this);
        }
    }
}

