/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public final class GlobalMouseDispatcher
implements AWTEventListener {
    private ArrayList _listeners;
    private static GlobalMouseDispatcher INSTANCE;

    void $init$() {
        this._listeners = new ArrayList(5);
    }

    private GlobalMouseDispatcher() {
        this.$init$();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this, 16);
    }

    public static synchronized GlobalMouseDispatcher getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GlobalMouseDispatcher();
        }
        return INSTANCE;
    }

    public void addMouseListener(MouseListener mouseListener) {
        this._listeners.add(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this._listeners.remove(mouseListener);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Point point;
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        Component component = mouseEvent.getComponent();
        Component component2 = this.getDeepestComponent(component, point = new Point(mouseEvent.getPoint()));
        if (component2 != component) {
            mouseEvent = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
        }
        MouseListener[] mouseListenerArray = new MouseListener[this._listeners.size()];
        this._listeners.toArray(mouseListenerArray);
        int n = 0;
        while (n < mouseListenerArray.length) {
            MouseListener mouseListener = mouseListenerArray[n];
            if (mouseListener != null) {
                switch (mouseEvent.getID()) {
                    case 500: {
                        mouseListener.mouseClicked(mouseEvent);
                        break;
                    }
                    case 504: {
                        mouseListener.mouseEntered(mouseEvent);
                        break;
                    }
                    case 505: {
                        mouseListener.mouseExited(mouseEvent);
                        break;
                    }
                    case 501: {
                        mouseListener.mousePressed(mouseEvent);
                        break;
                    }
                    case 502: {
                        mouseListener.mouseReleased(mouseEvent);
                    }
                }
            }
            ++n;
        }
    }

    private Component getDeepestComponent(Component component, Point point) {
        while (component instanceof Container) {
            Container container = (Container)component;
            Component component2 = container.getComponentAt(point);
            if (component2 == component || component2 == null) break;
            SwingUtilities.convertPoint(component, point, component2);
            component = component2;
        }
        return component;
    }
}

