/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ItemSelectableTracker
implements ItemListener {
    private ItemSelectable item;
    protected Component[] components;
    protected ItemSelectableTracker[] trackers;
    private boolean sameEnabledState;

    public ItemSelectableTracker(ItemSelectable itemSelectable, Component[] componentArray) {
        this(itemSelectable, componentArray, null, true);
    }

    public ItemSelectableTracker(ItemSelectable itemSelectable, Component[] componentArray, ItemSelectableTracker[] itemSelectableTrackerArray) {
        this(itemSelectable, componentArray, itemSelectableTrackerArray, true);
    }

    public ItemSelectableTracker(ItemSelectable itemSelectable, Component[] componentArray, boolean bl) {
        this(itemSelectable, componentArray, null, bl);
    }

    private ItemSelectableTracker(ItemSelectable itemSelectable, Component[] componentArray, ItemSelectableTracker[] itemSelectableTrackerArray, boolean bl) {
        this.item = itemSelectable;
        this.components = componentArray;
        this.trackers = itemSelectableTrackerArray;
        this.sameEnabledState = bl;
        itemSelectable.addItemListener(this);
        Object[] objectArray = this.item.getSelectedObjects();
        boolean bl2 = objectArray != null;
        this.updateItemState(bl2);
    }

    public final void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.item) {
            int n = itemEvent.getStateChange();
            boolean bl = n == 1;
            this.updateItemState(bl);
        }
    }

    private void updateItemState(boolean bl) {
        boolean bl2 = this.sameEnabledState ? bl : bl ^ true;
        int n = this.components == null ? 0 : this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = this.components[n2];
            if (component != null) {
                component.setEnabled(bl2);
            }
            ++n2;
        }
        int n3 = this.trackers == null ? 0 : this.trackers.length;
        int n4 = 0;
        while (n4 < n3) {
            Object[] objectArray;
            ItemSelectableTracker itemSelectableTracker = this.trackers[n4];
            ItemSelectable itemSelectable = itemSelectableTracker.item;
            if (itemSelectable instanceof Component) {
                ((Component)((Object)itemSelectable)).setEnabled(bl2);
            }
            boolean bl3 = (objectArray = itemSelectable.getSelectedObjects()) != null && bl2;
            itemSelectableTracker.updateItemState(bl3);
            ++n4;
        }
        if (bl) {
            this.itemSelected(this.item);
        } else {
            this.itemDeselected(this.item);
        }
    }

    protected void itemSelected(ItemSelectable itemSelectable) {
    }

    protected void itemDeselected(ItemSelectable itemSelectable) {
    }
}

