/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.GridBagConstants;

public class JComboCardPanel
extends JPanel
implements GridBagConstants {
    private final JPanel _titlePanel;
    private final JPanel _cardPanel;
    private final ComboCardLayout _cardLayout;
    private int _curIndex;

    void $init$() {
        this._titlePanel = new JPanel();
        this._cardPanel = new JPanel();
    }

    public JComboCardPanel(JLabel jLabel, JComponent jComponent) {
        this.$init$();
        if (jComponent == null) {
            throw new IllegalArgumentException("Combo box must not be null.");
        }
        this._titlePanel.setLayout(new GridBagLayout());
        if (jLabel != null) {
            this._titlePanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        this._titlePanel.add((Component)jComponent, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        int n = JComboCardPanel.getJComponentHeight(jLabel);
        int n2 = JComboCardPanel.getJComponentHeight(jComponent);
        int n3 = Math.max(n, n2) / 2;
        if (n < n2 && n % 2 == 1 && n2 % 2 == 0) {
            --n3;
        }
        this._cardLayout = new ComboCardLayout(n3, 0, 0, 0);
        this._cardPanel.setLayout(this._cardLayout);
        this._cardPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.setLayout(new GridBagLayout());
        this.add((Component)this._titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this._cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(n3, 0, 0, 0), 0, 0));
    }

    public void showSubPanel(JComponent jComponent) {
        Object object = jComponent.getClientProperty("combo-card-panel-key");
        if (object == null) {
            object = new Integer(this._curIndex++);
            jComponent.putClientProperty("combo-card-panel-key", object);
            this._cardPanel.add((Component)jComponent, object.toString());
        }
        this._cardLayout.show(this._cardPanel, object.toString());
    }

    public static int getJComponentHeight(JComponent jComponent) {
        Dimension dimension;
        if (jComponent != null && (dimension = jComponent.getPreferredSize()) != null) {
            return dimension.height;
        }
        return 0;
    }

    private static class ComboCardLayout
    extends CardLayout {
        private final int _topInset;
        private final int _leftInset;
        private final int _bottomInset;
        private final int _rightInset;

        ComboCardLayout(int n, int n2, int n3, int n4) {
            super((n2 + n4) / 2, (n + n3) / 2);
            this._topInset = n;
            this._leftInset = n2;
            this._bottomInset = n3;
            this._rightInset = n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = container.getComponentCount();
                int n2 = 0;
                while (n2 < n) {
                    Component component = container.getComponent(n2);
                    if (component.isVisible()) {
                        component.setBounds(this._leftInset + insets.left, this._topInset + insets.top, container.getWidth() - (this._leftInset + this._rightInset + insets.left + insets.right), container.getHeight() - (this._topInset + this._bottomInset + insets.top + insets.bottom));
                    }
                    ++n2;
                }
            }
        }
    }
}

