/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.AbstractCellEditor;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.TreeTableModelAdapter;

public class JFastTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    protected KeyNavigationManager _knm;
    protected int treeColumnModelIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    void $init$() {
        this.treeColumnModelIndex = -1;
    }

    public JFastTreeTable(TreeTableModel treeTableModel) {
        this.$init$();
        int n = 0;
        while (n < treeTableModel.getColumnCount()) {
            if (treeTableModel.getColumnClass(n).isAssignableFrom(TreeTableModel.class)) {
                this.treeColumnModelIndex = n;
                break;
            }
            ++n;
        }
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.getRowHeight());
        }
        this.addMouseListener(new 1());
    }

    public void paint(Graphics graphics) {
        int n;
        Rectangle rectangle = graphics.getClipBounds();
        Point point = new Point(rectangle.x, rectangle.y);
        int n2 = this.columnAtPoint(point);
        if (n2 == -1) {
            n2 = 0;
        }
        point.translate(rectangle.width - 1, rectangle.height - 1);
        int n3 = this.columnAtPoint(point);
        if (n3 == -1) {
            n3 = this.getColumnCount() - 1;
        }
        if ((n = this.getTreeColumn()) < n2 || n > n3) {
            super.paint(graphics);
        } else {
            int[] nArray;
            TableColumn tableColumn;
            Rectangle rectangle2 = this.getCellRect(0, n, false);
            rectangle2.y = rectangle.y;
            rectangle2.height = rectangle.height;
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null && (tableColumn = jTableHeader.getDraggedColumn()) != null && this.isTreeColumn(tableColumn)) {
                rectangle2.x += jTableHeader.getDraggedDistance();
            }
            if (rectangle.x < rectangle2.x) {
                Rectangle rectangle3 = new Rectangle(rectangle);
                rectangle3.width = rectangle2.x - rectangle.x;
                graphics.setClip(rectangle3);
                super.paint(graphics);
            }
            if (rectangle2.x + rectangle2.width < rectangle.x + rectangle.width) {
                Rectangle rectangle4 = new Rectangle(rectangle);
                rectangle4.x = rectangle2.x + rectangle2.width;
                rectangle4.width = rectangle.x + rectangle.width - rectangle4.x;
                graphics.setClip(rectangle4);
                super.paint(graphics);
            }
            if ((nArray = this.getSelectedRows()) != null && nArray.length > 0) {
                Arrays.sort(nArray);
                int n4 = rectangle.y;
                int n5 = 0;
                while (n5 < nArray.length) {
                    Rectangle rectangle5 = this.getCellRect(nArray[n5], n, false);
                    rectangle5.x = rectangle2.x;
                    Rectangle rectangle6 = new Rectangle(rectangle2.x, n4, rectangle2.width, rectangle5.y - n4);
                    if (rectangle6.intersects(rectangle)) {
                        this.tree.setBackground(this.getBackground());
                        Rectangle rectangle7 = rectangle6.intersection(rectangle);
                        graphics.setClip(rectangle7);
                        this.tree.setBounds(rectangle6);
                        TreeTableCellRenderer.mav$paintFullColumn(this.tree, graphics, rectangle2.x);
                    }
                    if (rectangle5.intersects(rectangle)) {
                        this.tree.setBackground(this.getSelectionBackground());
                        Rectangle rectangle8 = rectangle5.intersection(rectangle);
                        graphics.setClip(rectangle8);
                        this.tree.setBounds(rectangle5);
                        TreeTableCellRenderer.mav$paintFullColumn(this.tree, graphics, rectangle2.x);
                    }
                    n4 = rectangle5.y + rectangle5.height;
                    ++n5;
                }
                Rectangle rectangle9 = new Rectangle(rectangle2.x, n4, rectangle2.width, rectangle.y + rectangle.height - n4);
                if (rectangle9.intersects(rectangle)) {
                    this.tree.setBackground(this.getBackground());
                    Rectangle rectangle10 = rectangle9.intersection(rectangle);
                    graphics.setClip(rectangle10);
                    this.tree.setBounds(rectangle9);
                    TreeTableCellRenderer.mav$paintFullColumn(this.tree, graphics, rectangle2.x);
                }
                if (this.isEditing() && this.getEditingColumn() == n) {
                    int n6 = this.editingRow;
                    Rectangle rectangle11 = this.getCellRect(n6, this.getEditingColumn(), false);
                    Rectangle rectangle12 = rectangle11.intersection(rectangle);
                    graphics.setClip(rectangle12);
                    super.paint(graphics);
                    Rectangle rectangle13 = this.tree.getRowBounds(n6);
                    rectangle11.width = rectangle13.x;
                    rectangle12 = rectangle11.intersection(rectangle);
                    graphics.setClip(rectangle12);
                    this.tree.paint(graphics);
                }
            } else if (this.isEditing() && this.getEditingColumn() == n) {
                if (this.getCellEditor() == null) {
                    this.repaint(rectangle);
                } else {
                    int n7 = this.editingRow;
                    Rectangle rectangle14 = this.getCellRect(n7, this.getEditingColumn(), false);
                    Rectangle rectangle15 = rectangle14.intersection(rectangle);
                    graphics.setClip(rectangle15);
                    super.paint(graphics);
                    Rectangle rectangle16 = this.tree.getRowBounds(n7);
                    rectangle14.width = rectangle16.x;
                    rectangle15 = rectangle14.intersection(rectangle);
                    graphics.setClip(rectangle15);
                    this.tree.paint(graphics);
                }
            } else {
                this.tree.setBackground(this.getBackground());
                Rectangle rectangle17 = rectangle2.intersection(rectangle);
                graphics.setClip(rectangle17);
                this.tree.setBounds(rectangle2);
                TreeTableCellRenderer.mav$paintFullColumn(this.tree, graphics, rectangle2.x);
            }
        }
    }

    protected void paintUnoptimized(Graphics graphics) {
        super.paint(graphics);
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public void setKeySearchNavigable(boolean bl) {
        if (this._knm != null) {
            this._knm.setKeyComponentAdapter(null);
            this._knm = null;
        }
        if (bl) {
            this._knm = new KeyNavigationManager(new KeyNavigationManager.TableKeyAdapter(this));
        }
    }

    public void setShowGrid(boolean bl) {
        if (this.tree != null) {
            this.tree.setShowGrid(bl);
        }
        super.setShowGrid(bl);
    }

    public int getEditingRow() {
        return this.isTreeColumn(this.editingColumn) ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void scrollToVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, true);
        this.scrollRectToVisible(rectangle);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this._knm != null) {
            this._knm.preProcessKeyEvent(keyEvent);
        }
        if (!this.processTreeKey(keyEvent)) {
            super.processKeyEvent(keyEvent);
            if (this._knm != null) {
                this._knm.postProcessKeyEvent(keyEvent);
            }
        }
    }

    protected boolean processTreeKey(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && this.isVisible()) {
            int n = keyEvent.getKeyCode();
            boolean bl = (keyEvent.getModifiers() & 0xB) == 0;
            switch (n) {
                case 37: {
                    int n2 = this.getSelectedColumn();
                    if (!this.isTreeColumn(n2) || !bl) break;
                    int n3 = this.getSelectedRow();
                    if (n3 != -1) {
                        TreePath treePath = this.tree.getPathForRow(n3);
                        Object object = treePath.getLastPathComponent();
                        if (this.tree.getModel().isLeaf(object)) {
                            this.moveSelectionToParent(treePath);
                        } else if (this.tree.isCollapsed(treePath)) {
                            this.moveSelectionToParent(treePath);
                        } else {
                            this.tree.collapsePath(treePath);
                            this.tree.setSelectionPath(treePath);
                            this.setColumnSelectionInterval(n2, n2);
                        }
                    }
                    keyEvent.consume();
                    return true;
                }
                case 39: {
                    int n4;
                    if (!this.isTreeColumn(this.getSelectedColumn()) || !bl || (n4 = this.getSelectedRow()) == -1) break;
                    TreePath treePath = this.tree.getPathForRow(n4);
                    Object object = treePath.getLastPathComponent();
                    if (this.tree.getModel().isLeaf(object) || !this.tree.isCollapsed(treePath)) break;
                    this.tree.expandPath(treePath);
                    this.tree.setSelectionPath(treePath);
                    keyEvent.consume();
                    return true;
                }
            }
        }
        return false;
    }

    private void moveSelectionToParent(TreePath treePath) {
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null && (this.tree.isRootVisible() || treePath2.getPathCount() != 1)) {
            int n = this.tree.getRowForPath(treePath2);
            this.setRowSelectionInterval(n, n);
        }
    }

    static {
        $assertionsDisabled = JFastTreeTable.class.desiredAssertionStatus() ^ true;
    }

    private int getTreeColumn() {
        int n = this.convertColumnIndexToView(this.treeColumnModelIndex);
        if (!$assertionsDisabled && this.getColumnClass(n) != TreeTableModel.class) {
            throw new AssertionError();
        }
        return n;
    }

    private boolean isTreeColumn(TableColumn tableColumn) {
        boolean bl;
        if (tableColumn == null) {
            return false;
        }
        boolean bl2 = bl = tableColumn.getModelIndex() == this.treeColumnModelIndex;
        if (!$assertionsDisabled && bl != (this.getModel().getColumnClass(tableColumn.getModelIndex()) == TreeTableModel.class)) {
            throw new AssertionError();
        }
        return bl;
    }

    private boolean isTreeColumn(int n) {
        boolean bl;
        if (n < 0) {
            return false;
        }
        boolean bl2 = bl = this.getColumnModel().getColumn(n).getModelIndex() == this.treeColumnModelIndex;
        if (!$assertionsDisabled && bl != (this.getColumnClass(n) == TreeTableModel.class)) {
            throw new AssertionError();
        }
        return bl;
    }

    static int mav$getTreeColumn(JFastTreeTable jFastTreeTable) {
        return jFastTreeTable.getTreeColumn();
    }

    public final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (!JFastTreeTable.this.isEditing()) {
                JFastTreeTable.this.requestFocus();
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected JTable table;
        protected boolean hasFocus;
        protected boolean isSelected;
        protected int currentRow;
        protected int currentColumn;
        protected boolean showGrid;

        void $init$() {
            this.showGrid = false;
        }

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.$init$();
            this.setFocusable(false);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JFastTreeTable.this != null && JFastTreeTable.this.getRowHeight() != n) {
                    JFastTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JFastTreeTable.this.getHeight());
        }

        private void paintFullColumn(Graphics graphics, int n) {
            Graphics graphics2 = graphics.create();
            graphics2.translate(n, 0);
            super.paint(graphics2);
            if (JFastTreeTable.this.hasFocus() && JFastTreeTable.this.getColumnModel().getSelectionModel().getLeadSelectionIndex() == JFastTreeTable.this.treeColumnModelIndex) {
                this.paintFocus(JFastTreeTable.this, JFastTreeTable.this.getSelectionModel().getLeadSelectionIndex(), JFastTreeTable.this.treeColumnModelIndex, graphics2);
            }
            graphics2.dispose();
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.table = jTable;
            this.hasFocus = bl2;
            this.isSelected = bl;
            this.currentRow = n;
            this.currentColumn = n2;
            return this;
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.currentRow * this.getRowHeight());
            super.paint(graphics);
            if (this.hasFocus) {
                this.paintFocus(this.table, this.currentRow, this.currentColumn, graphics);
            }
            if (this.showGrid) {
                Rectangle rectangle = JFastTreeTable.this.getCellRect(this.currentRow, this.currentColumn, false);
                graphics.setColor(JFastTreeTable.this.getGridColor());
                graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width, rectangle.height);
            }
        }

        private void paintFocus(JTable jTable, int n, int n2, Graphics graphics) {
            Border border = UIManager.getBorder("Table.focusCellHighlightBorder");
            if (border != null) {
                Rectangle rectangle = JFastTreeTable.this.getCellRect(n, n2, false);
                rectangle.x = 0;
                if (jTable.getSelectionModel().isSelectedIndex(n) && jTable.getColumnModel().getSelectionModel().isSelectedIndex(n2)) {
                    graphics.setColor(JFastTreeTable.this.getSelectionForeground());
                } else {
                    graphics.setColor(this.getForeground());
                }
                border.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.translate(0, this.currentRow * this.getRowHeight());
            MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            return super.getToolTipText(mouseEvent2);
        }

        void setShowGrid(boolean bl) {
            this.showGrid = bl;
        }

        public AccessibleContext getAccessibleContext() {
            Accessible accessible;
            int n;
            AccessibleContext accessibleContext = super.getAccessibleContext();
            if (this.accessibleContext instanceof JTree.AccessibleJTree && (n = accessibleContext.getAccessibleChildrenCount()) == 1 && (accessible = accessibleContext.getAccessibleChild(0)) != null) {
                AccessibleContext accessibleContext2 = accessible.getAccessibleContext();
                return accessibleContext2;
            }
            return accessibleContext;
        }

        static void mav$paintFullColumn(TreeTableCellRenderer treeTableCellRenderer, Graphics graphics, int n) {
            treeTableCellRenderer.paintFullColumn(graphics, n);
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JFastTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject eventObject) {
            int n;
            MouseEvent mouseEvent;
            int n2;
            if (eventObject instanceof MouseEvent && JFastTreeTable.this.tree.getPathForLocation(n2 = (mouseEvent = (MouseEvent)eventObject).getX() - JFastTreeTable.this.getCellRect((int)0, (int)JFastTreeTable.mav$getTreeColumn((JFastTreeTable)JFastTreeTable.this), (boolean)true).x, n = mouseEvent.getY()) == null) {
                JFastTreeTable.this.add(JFastTreeTable.this.tree);
                try {
                    JFastTreeTable.this.tree.dispatchEvent(new MouseEvent(JFastTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    JFastTreeTable.this.tree.dispatchEvent(new MouseEvent(JFastTreeTable.this.tree, 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), n2, n, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
                finally {
                    JFastTreeTable.this.remove(JFastTreeTable.this.tree);
                }
            }
            return false;
        }
    }

    public class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = JFastTreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        public class ListSelectionHandler
        implements ListSelectionListener {
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }

            ListSelectionHandler() {
            }
        }
    }
}

