/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import oracle.ide.Ide;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;

public final class JTextComponentUndoSupport {
    private static final String UNDO_ACTION_NAME = "undo";
    private static final String REDO_ACTION_NAME = "redo";
    private final JTextComponent m_TextComponent;
    private final UndoSupport m_UndoSupport;
    private final UndoManager m_UndoManager;
    private final UndoAction m_UndoAction;
    private final RedoAction m_RedoAction;
    private CompoundEdit m_combinedEdit;

    public JTextComponentUndoSupport(JTextComponent jTextComponent) {
        this.$init$();
        this.m_TextComponent = jTextComponent;
        jTextComponent.getDocument().addUndoableEditListener(this.m_UndoSupport);
        this.bindUndoRedo(jTextComponent);
        this.adjustActions();
    }

    public void clearUndo() {
        this.m_UndoManager.discardAllEdits();
        this.adjustActions();
    }

    public void startCombiningEdits() {
        if (this.m_combinedEdit != null) {
            this.m_combinedEdit = new CompoundEdit();
        }
    }

    public void commitCombinedEdit() {
        if (this.m_combinedEdit != null) {
            this.m_combinedEdit.end();
            this.m_UndoManager.addEdit(this.m_combinedEdit);
            this.m_combinedEdit = null;
        }
        this.adjustActions();
    }

    private void getBindings(KeyStrokeMap keyStrokeMap, int n, String string, ArrayList arrayList) {
        List list = keyStrokeMap.getKeyStrokesFor(n);
        if (!list.isEmpty()) {
            for (KeyStrokes keyStrokes : list) {
                KeyStroke keyStroke;
                if (keyStrokes.getLength() != 1 || (keyStroke = keyStrokes.getKeyStroke(0)) == null) continue;
                arrayList.add(new JTextComponent.KeyBinding(keyStroke, string));
            }
        }
    }

    private void bindUndoRedo(JTextComponent jTextComponent) {
        ArrayList arrayList = new ArrayList();
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeMap keyStrokeMap = keyStrokeOptions.getGlobalKeyMap();
        this.getBindings(keyStrokeMap, 5, UNDO_ACTION_NAME, arrayList);
        this.getBindings(keyStrokeMap, 6, REDO_ACTION_NAME, arrayList);
        JTextComponent.loadKeymap(jTextComponent.getKeymap(), arrayList.toArray(new JTextComponent.KeyBinding[arrayList.size()]), new Action[]{this.m_UndoAction, this.m_RedoAction});
    }

    private void adjustActions() {
        this.m_UndoAction.setEnabled(this.m_UndoManager.canUndo());
        this.m_RedoAction.setEnabled(this.m_UndoManager.canRedo());
    }

    void $init$() {
        this.m_UndoSupport = new UndoSupport(null);
        this.m_UndoManager = new UndoManager();
        this.m_UndoAction = new UndoAction();
        this.m_RedoAction = new RedoAction();
    }

    static CompoundEdit ra$m_combinedEdit(JTextComponentUndoSupport jTextComponentUndoSupport) {
        return jTextComponentUndoSupport.m_combinedEdit;
    }

    static UndoManager ra$m_UndoManager(JTextComponentUndoSupport jTextComponentUndoSupport) {
        return jTextComponentUndoSupport.m_UndoManager;
    }

    static void mav$adjustActions(JTextComponentUndoSupport jTextComponentUndoSupport) {
        jTextComponentUndoSupport.adjustActions();
    }

    private final class UndoSupport
    implements UndoableEditListener {
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            boolean bl = false;
            if (JTextComponentUndoSupport.ra$m_combinedEdit(JTextComponentUndoSupport.this) != null) {
                if (JTextComponentUndoSupport.ra$m_combinedEdit(JTextComponentUndoSupport.this).addEdit(undoableEdit)) {
                    bl = true;
                } else {
                    JTextComponentUndoSupport.this.commitCombinedEdit();
                    JTextComponentUndoSupport.this.startCombiningEdits();
                }
            }
            if (!bl) {
                JTextComponentUndoSupport.ra$m_UndoManager(JTextComponentUndoSupport.this).addEdit(undoableEdit);
                JTextComponentUndoSupport.mav$adjustActions(JTextComponentUndoSupport.this);
            }
        }

        private UndoSupport() {
        }

        UndoSupport(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(JTextComponentUndoSupport.UNDO_ACTION_NAME);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponentUndoSupport.ra$m_UndoManager(JTextComponentUndoSupport.this).undo();
            JTextComponentUndoSupport.mav$adjustActions(JTextComponentUndoSupport.this);
        }
    }

    private final class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(JTextComponentUndoSupport.REDO_ACTION_NAME);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponentUndoSupport.ra$m_UndoManager(JTextComponentUndoSupport.this).redo();
            JTextComponentUndoSupport.mav$adjustActions(JTextComponentUndoSupport.this);
        }
    }
}

