/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Dimension;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.controls.ThinBevel;

public class JToolButton
extends JButton {
    public static final Dimension DEFAULT_SIZE = new Dimension(28, 25);
    private Border _lowered;
    private Border _raised;

    void $init$() {
        this._lowered = ThinBevel.LOWERED_BORDER;
        this._raised = ThinBevel.RAISED_BORDER;
    }

    public JToolButton() {
        this((Icon)null);
    }

    public JToolButton(Icon icon) {
        this(icon, false);
    }

    public JToolButton(Icon icon, boolean bl) {
        this(icon, bl, null);
    }

    public JToolButton(Icon icon, boolean bl, Dimension dimension) {
        this.$init$();
        this.setContentAreaFilled(false);
        this.setDefaultCapable(false);
        if (icon != null) {
            this.setIcon(icon);
        }
        ChangeListener changeListener = this.getChangeListener(bl);
        ButtonModel buttonModel = this.getModel();
        buttonModel.addChangeListener(changeListener);
        this.setFixedSize(dimension != null ? dimension : DEFAULT_SIZE);
        this.setRolloverEnabled(bl);
        this.setBorder(bl ? null : this.getRaisedBorder());
    }

    public void setFixedSize(Dimension dimension) {
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public Border getLoweredBorder() {
        return this._lowered;
    }

    public void setLoweredBorder(Border border) {
        this._lowered = border;
    }

    public Border getRaisedBorder() {
        return this._raised;
    }

    public void setRaisedBorder(Border border) {
        this._raised = border;
    }

    protected ChangeListener getChangeListener(boolean bl) {
        return new L(bl);
    }

    protected class L
    implements ChangeListener {
        private final boolean _hasRolloverBorder;

        public L(boolean bl) {
            this._hasRolloverBorder = bl;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl;
            ButtonModel buttonModel = (ButtonModel)changeEvent.getSource();
            boolean bl2 = buttonModel.isArmed() && buttonModel.isPressed();
            boolean bl3 = bl = !bl2 && (!this._hasRolloverBorder || buttonModel.isRollover());
            JToolButton.this.setBorder(bl2 ? JToolButton.this.getLoweredBorder() : (bl ? JToolButton.this.getRaisedBorder() : null));
        }
    }
}

