/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.controls.AbstractCellEditor;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.controls.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    protected KeyNavigationManager _knm;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.getRowHeight());
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public void setKeySearchNavigable(boolean bl) {
        if (this._knm != null) {
            this._knm.setKeyComponentAdapter(null);
            this._knm = null;
        }
        if (bl) {
            this._knm = new KeyNavigationManager(new KeyNavigationManager.TableKeyAdapter(this));
        }
    }

    public void setShowGrid(boolean bl) {
        if (this.tree != null) {
            this.tree.setShowGrid(bl);
        }
        super.setShowGrid(bl);
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void scrollToVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, n2, true);
        this.scrollRectToVisible(rectangle);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (this._knm != null) {
            this._knm.preProcessKeyEvent(keyEvent);
        }
        super.processKeyEvent(keyEvent);
        this.processTreeKey(keyEvent);
        if (this._knm != null) {
            this._knm.postProcessKeyEvent(keyEvent);
        }
    }

    protected void processTreeKey(KeyEvent keyEvent) {
        int n;
        int n2;
        if (!keyEvent.isConsumed() && keyEvent.getID() == 401 && this.isVisible() && ((n2 = keyEvent.getKeyCode()) == 37 || n2 == 39) && ((n = keyEvent.getModifiers()) & 2) == 2) {
            int n3 = this.getSelectedRow();
            KeyEvent keyEvent2 = new KeyEvent(this.tree, keyEvent.getID(), keyEvent.getWhen(), 0, n2, '\uffff');
            this.tree.dispatchEvent(keyEvent2);
            this.getSelectionModel().setSelectionInterval(n3, n3);
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected int column;
        protected boolean showGrid;
        protected boolean hasFocus;

        void $init$() {
            this.showGrid = false;
            this.hasFocus = false;
        }

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.$init$();
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            Border border;
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
            if (this.hasFocus && (border = UIManager.getBorder("Table.focusCellHighlightBorder")) != null) {
                Rectangle rectangle = JTreeTable.this.getCellRect(this.visibleRow, this.column, false);
                border.paintBorder(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return;
            }
            if (this.showGrid) {
                Rectangle rectangle = JTreeTable.this.getCellRect(this.visibleRow, this.column, false);
                graphics.setColor(JTreeTable.this.getGridColor());
                graphics.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width, rectangle.height);
            }
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.translate(0, this.visibleRow * this.getRowHeight());
            MouseEvent mouseEvent2 = new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            return super.getToolTipText(mouseEvent2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(jTable.getBackground());
            }
            this.visibleRow = n;
            this.column = n2;
            this.hasFocus = bl2;
            return this;
        }

        void setShowGrid(boolean bl) {
            this.showGrid = bl;
        }

        public AccessibleContext getAccessibleContext() {
            Accessible accessible;
            int n;
            AccessibleContext accessibleContext = super.getAccessibleContext();
            if (this.accessibleContext instanceof JTree.AccessibleJTree && (n = accessibleContext.getAccessibleChildrenCount()) == 1 && (accessible = accessibleContext.getAccessibleChild(0)) != null) {
                AccessibleContext accessibleContext2 = accessible.getAccessibleContext();
                return accessibleContext2;
            }
            return accessibleContext;
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = JTreeTable.this.getColumnCount() - 1;
                while (n >= 0) {
                    if (JTreeTable.this.getColumnClass(n) == TreeTableModel.class) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        mouseEvent2 = new MouseEvent(JTreeTable.this.tree, 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        break;
                    }
                    --n;
                }
            }
            return false;
        }
    }

    public class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = JTreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        public class ListSelectionHandler
        implements ListSelectionListener {
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }

            ListSelectionHandler() {
            }
        }
    }
}

