/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.JWindow;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;
import oracle.ide.resource.ExplorerArb;

public class KeyNavigationManager
implements FocusListener,
ComponentListener,
MouseListener {
    private static final boolean NEW_BEHAVIOR = true;
    private static final int X_TOOLTIP_PADDING = 5;
    private static final int Y_TOOLTIP_PADDING = 5;
    private static final int GOTO_PREV = -1;
    private static final int GOTO_NEXT = 0;
    private static final int GOTO_AFTER = 1;
    private StringBuffer _keys;
    private ArrayList _history;
    private JToolTip _tip;
    private JWindow _tipWindow;
    private KeyComponentAdapter _kca;

    void $init$() {
        this._keys = new StringBuffer(50);
        this._history = new ArrayList(5);
    }

    public KeyNavigationManager() {
        this(null);
    }

    public KeyNavigationManager(KeyComponentAdapter keyComponentAdapter) {
        this.$init$();
        this.setKeyComponentAdapter(keyComponentAdapter);
    }

    public void setKeyComponentAdapter(KeyComponentAdapter keyComponentAdapter) {
        JComponent jComponent;
        JComponent jComponent2;
        if (this._kca != null && (jComponent2 = this._kca.getComponent()) != null) {
            jComponent2.removeMouseListener(this);
        }
        this._kca = keyComponentAdapter;
        if (this._kca != null && (jComponent = this._kca.getComponent()) != null) {
            jComponent.addMouseListener(this);
            if (jComponent instanceof JTree) {
                JTree jTree = (JTree)jComponent;
                KeyListener[] keyListenerArray = (KeyListener[])jComponent.getListeners(KeyListener.class);
                int n = 0;
                while (n < keyListenerArray.length) {
                    KeyListener keyListener = keyListenerArray[n];
                    if (keyListener instanceof BasicTreeUI.KeyHandler) {
                        jTree.removeKeyListener(keyListener);
                    }
                    ++n;
                }
            }
        }
    }

    public KeyComponentAdapter getKeyComponentAdapter() {
        return this._kca;
    }

    private boolean isVisible() {
        return this._tipWindow != null;
    }

    private void _updateLabel() {
        if (this._keys.length() > 0) {
            if (this._tip == null) {
                this._tip = new JToolTip();
            }
            this._tip.setTipText(ExplorerArb.format(4, this._keys.toString()));
            this._showWindow();
            this._tip.revalidate();
            if (this._tipWindow != null) {
                this._tipWindow.pack();
            }
        } else {
            this._hideWindow();
        }
    }

    private void _clearAll() {
        this._keys.setLength(0);
        this._history.clear();
        this._updateLabel();
    }

    private void _removeLast() {
        int n = this._keys.length() - 1;
        if (n >= 0) {
            this._keys.deleteCharAt(n);
            int n2 = this._history.size();
            if (n2 != 0) {
                Object e = this._history.remove(n2 - 1);
                this._kca.setSelection(e);
            }
            this._updateLabel();
        }
    }

    private void _addChar(char c) {
        this._keys.append(c);
        Object object = this._kca.getSelection();
        if (this._gotoMatch(0)) {
            this._updateLabel();
            this._history.add(object);
        } else {
            if (this._keys.toString().trim().length() > 0) {
                Toolkit.getDefaultToolkit().beep();
            }
            this._keys = this._keys.deleteCharAt(this._keys.length() - 1);
        }
    }

    private boolean _gotoMatch(int n) {
        Object object = this._kca.getSelection();
        int n2 = this._kca.getRowPosition(object);
        int n3 = this._kca.getRowCount();
        int n4 = n2 + n3;
        int n5 = 1;
        switch (n) {
            case -1: {
                --n4;
                n5 = -1;
                break;
            }
            case 0: {
                if (n2 != -1) break;
                n4 = 0;
                break;
            }
            case 1: {
                ++n4;
            }
        }
        boolean bl = this._keys.charAt(0) == '*';
        String string = bl ? this._keys.toString().substring(1) : this._keys.toString();
        int n6 = string.length();
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n4 % n3;
            Object object2 = this._kca.getRow(n8);
            String string2 = this._kca.toString(object2);
            if (bl ? KeyNavigationManager._contains(string2, string) : string2.regionMatches(true, 0, string, 0, n6)) {
                this._kca.setSelection(object2);
                return true;
            }
            n4 += n5;
            ++n7;
        }
        return false;
    }

    private static boolean _contains(String string, String string2) {
        int n;
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = n = n2 - n3;
        while (n4 >= 0) {
            if (string.regionMatches(true, n4, string2, 0, n3)) {
                return true;
            }
            --n4;
        }
        return false;
    }

    private void _hideWindow() {
        if (this._tipWindow != null) {
            this._tipWindow.setVisible(false);
            this._tipWindow.getOwner().removeComponentListener(this);
            this._tipWindow.dispose();
            this._tipWindow = null;
        }
        this._tip = null;
    }

    private void _showWindow() {
        if (this._tipWindow == null) {
            JComponent jComponent = this._kca.getComponent();
            jComponent.addFocusListener(this);
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            if (window != null) {
                this._tipWindow = new JWindow(window);
                window.addComponentListener(this);
                this._tipWindow.getContentPane().add(this._tip);
                this._tipWindow.pack();
                this._updateWindowLocation();
                this._tipWindow.setVisible(true);
            }
        }
    }

    private void _updateWindowLocation() {
        if (this._tipWindow != null) {
            JComponent jComponent = this._kca.getComponent();
            Point point = jComponent.getLocationOnScreen();
            Container container = jComponent.getParent();
            if (container instanceof JViewport) {
                Point point2 = ((JViewport)container).getViewPosition();
                point.x += point2.x;
                point.y += point2.y;
            }
            int n = this._tipWindow.getHeight();
            int n2 = point.x + 5;
            int n3 = point.y - n + 5;
            this._tipWindow.setLocation(n2, n3);
        }
    }

    public void preProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getID()) {
            case 401: {
                this.preKeyPressed(keyEvent);
                break;
            }
            case 400: {
                this.preKeyTyped(keyEvent);
                break;
            }
            case 402: {
                this.preKeyReleased(keyEvent);
            }
        }
    }

    public void postProcessKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getID()) {
            case 401: {
                this.postKeyPressed(keyEvent);
                break;
            }
            case 400: {
                this.postKeyTyped(keyEvent);
                break;
            }
            case 402: {
                this.postKeyReleased(keyEvent);
            }
        }
    }

    public void preKeyTyped(KeyEvent keyEvent) {
    }

    public void postKeyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!(keyEvent.isAltDown() || keyEvent.isControlDown() || Character.isISOControl(c))) {
            keyEvent.consume();
            this._addChar(c);
        } else if (c != '\b' && this._keys.length() > 0) {
            this._clearAll();
        }
    }

    public void preKeyPressed(KeyEvent keyEvent) {
        if (this.isVisible()) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 27: {
                    keyEvent.consume();
                    this._clearAll();
                    break;
                }
                case 10: {
                    this._clearAll();
                    break;
                }
                case 37: 
                case 39: 
                case 226: 
                case 227: {
                    this._clearAll();
                    break;
                }
                case 38: 
                case 224: {
                    keyEvent.consume();
                    this._gotoMatch(-1);
                    break;
                }
                case 40: 
                case 225: {
                    keyEvent.consume();
                    this._gotoMatch(1);
                    break;
                }
                case 8: 
                case 127: {
                    keyEvent.consume();
                    this._removeLast();
                }
            }
        }
    }

    public void postKeyPressed(KeyEvent keyEvent) {
    }

    public void preKeyReleased(KeyEvent keyEvent) {
    }

    public void postKeyReleased(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this._clearAll();
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this._clearAll();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this._updateWindowLocation();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this._updateWindowLocation();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public static JTree createNavigableTree() {
        return new 1();
    }

    public static interface KeyComponentAdapter {
        public JComponent getComponent();

        public int getRowCount();

        public Object getRow(int var1);

        public int getRowPosition(Object var1);

        public String toString(Object var1);

        public Object getSelection();

        public void setSelection(Object var1);
    }

    public static class TreeKeyAdapter
    implements KeyComponentAdapter {
        private JTree _tree;

        public TreeKeyAdapter(JTree jTree) {
            this._tree = jTree;
        }

        public JComponent getComponent() {
            return this._tree;
        }

        public int getRowCount() {
            return this._tree.getRowCount();
        }

        public Object getRow(int n) {
            TreePath treePath = this._tree.getPathForRow(n);
            return treePath;
        }

        public int getRowPosition(Object object) {
            TreePath treePath = (TreePath)object;
            return this._tree.getRowForPath(treePath);
        }

        public String toString(Object object) {
            TreePath treePath = (TreePath)object;
            return treePath.getLastPathComponent().toString();
        }

        public Object getSelection() {
            return this._tree.getSelectionPath();
        }

        public void setSelection(Object object) {
            TreePath treePath = (TreePath)object;
            this._tree.setSelectionPath(treePath);
            this._tree.scrollPathToVisible(treePath);
        }
    }

    public static class TableKeyAdapter
    implements KeyComponentAdapter {
        private JTable _table;

        public TableKeyAdapter(JTable jTable) {
            this._table = jTable;
        }

        public JComponent getComponent() {
            return this._table;
        }

        public int getRowCount() {
            return this._table.getRowCount();
        }

        public Object getRow(int n) {
            return new Integer(n);
        }

        public int getRowPosition(Object object) {
            return (Integer)object;
        }

        public String toString(Object object) {
            int n = this.getRowPosition(object);
            int n2 = Math.max(this._table.getSelectedColumn(), 0);
            Object object2 = this._table.getModel().getValueAt(n, n2);
            return object2 != null ? object2.toString() : "";
        }

        public Object getSelection() {
            return new Integer(this._table.getSelectedRow());
        }

        public void setSelection(Object object) {
            int n = this.getRowPosition(object);
            Rectangle rectangle = this._table.getCellRect(n, 0, true);
            this._table.getSelectionModel().setSelectionInterval(n, n);
            this._table.scrollRectToVisible(rectangle);
        }
    }

    public static class ListKeyAdapter
    implements KeyComponentAdapter {
        private JList _list;

        public ListKeyAdapter(JList jList) {
            this._list = jList;
        }

        public JComponent getComponent() {
            return this._list;
        }

        public int getRowCount() {
            return this._list.getModel().getSize();
        }

        public Object getRow(int n) {
            return new Integer(n);
        }

        public int getRowPosition(Object object) {
            return (Integer)object;
        }

        public String toString(Object object) {
            int n = this.getRowPosition(object);
            ListModel listModel = this._list.getModel();
            Object e = listModel.getElementAt(n);
            return e != null ? e.toString() : "";
        }

        public Object getSelection() {
            ListSelectionModel listSelectionModel = this._list.getSelectionModel();
            int n = listSelectionModel.getLeadSelectionIndex();
            return new Integer(n);
        }

        public void setSelection(Object object) {
            int n = this.getRowPosition(object);
            Rectangle rectangle = this._list.getCellBounds(n, n);
            this._list.getSelectionModel().setSelectionInterval(n, n);
            this._list.scrollRectToVisible(rectangle);
        }
    }

    public static final class 1
    extends JTree {
        KeyNavigationManager knm;

        void $init$() {
            this.knm = new KeyNavigationManager(new TreeKeyAdapter(this));
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            this.knm.preProcessKeyEvent(keyEvent);
            super.processKeyEvent(keyEvent);
            this.knm.postProcessKeyEvent(keyEvent);
        }

        public 1() {
            this.$init$();
        }
    }
}

