/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class KeyboardRedirector
implements AWTEventListener {
    private static KeyboardRedirector INSTANCE;
    private ArrayList _queue;
    private boolean _frozen;
    private int _enqueued;

    void $init$() {
        this._queue = new ArrayList();
    }

    private void initialize() {
    }

    public static KeyboardRedirector getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeyboardRedirector();
            INSTANCE.initialize();
        }
        return INSTANCE;
    }

    public void freeze() {
        this._frozen = true;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.addAWTEventListener(this, 12);
    }

    public void thaw() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        toolkit.removeAWTEventListener(this);
        this._frozen = false;
        int n = 0;
        while (n < this._queue.size()) {
            KeyEvent keyEvent = (KeyEvent)this._queue.get(n);
            Component component = keyEvent.getComponent();
            if (component != null) {
                component.dispatchEvent(keyEvent);
            }
            ++n;
        }
        this._queue.clear();
    }

    private void deliver(Component component) {
        this._frozen = false;
        if (component != null) {
            boolean bl = true;
            int n = 0;
            while (n < this._queue.size()) {
                KeyEvent keyEvent = (KeyEvent)this._queue.get(n);
                if (bl && keyEvent.getID() == 401) {
                    bl = false;
                }
                if (!bl) {
                    keyEvent.setSource(component);
                    component.dispatchEvent(keyEvent);
                }
                ++n;
            }
        }
        this._queue.clear();
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (this._frozen) {
            switch (aWTEvent.getID()) {
                case 400: 
                case 401: 
                case 402: {
                    this.enqueue((KeyEvent)aWTEvent);
                    break;
                }
                case 1004: {
                    ++this._enqueued;
                    SwingUtilities.invokeLater(new 1());
                }
            }
        }
    }

    private void enqueue(KeyEvent keyEvent) {
        KeyEvent keyEvent2 = new KeyEvent(keyEvent.getComponent(), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        this._queue.add(keyEvent2);
        keyEvent.consume();
    }

    public KeyboardRedirector() {
        this.$init$();
    }

    static int ra$_enqueued(KeyboardRedirector keyboardRedirector) {
        return keyboardRedirector._enqueued;
    }

    static void wa$_enqueued(KeyboardRedirector keyboardRedirector, int n) {
        keyboardRedirector._enqueued = n;
    }

    static boolean ra$_frozen(KeyboardRedirector keyboardRedirector) {
        return keyboardRedirector._frozen;
    }

    static void mav$deliver(KeyboardRedirector keyboardRedirector, Component component) {
        keyboardRedirector.deliver(component);
    }

    public final class 1
    implements Runnable {
        public void run() {
            KeyboardRedirector keyboardRedirector = KeyboardRedirector.this;
            int n = KeyboardRedirector.ra$_enqueued(keyboardRedirector) - 1;
            KeyboardRedirector.wa$_enqueued(keyboardRedirector, n);
            if (n == 0 && KeyboardRedirector.ra$_frozen(KeyboardRedirector.this)) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Component component = keyboardFocusManager.getFocusOwner();
                KeyboardRedirector.mav$deliver(KeyboardRedirector.this, component);
            }
        }
    }
}

