/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.Ide;
import oracle.ide.controls.BaseToggleToolButton;
import oracle.ide.controls.MenuToolButtonUtils;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.ToolbarGroup;
import oracle.ide.util.ModelUtil;
import oracle.javatools.controls.PropertyChangeAdapter;

public class MenuToolButton
extends BaseToggleToolButton
implements ToolbarGroup {
    protected static final PopupMenuListener POPUP_MENU_LISTENER = new ButtonPopupMenuListener();
    protected static final Icon POPUP_ICON = new PopupIndicator();
    protected static final int POPUP_WIDTH = Math.max(2 + POPUP_ICON.getIconWidth() + 2, 9);
    protected ToggleAction[] _actions;
    protected ArrayList _hiddenItems;
    protected JPopupMenu _popup;

    public MenuToolButton(ToggleAction[] toggleActionArray) {
        this(toggleActionArray, toggleActionArray[0]);
    }

    public MenuToolButton(ToggleAction toggleAction) {
        this(new ToggleAction[0], toggleAction);
    }

    public MenuToolButton(ToggleAction[] toggleActionArray, ToggleAction toggleAction) {
        super(toggleAction);
        if (toggleActionArray == null) {
            toggleActionArray = new ToggleAction[]{};
        }
        this.setHorizontalAlignment(2);
        this.createPopupMenu();
        this._actions = toggleActionArray;
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < toggleActionArray.length) {
            ToggleAction toggleAction2 = toggleActionArray[n];
            JMenuItem jMenuItem = this.addPopupItem(toggleAction2);
            buttonGroup.add(jMenuItem);
            if (toggleAction2.getState()) {
                this.setAction(toggleAction2);
            }
            PropertyChangeListener propertyChangeListener = this.createMenuItemActionPropertyChangeListener(jMenuItem, toggleAction2);
            toggleAction2.addPropertyChangeListener(propertyChangeListener);
            ++n;
        }
        this.addItemListener(new ButtonItemListener());
    }

    public JPopupMenu getPopupMenu() {
        if (this._popup == null) {
            return this.createPopupMenu();
        }
        return this._popup;
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.getPopupMenu().addPopupMenuListener(popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.getPopupMenu().removePopupMenuListener(popupMenuListener);
    }

    public JMenuItem addPopupItem(ToggleAction toggleAction) {
        JMenuItem jMenuItem;
        if (this._popup == null) {
            this.createPopupMenu();
        }
        if ((jMenuItem = this.findPopupItem(toggleAction)) == null) {
            Object object;
            jMenuItem = Ide.getMenubar().createMenuItem(toggleAction);
            Object object2 = object = toggleAction != null ? toggleAction.getValue("Hidden") : null;
            if (Boolean.TRUE.equals(object)) {
                if (this._hiddenItems == null) {
                    this._hiddenItems = new ArrayList(1);
                }
                this._hiddenItems.add(jMenuItem);
            } else {
                this._popup.add(jMenuItem);
            }
        }
        return jMenuItem;
    }

    public void removePopupItem(ToggleAction toggleAction) {
        JMenuItem jMenuItem = this.findPopupItem(toggleAction);
        if (jMenuItem != null) {
            if (this._hiddenItems != null && this._hiddenItems.contains(jMenuItem)) {
                this._hiddenItems.remove(jMenuItem);
            } else {
                this._popup.remove(jMenuItem);
            }
        }
    }

    public void removeAllPopupItems() {
        if (this._hiddenItems != null) {
            this._hiddenItems.clear();
        }
        this._popup.removeAll();
    }

    public JMenuItem findPopupItem(ToggleAction toggleAction) {
        if (this._popup != null) {
            MenuElement[] menuElementArray = this._popup.getSubElements();
            int n = 0;
            while (n < menuElementArray.length) {
                JMenuItem jMenuItem;
                Action action;
                Component component = menuElementArray[n].getComponent();
                if (component instanceof JMenuItem && (action = (jMenuItem = (JMenuItem)component).getAction()) != null && action.equals(toggleAction)) {
                    return jMenuItem;
                }
                ++n;
            }
        }
        if (this._hiddenItems != null) {
            int n = this._hiddenItems.size() - 1;
            while (n >= 0) {
                JMenuItem jMenuItem;
                Action action;
                Object e = this._hiddenItems.get(n);
                if (e instanceof JMenuItem && (action = (jMenuItem = (JMenuItem)e).getAction()) != null && action.equals(toggleAction)) {
                    return jMenuItem;
                }
                --n;
            }
        }
        return null;
    }

    public Action[] getActions() {
        return this._actions;
    }

    protected ButtonModel createModel() {
        return new MenuToolButtonModel();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += POPUP_WIDTH;
        return dimension;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (!ModelUtil.areEqual((Object)action, (Object)action2)) {
            super.setAction(action);
            if (action == null && this._actions != null) {
                int n = 0;
                while (n < this._actions.length) {
                    JMenuItem jMenuItem = this.findPopupItem(this._actions[n]);
                    if (jMenuItem != null) {
                        jMenuItem.setAction(null);
                    }
                    ++n;
                }
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n - insets.left - (POPUP_WIDTH + POPUP_ICON.getIconWidth()) / 2;
        int n4 = (n2 - 1 - POPUP_ICON.getIconHeight()) / 2;
        POPUP_ICON.paintIcon(this, graphics, n3, n4);
    }

    protected JPopupMenu createPopupMenu() {
        this._popup = new JPopupMenu();
        this._popup.addPopupMenuListener(POPUP_MENU_LISTENER);
        return this._popup;
    }

    protected PropertyChangeListener createMenuItemActionPropertyChangeListener(JMenuItem jMenuItem, Action action) {
        return new InnerPropertyChangeAdaptor(this, jMenuItem, action);
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        private final WeakReference m_MenuToolButtonWeakRef;

        public InnerPropertyChangeAdaptor(MenuToolButton menuToolButton, AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
            this.m_MenuToolButtonWeakRef = new WeakReference<MenuToolButton>(menuToolButton);
        }

        protected void stateChanged(PropertyChangeEvent propertyChangeEvent) {
            Boolean bl;
            MenuToolButton menuToolButton = (MenuToolButton)this.m_MenuToolButtonWeakRef.get();
            if (menuToolButton != null && (bl = (Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                JMenuItem jMenuItem = (JMenuItem)this.getAdaptee();
                menuToolButton.setAction(jMenuItem.getAction());
            }
        }
    }

    protected static class MenuToolButtonModel
    extends JToggleButton.ToggleButtonModel {
        public void setPressed(boolean bl) {
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.setSelected(this.isSelected() ^ true);
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
        }

        protected MenuToolButtonModel() {
        }
    }

    protected static class ButtonPopupMenuListener
    implements PopupMenuListener {
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            AbstractButton abstractButton = this.getButton(popupMenuEvent);
            abstractButton.getModel().setArmed(false);
            abstractButton.setSelected(false);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        protected AbstractButton getButton(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            return (AbstractButton)jPopupMenu.getInvoker();
        }

        protected ButtonPopupMenuListener() {
        }
    }

    protected static class ButtonItemListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                MenuToolButton menuToolButton = (MenuToolButton)itemEvent.getSource();
                MenuToolButtonUtils.showComponentPopupMenu(menuToolButton, menuToolButton._popup);
            }
        }

        protected ButtonItemListener() {
        }
    }

    private static final class PopupIndicator
    extends Polygon
    implements Icon {
        private static final int SIZE = 4;

        public PopupIndicator() {
            this.addPoint(0, 0);
            this.addPoint(2, 2);
            this.addPoint(4, 0);
        }

        public int getIconHeight() {
            return this.getBounds().height;
        }

        public int getIconWidth() {
            return this.getBounds().width;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (component.isEnabled()) {
                this.paint(graphics, n, n2, component.getForeground());
            } else {
                this.paint(graphics, n, n2, component.getBackground().darker());
            }
        }

        private void paint(Graphics graphics, int n, int n2, Color color) {
            Color color2 = graphics.getColor();
            graphics.translate(n, n2);
            graphics.setColor(color);
            graphics.fillPolygon(this);
            graphics.drawPolygon(this);
            graphics.translate(-n, -n2);
            graphics.setColor(color2);
        }
    }
}

