/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;

class MenuToolButtonUtils {
    private MenuToolButtonUtils() {
    }

    static void showComponentPopupMenu(Component component, JPopupMenu jPopupMenu) {
        Point point = MenuToolButtonUtils.getPopupMenuOrigin(component, jPopupMenu);
        jPopupMenu.show(component, point.x, point.y);
    }

    static Point getPopupMenuOrigin(Component component, JPopupMenu jPopupMenu) {
        Container container;
        int n = 0;
        int n2 = 0;
        Dimension dimension = component.getSize();
        Dimension dimension2 = jPopupMenu.getSize();
        if (dimension2.width == 0) {
            dimension2 = jPopupMenu.getPreferredSize();
        }
        Point point = component.getLocationOnScreen();
        Toolkit toolkit = component.getToolkit();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Rectangle rectangle = new Rectangle(toolkit.getScreenSize());
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        int n3 = 0;
        while (n3 < graphicsDeviceArray.length) {
            GraphicsConfiguration graphicsConfiguration2;
            if (graphicsDeviceArray[n3].getType() == 0 && (graphicsConfiguration2 = graphicsDeviceArray[n3].getDefaultConfiguration()).getBounds().contains(point)) {
                graphicsConfiguration = graphicsConfiguration2;
                break;
            }
            ++n3;
        }
        if (graphicsConfiguration != null) {
            rectangle = graphicsConfiguration.getBounds();
            Insets insets = toolkit.getScreenInsets(graphicsConfiguration);
            rectangle.width -= Math.abs(insets.left + insets.right);
            rectangle.height -= Math.abs(insets.top + insets.bottom);
            point.x -= Math.abs(insets.left);
            point.y -= Math.abs(insets.top);
        }
        if ((container = component.getParent()) instanceof JPopupMenu) {
            int n4 = UIManager.getInt("Menu.submenuPopupOffsetX");
            int n5 = UIManager.getInt("Menu.submenuPopupOffsetY");
            if (component.getComponentOrientation().isLeftToRight()) {
                n = dimension.width + n4;
                if (point.x + n + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    n = 0 - n4 - dimension2.width;
                }
            } else {
                n = 0 - n4 - dimension2.width;
                if (point.x + n < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n = dimension.width + n4;
                }
            }
            n2 = n5;
            if (point.y + n2 + dimension2.height >= rectangle.height + rectangle.y && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n2 = dimension.height - n5 - dimension2.height;
            }
        } else {
            int n6 = UIManager.getInt("Menu.menuPopupOffsetX");
            int n7 = UIManager.getInt("Menu.menuPopupOffsetY");
            if (component.getComponentOrientation().isLeftToRight()) {
                n = n6;
                if (point.x + n + dimension2.width >= rectangle.width + rectangle.x && rectangle.width - dimension.width < 2 * (point.x - rectangle.x)) {
                    n = dimension.width - n6 - dimension2.width;
                }
            } else {
                n = dimension.width - n6 - dimension2.width;
                if (point.x + n < rectangle.x && rectangle.width - dimension.width > 2 * (point.x - rectangle.x)) {
                    n = n6;
                }
            }
            n2 = dimension.height + n7;
            if (point.y + n2 + dimension2.height >= rectangle.height && rectangle.height - dimension.height < 2 * (point.y - rectangle.y)) {
                n2 = 0 - n7 - dimension2.height;
            }
        }
        return new Point(n, n2);
    }
}

