/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;

public class OverlayIcon
implements Icon {
    private Collection m_icons;
    private int m_width;
    private int m_height;

    void $init$() {
        this.m_width = -1;
        this.m_height = -1;
    }

    public OverlayIcon(Icon icon, Icon icon2) {
        this.$init$();
        this.m_icons = new ArrayList(2);
        this.m_icons.add(icon);
        this.m_icons.add(icon2);
    }

    public OverlayIcon(Collection collection) {
        this.$init$();
        this.m_icons = collection;
    }

    public OverlayIcon(Icon[] iconArray) {
        this.$init$();
        this.m_icons = new ArrayList(iconArray.length);
        int n = 0;
        while (n < iconArray.length) {
            this.m_icons.add(iconArray[n]);
            ++n;
        }
    }

    public void addIcon(Icon icon) {
        this.m_icons.add(icon);
    }

    public void removeIcon(Icon icon) {
        this.m_icons.remove(icon);
    }

    public void setIcons(Collection collection) {
        this.m_icons = collection;
    }

    public Collection getIcons() {
        return Collections.unmodifiableCollection(this.m_icons);
    }

    private void calculateWidthAndHeight() {
        for (Icon icon : this.m_icons) {
            if (icon == null) continue;
            if (icon.getIconWidth() > this.m_width) {
                this.m_width = icon.getIconWidth();
            }
            if (icon.getIconHeight() <= this.m_height) continue;
            this.m_height = icon.getIconHeight();
        }
    }

    public int getIconWidth() {
        if (this.m_width == -1) {
            this.calculateWidthAndHeight();
        }
        return this.m_width;
    }

    public int getIconHeight() {
        if (this.m_height == -1) {
            this.calculateWidthAndHeight();
        }
        return this.m_height;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        for (Icon icon : this.m_icons) {
            if (icon == null) continue;
            icon.paintIcon(component, graphics, n, n2);
        }
    }
}

