/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;

public final class PentaLayout
implements LayoutManager2 {
    private static final int nCENTER = 0;
    private static final int nNORTH = 1;
    private static final int nSOUTH = 2;
    private static final int nWEST = 3;
    private static final int nEAST = 4;
    public static final Integer CENTER = new Integer(0);
    public static final Integer NORTH = new Integer(1);
    public static final Integer SOUTH = new Integer(2);
    public static final Integer WEST = new Integer(3);
    public static final Integer EAST = new Integer(4);
    public static final byte CORNER_NORTH_WEST = 8;
    public static final byte CORNER_NORTH_EAST = 4;
    public static final byte CORNER_SOUTH_WEST = 2;
    public static final byte CORNER_SOUTH_EAST = 1;
    public static final byte HORIZONTAL_STYLE = 15;
    public static final byte VERTICAL_STYLE = 0;
    public static final byte C_STYLE = 5;
    public static final byte T_STYLE = 12;
    private static final String[] BORDERLAYOUT_EQUIV = new String[]{"Center", "North", "South", "West", "East"};
    private int _hgap;
    private int _vgap;
    private Component[] _components;
    private byte _style;

    void $init$() {
        this._components = new Component[5];
    }

    public PentaLayout() {
        this(15, 0, 0);
    }

    public PentaLayout(int n, int n2) {
        this(15, n, n2);
    }

    public PentaLayout(byte by, int n, int n2) {
        this.$init$();
        this._style = by;
        this._hgap = n;
        this._vgap = n2;
    }

    public int getHgap() {
        return this._hgap;
    }

    public void setHgap(int n) {
        this._hgap = n;
    }

    public int getVgap() {
        return this._vgap;
    }

    public void setVgap(int n) {
        this._vgap = n;
    }

    public void setStyle(byte by) {
        this._style = by;
    }

    public byte getStyle() {
        return this._style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLayoutComponent(Component component, Object object) {
        Object object2 = component.getTreeLock();
        synchronized (object2) {
            if (object != CENTER && object != NORTH && object != SOUTH && object != WEST && object != EAST) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be one of the 5 predefined constraints");
            }
            this._components[((Integer)object).intValue()] = component;
        }
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            int n = 0;
            while (n < this._components.length) {
                if (this._components[n] == component) {
                    this._components[n] = null;
                }
                ++n;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getLayoutSize(container, 0);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getLayoutSize(container, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getLayoutSize(Container container, int n) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n2 = 1;
            while (n2 < 5) {
                Component component = this._components[n2];
                if (component != null && component.isVisible()) {
                    Dimension dimension2;
                    switch (n) {
                        case 0: {
                            dimension2 = component.getMinimumSize();
                            break;
                        }
                        case 1: {
                            dimension2 = component.getPreferredSize();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    switch (n2) {
                        case 1: 
                        case 2: {
                            dimension.height += dimension2.height + this._vgap;
                            dimension.width = Math.max(dimension.width, dimension2.width);
                            break;
                        }
                        case 3: 
                        case 4: {
                            dimension.width += dimension2.width + this._hgap;
                            dimension.height = Math.max(dimension.height, dimension2.height);
                            break;
                        }
                        case 0: {
                            dimension.width += dimension2.width;
                            dimension.height += dimension2.height;
                        }
                    }
                }
                ++n2;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom;
            Dimension dimension3 = dimension;
            return dimension3;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void invalidateLayout(Container container) {
    }

    private boolean hasStyle(byte by) {
        return (this._style & by) == by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            boolean bl;
            Dimension dimension;
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.top;
            int n3 = container.getWidth() - insets.right;
            int n4 = container.getHeight() - insets.bottom;
            int n5 = n;
            int n6 = n2;
            int n7 = n3;
            int n8 = n4;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            Component component = this._components[1];
            Component component2 = this._components[2];
            Component component3 = this._components[3];
            Component component4 = this._components[4];
            Component component5 = this._components[0];
            if (component != null && component.isVisible()) {
                dimension = component.getPreferredSize();
                n6 += dimension.height;
                n9 = this._vgap;
            }
            if (component2 != null && component2.isVisible()) {
                dimension = component2.getPreferredSize();
                n8 -= dimension.height;
                n10 = this._vgap;
            }
            if (component3 != null && component3.isVisible()) {
                dimension = component3.getPreferredSize();
                n5 += dimension.width;
                n11 = this._hgap;
            }
            if (component4 != null && component4.isVisible()) {
                dimension = component4.getPreferredSize();
                n7 -= dimension.width;
                n12 = this._hgap;
            }
            if (n5 >= n7) {
                n7 = n5;
            }
            if (n6 >= n8) {
                n8 = n6;
            }
            boolean bl2 = bl = component5 != null && component5.isVisible();
            if (!bl) {
                if (n2 != n6) {
                    n6 = n8;
                } else if (n != n5) {
                    n5 = n7;
                } else if (n4 != n8) {
                    n8 = n6;
                } else if (n3 != n7) {
                    n7 = n5;
                }
            }
            if (component != null && component.isVisible()) {
                int n13 = this.hasStyle((byte)8) ? n : n5 + n11;
                int n14 = this.hasStyle((byte)4) ? n3 : n7 - n12;
                component.setBounds(n13, n2, n14 - n13, n6 - n2);
            }
            if (component2 != null && component2.isVisible()) {
                int n15 = this.hasStyle((byte)2) ? n : n5 + n11;
                int n16 = this.hasStyle((byte)1) ? n3 : n7 - n12;
                component2.setBounds(n15, n8, n16 - n15, n4 - n8);
            }
            if (component3 != null && component3.isVisible()) {
                int n17 = this.hasStyle((byte)8) ? n6 + n9 : n2;
                int n18 = this.hasStyle((byte)2) ? n8 - n10 : n4;
                component3.setBounds(n, n17, n5 - n, n18 - n17);
            }
            if (component4 != null && component4.isVisible()) {
                int n19 = this.hasStyle((byte)4) ? n6 + n9 : n2;
                int n20 = this.hasStyle((byte)1) ? n8 - n10 : n4;
                component4.setBounds(n7, n19, n3 - n7, n20 - n19);
            }
            if (bl) {
                component5.setBounds(n5 + n11, n6 + n9, n7 - n5 - n11 - n12, n8 - n6 - n9 - n10);
            }
        }
    }

    public static String getBorderLayoutEquivalent(Integer n) {
        return BORDERLAYOUT_EQUIV[n];
    }

    public static Integer reverseConstraint(Integer n) {
        switch (n) {
            case 1: {
                return SOUTH;
            }
            case 2: {
                return NORTH;
            }
            case 3: {
                return EAST;
            }
            case 4: {
                return WEST;
            }
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this._hgap + ",vgap=" + this._vgap + "]";
    }
}

