/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;
import oracle.ide.controls.Toolbar;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.resource.ProgressTrackerArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.jndi.Names;

final class ProgressTrackerControl
implements ContextMenuListener,
ActionListener,
ProgressTracker {
    private List _taskList;
    private boolean _containsIndeterminateTask;
    private JProgressBar _progressBar;
    private Timer _timer;
    private ProgressTableDataModel _dataModel;
    private boolean _detailsDisplayed;
    private ContextMenu _contextMenu;
    private IdeAction _detailAction;
    private JMenuItem _detailMenuItem;
    private static final String PROGRESS_TRACKER_NAME = "ide/progressTracker";
    private static final int DETAIL_CMD_ID = Ide.createCmdID("oracle.ide.controls.ProgressTrackerControl.Details");

    void $init$() {
        this._progressBar = new JProgressBar();
    }

    public ProgressTrackerControl() {
        this.$init$();
        this._taskList = new ArrayList();
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)PROGRESS_TRACKER_NAME, (Object)this);
        this._contextMenu = new ContextMenu();
        this._contextMenu.addContextMenuListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _detailItemActionPerformed(ActionEvent actionEvent) {
        if (!this._detailsDisplayed) {
            this._detailsDisplayed = true;
            List list = this._taskList;
            synchronized (list) {
                int n = this._taskList.size();
                if (n > 1) {
                    String[] stringArray = new String[n];
                    ProgressTrackedTask progressTrackedTask = null;
                    int n2 = 0;
                    while (n2 < n) {
                        progressTrackedTask = ((TaskData)this._taskList.get(n2)).getTask();
                        stringArray[n2] = progressTrackedTask.getTaskDescription();
                        ++n2;
                    }
                    this._dataModel = new ProgressTableDataModel(this._taskList);
                    NiceTable niceTable = new NiceTable((TableModel)this._dataModel);
                    JScrollPane jScrollPane = niceTable.getScrollPaneForTable();
                    JEWTDialog jEWTDialog = JEWTDialog.createDialog((Component)((Object)Ide.getMainWindow()), (String)ProgressTrackerArb.getString(4), (int)16);
                    jEWTDialog.setContent((Component)jScrollPane);
                    jEWTDialog.setInitialFocus((Component)niceTable);
                    jEWTDialog.setLocationRelativeTo((Component)this._progressBar);
                    jEWTDialog.setPreferredSize(350, 250);
                    jEWTDialog.setResizable(true);
                    WizardLauncher.runDialog((JDialog)jEWTDialog);
                    jScrollPane.remove((Component)niceTable);
                    this._dataModel.removeTableModelListener((TableModelListener)niceTable);
                    niceTable = null;
                    this._dataModel = null;
                    this._detailsDisplayed = false;
                }
            }
        }
    }

    public void addTask(ProgressTrackedTask progressTrackedTask) {
        this.addTask(progressTrackedTask, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ProgressTrackedTask progressTrackedTask, String string) {
        List list = this._taskList;
        synchronized (list) {
            TaskData taskData = new TaskData(progressTrackedTask, string);
            this._taskList.add(taskData);
            if (progressTrackedTask.isIndeterminate()) {
                this._containsIndeterminateTask = true;
            }
            if (this._timer == null) {
                this._createUI();
                this._timer = new Timer(200, this);
                this._timer.start();
            }
            taskData.getThread().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread(ProgressTrackedTask progressTrackedTask) {
        TaskData taskData = null;
        Thread thread = null;
        List list = this._taskList;
        synchronized (list) {
            int n = this._taskList.size();
            int n2 = 0;
            while (n2 < n) {
                taskData = (TaskData)this._taskList.get(n2);
                if (taskData.getTask() == progressTrackedTask) {
                    thread = taskData.getThread();
                    break;
                }
                ++n2;
            }
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void menuWillShow(ContextMenu contextMenu) {
        if (this._detailMenuItem == null) {
            this._detailAction = IdeAction.get(DETAIL_CMD_ID, ProgressTrackerArb.getString(5), ProgressTrackerArb.getInteger(6));
            this._detailMenuItem = this._contextMenu.createMenuItem(this._detailAction);
            this._detailMenuItem.addActionListener(new 2());
        }
        this._contextMenu.add(this._detailMenuItem);
        List list = this._taskList;
        synchronized (list) {
            int n = this._taskList.size();
            this._detailMenuItem.setEnabled(n > 1);
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this._updateUI();
    }

    public static ProgressTracker getProgressTracker() {
        return (ProgressTracker)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)PROGRESS_TRACKER_NAME);
    }

    static float calculatePctComplete(ProgressTrackedTask progressTrackedTask) {
        return (float)progressTrackedTask.getCurrentValue() / (float)progressTrackedTask.getMaximum() * 100.0f;
    }

    private void _createUI() {
        1 var1_1 = new 1();
        if (SwingUtilities.isEventDispatchThread()) {
            var1_1.run();
        } else {
            SwingUtilities.invokeLater(var1_1);
        }
    }

    private void _destroyUI() {
        this._progressBar.setVisible(false);
        Ide.getStatusBar().getGUI().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateUI() {
        List list = this._taskList;
        synchronized (list) {
            this._removeCompletedTasks();
            if (this._taskList.size() == 1) {
                TaskData taskData = (TaskData)this._taskList.get(0);
                ProgressTrackedTask progressTrackedTask = taskData.getTask();
                if (progressTrackedTask.isIndeterminate()) {
                    this._progressBar.setIndeterminate(true);
                } else {
                    this._progressBar.setMinimum(progressTrackedTask.getMinimum());
                    this._progressBar.setMaximum(progressTrackedTask.getMaximum());
                    this._progressBar.setValue(progressTrackedTask.getCurrentValue());
                }
                if (progressTrackedTask.getCurrentText() == null) {
                    this._progressBar.setString("");
                } else {
                    this._progressBar.setString(progressTrackedTask.getCurrentText());
                }
                this._progressBar.setToolTipText(progressTrackedTask.getTaskDescription());
            } else {
                this._progressBar.setString("");
                if (this._containsIndeterminateTask) {
                    this._progressBar.setIndeterminate(true);
                } else {
                    int n = this._taskList.size();
                    TaskData taskData = null;
                    ProgressTrackedTask progressTrackedTask = null;
                    float f = 0.0f;
                    int n2 = 0;
                    while (n2 < n) {
                        taskData = (TaskData)this._taskList.get(n2);
                        progressTrackedTask = taskData.getTask();
                        f += ProgressTrackerControl.calculatePctComplete(progressTrackedTask);
                        ++n2;
                    }
                    this._progressBar.setMinimum(0);
                    this._progressBar.setMaximum(100);
                    this._progressBar.setValue(Math.round(f / (float)n));
                }
                this._progressBar.setToolTipText(ProgressTrackerArb.format(3, Integer.toString(this._taskList.size())));
                if (this._dataModel != null) {
                    this._dataModel.updateData();
                }
            }
        }
    }

    private void _removeCompletedTasks() {
        int n = this._taskList.size();
        TaskData taskData = null;
        Thread thread = null;
        ArrayList<TaskData> arrayList = new ArrayList<TaskData>();
        int n2 = 0;
        while (n2 < n) {
            taskData = (TaskData)this._taskList.get(n2);
            thread = taskData.getThread();
            if (!thread.isAlive()) {
                arrayList.add(taskData);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            this._removeTask((TaskData)arrayList.get(n3));
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _removeTask(TaskData taskData) {
        List list = this._taskList;
        synchronized (list) {
            if (this._taskList.contains(taskData)) {
                this._taskList.remove(taskData);
            }
            boolean bl = false;
            int n = this._taskList.size();
            if (n == 0) {
                bl = false;
                this._timer.stop();
                this._timer = null;
                this._destroyUI();
            } else {
                ProgressTrackedTask progressTrackedTask = null;
                int n2 = 0;
                while (n2 < n) {
                    progressTrackedTask = ((TaskData)this._taskList.get(n2)).getTask();
                    if (progressTrackedTask.isIndeterminate()) {
                        bl = true;
                        break;
                    }
                    ++n2;
                }
            }
            this._containsIndeterminateTask = bl;
            this._progressBar.setIndeterminate(this._containsIndeterminateTask);
        }
    }

    static void mav$_detailItemActionPerformed(ProgressTrackerControl progressTrackerControl, ActionEvent actionEvent) {
        progressTrackerControl._detailItemActionPerformed(actionEvent);
    }

    static JProgressBar ra$_progressBar(ProgressTrackerControl progressTrackerControl) {
        return progressTrackerControl._progressBar;
    }

    static ContextMenu ra$_contextMenu(ProgressTrackerControl progressTrackerControl) {
        return progressTrackerControl._contextMenu;
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ProgressTrackerControl.mav$_detailItemActionPerformed(ProgressTrackerControl.this, actionEvent);
        }
    }

    final class oracle.ide.controls.ProgressTrackerControl$1
    implements Runnable {
        public void run() {
            Toolbar toolbar = Ide.getStatusBar().getToolbar();
            toolbar.add((Component)ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this), 0);
            Dimension dimension = ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).getMinimumSize();
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setMinimumSize(new Dimension(100, dimension.height));
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setVisible(false);
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).addMouseListener(new 1());
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setStringPainted(true);
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setString("");
            ProgressTrackerControl.ra$_progressBar(ProgressTrackerControl.this).setVisible(true);
        }

        final class 1
        extends MouseAdapter {
            public void mousePressed(MouseEvent mouseEvent) {
                this.triggerPopup(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.triggerPopup(mouseEvent);
            }

            protected void triggerPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    ProgressTrackerControl.ra$_contextMenu(ProgressTrackerControl.this).show(Ide.getMainWindow().getIdeMainWindowView().getContext(mouseEvent));
                }
            }
        }
    }

    private class ProgressTableDataModel
    extends AbstractTableModel {
        private List _taskList;
        private static final int NUM_COLUMNS = 2;
        private static final int TASK_DESCR = 0;
        private static final int PCT_COMPLETE = 1;

        public ProgressTableDataModel(List list) {
            this._taskList = list;
        }

        public int getRowCount() {
            return this._taskList.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return null;
        }

        void updateData() {
            this.fireTableDataChanged();
        }

        public Object getValueAt(int n, int n2) {
            ProgressTrackedTask progressTrackedTask = ((TaskData)this._taskList.get(n)).getTask();
            switch (n2) {
                case 0: {
                    return progressTrackedTask.getTaskDescription();
                }
                case 1: {
                    if (progressTrackedTask.isIndeterminate()) {
                        return ProgressTrackerArb.getString(2);
                    }
                    int n3 = Math.round(ProgressTrackerControl.calculatePctComplete(progressTrackedTask));
                    return new String("" + n3);
                }
            }
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ProgressTrackerArb.getString(0);
                }
                case 1: {
                    return ProgressTrackerArb.getString(1);
                }
            }
            return null;
        }
    }

    private static class TaskData {
        private ProgressTrackedTask _task;
        private Thread _thread;

        public TaskData(ProgressTrackedTask progressTrackedTask, String string) {
            this._task = progressTrackedTask;
            this._thread = new Thread(this._task);
            if (string == null) {
                this._thread.setName(this._task.getTaskDescription());
            } else {
                this._thread.setName(string);
            }
        }

        public ProgressTrackedTask getTask() {
            return this._task;
        }

        public Thread getThread() {
            return this._thread;
        }
    }
}

