/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.ide.controls.MenuItem;
import oracle.ide.controls.ToggleAction;
import oracle.javatools.controls.PropertyChangeAdapter;

public class RadioMenuItem
extends JRadioButtonMenuItem {
    private boolean checkedForIcon;
    private boolean checkedForDisabledIcon;

    public RadioMenuItem(ToggleAction toggleAction) {
        super(toggleAction);
        this.setSelected(toggleAction.getState());
        toggleAction.listenForItemEvent(this);
    }

    protected void configurePropertiesFromAction(Action action) {
        Integer n;
        this.checkedForIcon = false;
        this.checkedForDisabledIcon = false;
        this.setText(action != null ? (String)action.getValue("Name") : null);
        this.setEnabled(action != null ? action.isEnabled() : true);
        if (action != null && (n = (Integer)action.getValue("MnemonicKey")) != null) {
            this.setMnemonic(n);
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new InnerPropertyChangeAdaptor(this, action);
    }

    public Icon getIcon() {
        Action action;
        if (!this.checkedForIcon && (action = this.getAction()) != null) {
            this.checkedForIcon = true;
            this.setIcon((Icon)action.getValue("SmallIcon"));
        }
        return super.getIcon();
    }

    public void setIcon(Icon icon) {
        this.checkedForIcon = true;
        super.setIcon(icon);
    }

    public void setPressedIcon(Icon icon) {
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        super.setPressedIcon(icon);
    }

    public Icon getDisabledIcon() {
        Action action;
        if (!this.checkedForIcon) {
            this.getIcon();
        }
        if (!this.checkedForDisabledIcon && (action = this.getAction()) != null) {
            this.checkedForDisabledIcon = true;
            this.setDisabledIcon((Icon)action.getValue("DisabledIcon"));
        }
        return super.getDisabledIcon();
    }

    public void setDisabledIcon(Icon icon) {
        this.checkedForDisabledIcon = true;
        super.setDisabledIcon(icon);
    }

    public static Icon getRadioButtonMenuItemIcon() {
        return UIManager.getIcon("RadioButtonMenuItem.checkIcon");
    }

    public MenuElement[] getSubElements() {
        return MenuItem.EMPTY_MENU_ELEMENTS;
    }

    private static class InnerPropertyChangeAdaptor
    extends PropertyChangeAdapter {
        public InnerPropertyChangeAdaptor(AbstractButton abstractButton, Action action) {
            super(abstractButton, action);
        }

        protected void stateChanged(PropertyChangeEvent propertyChangeEvent) {
            RadioMenuItem radioMenuItem = (RadioMenuItem)this.getAdaptee();
            Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            1 var4_4 = new 1(this, radioMenuItem, bl);
            if (ToggleAction.PERFORM_ACTION_LATER) {
                SwingUtilities.invokeLater(var4_4);
            } else {
                var4_4.run();
            }
        }

        public final class 1
        implements Runnable {
            private final /* synthetic */ RadioMenuItem v$adaptee;
            private final /* synthetic */ Boolean v$toggledState;
            final /* synthetic */ InnerPropertyChangeAdaptor this$0;

            public void run() {
                if (this.v$adaptee.isSelected() != this.v$toggledState.booleanValue()) {
                    this.v$adaptee.setSelected(this.v$toggledState);
                }
            }

            public 1(InnerPropertyChangeAdaptor innerPropertyChangeAdaptor, RadioMenuItem radioMenuItem, Boolean bl) {
                this.v$toggledState = bl;
                this.v$adaptee = radioMenuItem;
                this.this$0 = innerPropertyChangeAdaptor;
            }
        }
    }
}

